/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.equinox;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.virgo.kernel.osgi.framework.ManifestTransformer;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.osgi.framework.support.AbstractOsgiFramework;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxBootDelegationHelper;
import org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxUtils;
import org.eclipse.virgo.kernel.userregion.internal.equinox.KernelBundleClassLoader;
import org.eclipse.virgo.kernel.userregion.internal.equinox.TransformedManifestProvidingBundleFileWrapper;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class EquinoxOsgiFramework
extends AbstractOsgiFramework {
    private final OsgiServiceHolder<PlatformAdmin> platformAdmin;
    private final EquinoxBootDelegationHelper bootDelegationHelper = new EquinoxBootDelegationHelper(FrameworkProperties.getProperty((String)"org.osgi.framework.bootdelegation"));
    private final TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public EquinoxOsgiFramework(BundleContext context, PackageAdmin packageAdmin, TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler) {
        super(context, packageAdmin);
        this.platformAdmin = OsgiFrameworkUtils.getService((BundleContext)context, PlatformAdmin.class);
        this.bundleTransformationHandler = bundleTransformationHandler;
    }

    public void refresh(Bundle bundle) throws BundleException {
        KernelBundleClassLoader pbcl;
        ClassLoader cl = this.getBundleClassLoader(bundle);
        ArrayList<Bundle> refreshBundles = new ArrayList<Bundle>();
        if (cl instanceof KernelBundleClassLoader && (pbcl = (KernelBundleClassLoader)((Object)cl)).isInstrumented()) {
            Bundle[] dependencies;
            Bundle[] bundleArray = dependencies = this.getDirectDependencies(bundle);
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle dependency = bundleArray[n2];
                if (OsgiFrameworkUtils.sameScope((Bundle)bundle, (Bundle)dependency)) {
                    dependency.update();
                    refreshBundles.add(dependency);
                }
                ++n2;
            }
        }
        bundle.update();
        refreshBundles.add(bundle);
        Bundle[] toRefresh = refreshBundles.toArray(new Bundle[refreshBundles.size()]);
        this.getPackageAdmin().refreshPackages(toRefresh);
    }

    final void stop() {
        if (this.platformAdmin != null) {
            this.getBundleContext().ungetService(this.platformAdmin.getServiceReference());
        }
    }

    public ClassLoader getBundleClassLoader(Bundle bundle) {
        return EquinoxUtils.getBundleClassLoader(bundle);
    }

    public boolean isBootDelegated(String className) {
        if (this.bootDelegationHelper != null) {
            return this.bootDelegationHelper.isBootDelegated(className);
        }
        throw new IllegalStateException("OsgiFramework must have been started prior to querying its boot delegation");
    }

    public Bundle[] getDirectDependencies(Bundle bundle, boolean includeFragments) {
        BundleContext bundleContext = this.getBundleContext();
        ServiceReference serviceRef = bundleContext.getServiceReference(PlatformAdmin.class.getName());
        try {
            PlatformAdmin serverAdmin = (PlatformAdmin)bundleContext.getService(serviceRef);
            Bundle[] bundleArray = EquinoxUtils.getDirectDependencies(bundle, bundleContext, serverAdmin, includeFragments);
            return bundleArray;
        }
        finally {
            bundleContext.ungetService(serviceRef);
        }
    }

    public Bundle[] getDirectDependencies(Bundle bundle) {
        return this.getDirectDependencies(bundle, false);
    }

    public void update(Bundle bundle, ManifestTransformer manifestTransformer) throws BundleException {
        this.bundleTransformationHandler.pushManifestTransformer(manifestTransformer);
        try {
            bundle.update();
        }
        finally {
            this.bundleTransformationHandler.popManifestTransformer();
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.equinox.EquinoxOsgiFramework");
    }
}

