/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.launch.FrameworkFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<T> {
    private static final String CONFIG_FILE_PREFIX = "META-INF/services/";
    private final Class<T> serviceClass;

    private ServiceLoader(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public static <T> ServiceLoader<T> load(Class<T> serviceClass) {
        return new ServiceLoader<T>(serviceClass);
    }

    public Set<T> get() {
        return this.get(ClassLoader.getSystemClassLoader());
    }

    public Set<T> get(ClassLoader classLoader) {
        HashSet<T> results = new HashSet<T>();
        try {
            Enumeration<URL> serviceFiles = this.findServiceFiles(classLoader);
            while (serviceFiles.hasMoreElements()) {
                URL url = serviceFiles.nextElement();
                String implName = this.readImplementationClassName(url);
                Class<?> cl = this.loadImplType(classLoader, implName);
                results.add(this.createInstance(cl));
            }
        }
        catch (IOException e) {
            throw new ServiceLoaderError("Unable to read config locations", e);
        }
        return results;
    }

    private T createInstance(Class<?> cl) {
        try {
            return (T)cl.newInstance();
        }
        catch (Exception e) {
            throw new ServiceLoaderError("Unable to instantiate service provider class '" + cl.getName() + "'", e);
        }
    }

    private Class<?> loadImplType(ClassLoader classLoader, String implName) {
        try {
            return classLoader.loadClass(implName);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceLoaderError("Unable to load service class '" + implName + "' from '" + classLoader + "'", e);
        }
    }

    private Enumeration<URL> findServiceFiles(ClassLoader classLoader) throws IOException {
        String concreteConfigName = CONFIG_FILE_PREFIX + this.serviceClass.getName();
        return classLoader.getResources(concreteConfigName);
    }

    private String readImplementationClassName(URL input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input.openStream()));
        String name = null;
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                String nonComment;
                String trimmed = line.trim();
                if (trimmed.length() <= 0 || (nonComment = this.readNonCommentContent(trimmed)).length() <= 0) continue;
                name = nonComment;
            }
        }
        finally {
            reader.close();
        }
        return name;
    }

    private String readNonCommentContent(String trimmed) {
        int index = trimmed.indexOf("#");
        if (index > -1) {
            return trimmed.substring(0, index);
        }
        return trimmed;
    }

    public static void main(String[] args) {
        ServiceLoader<FrameworkFactory> factory = ServiceLoader.load(FrameworkFactory.class);
        Set<FrameworkFactory> set = factory.get(FrameworkFactory.class.getClassLoader());
        System.out.println(set);
    }

    public static final class ServiceLoaderError
    extends Error {
        private static final long serialVersionUID = 6134843287168204658L;

        public ServiceLoaderError() {
        }

        public ServiceLoaderError(String message, Throwable cause) {
            super(message, cause);
        }

        public ServiceLoaderError(String message) {
            super(message);
        }

        public ServiceLoaderError(Throwable cause) {
            super(cause);
        }
    }
}

