/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.FatalDeploymentException;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper;
import org.eclipse.virgo.kernel.install.artifact.internal.scoping.Scoper;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlanScoper {
    private static final String SCOPE_SEPARATOR = "-";
    private List<InstallArtifact> scopeMembers;
    private final EventLogger eventLogger;
    private final Scoper scoper;
    private final ServiceScoper serviceScoper;
    private final String scopeName;
    private final Version scopeVersion;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public PlanScoper(List<InstallArtifact> scopeMembers, String name, Version version, ScopeServiceRepository scopeServiceRepository, EventLogger eventLogger) throws DeploymentException {
        try {
            this.scopeMembers = scopeMembers;
            this.scopeName = this.createScopeName(name, version);
            this.scopeVersion = version;
            this.scoper = new Scoper(this.getBundleManifests(), this.scopeName);
            this.serviceScoper = new ServiceScoper(this.scopeName, scopeServiceRepository, eventLogger);
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    String getScopeName() {
        try {
            return this.scopeName;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String createScopeName(String name, Version version) {
        try {
            try {
                String scopeName;
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                String string = scopeName = String.valueOf(name) + SCOPE_SEPARATOR + PlanScoper.versionToShortString(version);
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return string;
            }
            catch (Throwable throwable) {
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private List<BundleManifest> getBundleManifests() throws DeploymentException {
        try {
            ArrayList<BundleManifest> bundleManifests = new ArrayList<BundleManifest>();
            for (InstallArtifact scopeMember : this.scopeMembers) {
                if (!(scopeMember instanceof BundleInstallArtifact)) continue;
                BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)scopeMember;
                try {
                    bundleManifests.add(bundleInstallArtifact.getBundleManifest());
                }
                catch (IOException e) {
                    throw new DeploymentException("Cannot access bundle manifest for scoping", e);
                }
            }
            return bundleManifests;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    void scope() throws DeploymentException {
        try {
            try {
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                try {
                    this.scoper.scope();
                }
                catch (Scoper.UnsupportedBundleManifestVersionException ubmve) {
                    throw new FatalDeploymentException("Cannot scope a bundle which does not specify a bundle manifest version of at least " + ubmve.getLowestSupportedVersion());
                }
                catch (Scoper.DuplicateBundleSymbolicNameException dbsne) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.DUPLICATE_BSN_IN_SCOPE, (Throwable)dbsne, new Object[]{this.scopeName, this.scopeVersion, dbsne.getBundleSymbolicName()});
                    throw new DeploymentException("More than one bundle in scope '" + this.scopeName + "' version '" + this.scopeVersion + "' has bundle symbolic name '" + dbsne.getBundleSymbolicName() + "'");
                }
                catch (Scoper.DuplicateExportException dee) {
                    String packageName = dee.getPackageName();
                    String exporters = dee.getExporters();
                    this.eventLogger.log((LogEvent)DeployerLogEvents.DUPLICATE_PACKAGE_DURING_SCOPING, (Throwable)dee, new Object[]{this.scopeName, this.scopeVersion, packageName, exporters});
                    throw new DeploymentException("Package '" + packageName + "' exported by more than one bundle [" + exporters + "] in scope '" + this.scopeName + "' version '" + this.scopeVersion + "'");
                }
                this.serviceScoper.scope(this.getBundleArtifacts());
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Set<ArtifactFS> getBundleArtifacts() {
        try {
            HashSet<ArtifactFS> bundleArtifacts = new HashSet<ArtifactFS>();
            for (InstallArtifact scopeMember : this.scopeMembers) {
                if (!(scopeMember instanceof BundleInstallArtifact)) continue;
                ArtifactFS artifactFS = scopeMember.getArtifactFS();
                bundleArtifacts.add(artifactFS);
            }
            return bundleArtifacts;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String versionToShortString(Version version) {
        try {
            try {
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String result = version.toString();
                while (result.endsWith(".0")) {
                    result = result.substring(0, result.length() - 2);
                }
                String string = result;
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return string;
            }
            catch (Throwable throwable) {
                PlanScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("PlanScoper.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createScopeName", "org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper", "java.lang.String:org.osgi.framework.Version:", "name:version:", "", "java.lang.String"), 93);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "scope", "org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper", "", "", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 121);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "versionToShortString", "org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper", "org.osgi.framework.Version:", "version:", "", "java.lang.String"), 152);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.PlanScoper");
    }
}

