/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.console.supportability;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.virgo.osgi.console.common.ConsoleOutputStream;

public class Grep
extends Thread {
    private String expression;
    private ConsoleOutputStream out;
    private PipedInputStream input;
    private PipedOutputStream output;
    private BufferedReader reader;
    private ArrayList<String> filteredOutput;
    private static int LENGTH = 4;

    public Grep(byte[] expression, OutputStream out) {
        String expr = new String(expression).trim();
        int index = expr.indexOf("grep");
        this.expression = expr.substring(index + LENGTH).trim();
        this.out = (ConsoleOutputStream)out;
        this.input = new PipedInputStream();
        try {
            this.output = new PipedOutputStream(this.input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.out.setOutput(this.output);
        this.filteredOutput = new ArrayList();
    }

    @Override
    public void run() {
        this.reader = new BufferedReader(new InputStreamReader(this.input));
        boolean hasMore = true;
        try {
            while (hasMore) {
                String line = this.getLine();
                boolean bl = hasMore = line != null;
                if (!hasMore) continue;
                if (line.contains(this.expression) || line.contains("osgi>")) {
                    this.filteredOutput.add(line);
                }
                if (!line.contains("osgi>")) continue;
                hasMore = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.out.setOutput(null);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.out)));
        int i = 0;
        while (i < this.filteredOutput.size()) {
            if (i == this.filteredOutput.size() - 1 && this.filteredOutput.get(i).contains("osgi>")) {
                writer.print(this.filteredOutput.get(i));
                writer.print(" ");
            } else {
                writer.println(this.filteredOutput.get(i));
            }
            writer.flush();
            ++i;
        }
    }

    private String getLine() throws IOException {
        StringBuilder line = new StringBuilder();
        boolean quit = false;
        block4: while (!quit) {
            int c = this.reader.read();
            if (c < 0) {
                quit = true;
                continue;
            }
            switch (c) {
                case 13: {
                    break;
                }
                case 10: {
                    return line.toString();
                }
                default: {
                    line.append((char)c);
                    if (!line.toString().contains("osgi>")) continue block4;
                    return line.toString();
                }
            }
        }
        return null;
    }
}

