/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.region.Region;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiBundle;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiImportPackage;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiParameterised;
import org.osgi.framework.Version;

public class StandardQuasiExportPackage
extends StandardQuasiParameterised
implements QuasiExportPackage {
    private final ExportPackageDescription exportPackageDescription;
    private final QuasiBundle exporter;

    public StandardQuasiExportPackage(ExportPackageDescription exportPackageDescription, QuasiBundle exporter) {
        super(exportPackageDescription);
        this.exportPackageDescription = exportPackageDescription;
        this.exporter = exporter;
    }

    public String getPackageName() {
        return this.exportPackageDescription.getName();
    }

    public Version getVersion() {
        return this.exportPackageDescription.getVersion();
    }

    public QuasiBundle getExportingBundle() {
        return this.exporter;
    }

    public List<QuasiImportPackage> getConsumers() {
        BundleDescription[] dependents;
        ArrayList<QuasiImportPackage> consumers = new ArrayList<QuasiImportPackage>();
        BundleDescription[] bundleDescriptionArray = dependents = this.exportPackageDescription.getExporter().getDependents();
        int n = dependents.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription dependentBundle = bundleDescriptionArray[n2];
            ImportPackageSpecification importPackageSpecification = this.findImportingPackageSpecification(dependentBundle);
            if (importPackageSpecification != null) {
                this.addConsumer(dependentBundle, importPackageSpecification, consumers);
            }
            ++n2;
        }
        return consumers;
    }

    private ImportPackageSpecification findImportingPackageSpecification(BundleDescription dependentBundle) {
        ImportPackageSpecification[] importedPackages;
        ImportPackageSpecification[] importPackageSpecificationArray = importedPackages = dependentBundle.getImportPackages();
        int n = importedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importedPackage = importPackageSpecificationArray[n2];
            if (this.exportPackageDescription.equals(importedPackage.getSupplier())) {
                return importedPackage;
            }
            ++n2;
        }
        return null;
    }

    private void addConsumer(BundleDescription dependentBundle, ImportPackageSpecification dependentImportPackage, List<QuasiImportPackage> consumers) {
        Region region = this.exporter.getRegion().getRegionDigraph().getRegion(dependentBundle.getBundleId());
        StandardQuasiBundle importingBundle = new StandardQuasiBundle(dependentBundle, null, region);
        consumers.add(new StandardQuasiImportPackage(dependentImportPackage, importingBundle));
    }

    @Override
    public String toString() {
        return "StandardQuasiExportPackage(" + this.getPackageName() + ", " + this.getVersion().toString() + ", " + super.toString() + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.exportPackageDescription == null ? 0 : this.exportPackageDescription.hashCode());
        result = 31 * result + (this.exporter == null ? 0 : this.exporter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardQuasiExportPackage other = (StandardQuasiExportPackage)obj;
        if (this.exportPackageDescription == null ? other.exportPackageDescription != null : !this.exportPackageDescription.equals(other.exportPackageDescription)) {
            return false;
        }
        return !(this.exporter == null ? other.exporter != null : !this.exporter.equals(other.exporter));
    }
}

