/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipException;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphPersistence;
import org.eclipse.osgi.internal.baseadaptor.StateManager;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.userregion.internal.DumpExtractor;
import org.eclipse.virgo.kernel.userregion.internal.equinox.TransformedManifestProvidingBundleFileWrapper;
import org.eclipse.virgo.kernel.userregion.internal.quasi.ResolutionFailureDetective;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiFramework;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardQuasiFrameworkFactory
implements QuasiFrameworkFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final PlatformAdmin platformAdmin;
    private final StateManager stateManager;
    private final ResolutionFailureDetective detective;
    private final Repository repository;
    private final TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler;
    private final RegionDigraph regionDigraph;
    private final DumpExtractor dumpExtractor;

    public StandardQuasiFrameworkFactory(BundleContext bundleContext, ResolutionFailureDetective detective, Repository repository, TransformedManifestProvidingBundleFileWrapper bundleTransformationHandler, RegionDigraph regionDigraph, DumpExtractor dumpExtractor) {
        this.bundleContext = bundleContext;
        this.platformAdmin = StandardQuasiFrameworkFactory.getPlatformAdminService(bundleContext);
        this.detective = detective;
        this.repository = repository;
        ServiceReference platformAdminServiceReference = bundleContext.getServiceReference(PlatformAdmin.class);
        this.stateManager = (StateManager)bundleContext.getService(platformAdminServiceReference);
        this.bundleTransformationHandler = bundleTransformationHandler;
        this.regionDigraph = regionDigraph;
        this.dumpExtractor = dumpExtractor;
    }

    public QuasiFramework create() {
        return new StandardQuasiFramework(this.bundleContext, this.createState(), this.platformAdmin, this.detective, this.repository, this.bundleTransformationHandler, this.regionDigraph);
    }

    public QuasiFramework create(File dumpDirName) throws ZipException, IOException {
        return this.create(this.dumpExtractor.getStateDump(dumpDirName), this.dumpExtractor.getRegionDigraphDump(dumpDirName));
    }

    private QuasiFramework create(File stateDump, File regionDigraphDump) {
        return new StandardQuasiFramework(this.bundleContext, this.readStateDump(stateDump), this.platformAdmin, this.detective, this.repository, this.bundleTransformationHandler, this.readRegionDigraphDump(regionDigraphDump));
    }

    private RegionDigraph readRegionDigraphDump(File regionDigraphDump) {
        RegionDigraph digraph;
        RegionDigraphPersistence regionDigraphPersistence = this.regionDigraph.getRegionDigraphPersistence();
        try (FileInputStream input = new FileInputStream(regionDigraphDump);){
            digraph = regionDigraphPersistence.load((InputStream)input);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read region digraph dump", e);
        }
        return digraph;
    }

    private State createState() {
        State state;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.platformAdmin.getFactory().writeState(this.stateManager.getSystemState(), (OutputStream)baos);
            state = this.platformAdmin.getFactory().readState((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create a copy of the OSGi state", ioe);
        }
        if (state.getResolver() == null) {
            state.setResolver(this.platformAdmin.createResolver());
        }
        if (!state.isResolved()) {
            state.resolve(true);
        }
        return state;
    }

    private State readStateDump(File outdir) {
        State state = null;
        try {
            try {
                StateObjectFactory sof = this.platformAdmin.getFactory();
                state = sof.readState(outdir);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read resolver state", e);
            }
        }
        finally {
            try {
                if (outdir.isDirectory()) {
                    String[] stringArray = FileSystemUtils.list((File)outdir);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filename = stringArray[n2];
                        File file = new File(outdir, filename);
                        if (!file.delete()) {
                            this.logger.warn("Temporary file '{}' not deleted", (Object)file.getAbsolutePath());
                        }
                        ++n2;
                    }
                }
            }
            finally {
                if (!outdir.delete() && outdir.exists()) {
                    this.logger.warn("Temporary state directory '{}' was not removed after use.", (Object)outdir.getAbsolutePath());
                }
            }
        }
        if (state.getResolver() == null) {
            state.setResolver(this.platformAdmin.createResolver());
        }
        if (!state.isResolved()) {
            state.resolve(true);
        }
        return state;
    }

    private static PlatformAdmin getPlatformAdminService(BundleContext bundleContext) {
        OsgiServiceHolder service = OsgiFrameworkUtils.getService((BundleContext)bundleContext, PlatformAdmin.class);
        PlatformAdmin platformAdmin = (PlatformAdmin)service.getService();
        if (platformAdmin == null) {
            throw new IllegalStateException("Unable to locate PlatformAdmin service");
        }
        return platformAdmin;
    }
}

