/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListExtractor
implements Extractor {
    @Override
    public Class getType() {
        return List.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        List list = (List)pValue;
        int length = pConverter.getCollectionLength(list.size());
        Iterator it = list.iterator();
        if (!pExtraArgs.isEmpty()) {
            int idx = Integer.parseInt(pExtraArgs.pop());
            return pConverter.extractObject(list.get(idx), pExtraArgs, jsonify);
        }
        if (jsonify && !(list instanceof JSONArray)) {
            JSONArray ret = new JSONArray();
            for (int i = 0; i < length; ++i) {
                Object val = it.next();
                ret.add(pConverter.extractObject(val, pExtraArgs, jsonify));
            }
            return ret;
        }
        return list;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        List list = (List)pInner;
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing collection " + pInner + ". (index = " + pIndex + ", value to set = " + pValue + ")", exp);
        }
        Object oldValue = list.get(idx);
        Object value = oldValue != null ? pConverter.prepareValue(oldValue.getClass().getName(), pValue) : pValue;
        list.set(idx, value);
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }
}

