/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.portlet.FrameworkPortlet;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.HandlerExceptionResolver;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.HandlerMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.ModelAndViewDefiningException;
import org.springframework.web.portlet.NoHandlerFoundException;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewRendererServlet;
import org.springframework.web.servlet.ViewResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherPortlet
extends FrameworkPortlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "portletMultipartResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_ADAPTER_BEAN_NAME = "handlerAdapter";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String DEFAULT_VIEW_RENDERER_URL = "/WEB-INF/servlet/view";
    public static final String ACTION_EXCEPTION_SESSION_ATTRIBUTE = String.valueOf(DispatcherPortlet.class.getName()) + ".ACTION_EXCEPTION";
    public static final String ACTION_EXCEPTION_RENDER_PARAMETER = "actionException";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.portlet.PageNotFound";
    private static final String DEFAULT_STRATEGIES_PATH = "DispatcherPortlet.properties";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.portlet.PageNotFound");
    private static final Properties defaultStrategies;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerAdapters = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private String viewRendererUrl = "/WEB-INF/servlet/view";
    private PortletMultipartResolver multipartResolver;
    private List<HandlerMapping> handlerMappings;
    private List<HandlerAdapter> handlerAdapters;
    private List<HandlerExceptionResolver> handlerExceptionResolvers;
    private List<ViewResolver> viewResolvers;

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, DispatcherPortlet.class);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'DispatcherPortlet.properties': " + ex.getMessage());
        }
    }

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerAdapters(boolean detectAllHandlerAdapters) {
        this.detectAllHandlerAdapters = detectAllHandlerAdapters;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    public void setViewRendererUrl(String viewRendererUrl) {
        this.viewRendererUrl = viewRendererUrl;
    }

    @Override
    public void onRefresh(ApplicationContext context) {
        this.initStrategies(context);
    }

    protected void initStrategies(ApplicationContext context) {
        this.initMultipartResolver(context);
        this.initHandlerMappings(context);
        this.initHandlerAdapters(context);
        this.initHandlerExceptionResolvers(context);
        this.initViewResolvers(context);
    }

    private void initMultipartResolver(ApplicationContext context) {
        block3: {
            try {
                this.multipartResolver = (PortletMultipartResolver)context.getBean(MULTIPART_RESOLVER_BEAN_NAME, PortletMultipartResolver.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                this.multipartResolver = null;
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug((Object)"Unable to locate PortletMultipartResolver with name 'portletMultipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initHandlerMappings(ApplicationContext context) {
        this.handlerMappings = null;
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.handlerMappings);
            }
        } else {
            try {
                HandlerMapping hm = (HandlerMapping)context.getBean(HANDLER_MAPPING_BEAN_NAME, HandlerMapping.class);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        if (this.handlerMappings == null) {
            this.handlerMappings = this.getDefaultStrategies(context, HandlerMapping.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerMappings found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters(ApplicationContext context) {
        this.handlerAdapters = null;
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.handlerAdapters);
            }
        } else {
            try {
                HandlerAdapter ha = (HandlerAdapter)context.getBean(HANDLER_ADAPTER_BEAN_NAME, HandlerAdapter.class);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        if (this.handlerAdapters == null) {
            this.handlerAdapters = this.getDefaultStrategies(context, HandlerAdapter.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerAdapters found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers(ApplicationContext context) {
        this.handlerExceptionResolvers = null;
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerExceptionResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.handlerExceptionResolvers);
            }
        } else {
            try {
                HandlerExceptionResolver her = (HandlerExceptionResolver)context.getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME, HandlerExceptionResolver.class);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        if (this.handlerExceptionResolvers == null) {
            this.handlerExceptionResolvers = this.getDefaultStrategies(context, HandlerExceptionResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No HandlerExceptionResolvers found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    private void initViewResolvers(ApplicationContext context) {
        this.viewResolvers = null;
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, ViewResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                OrderComparator.sort(this.viewResolvers);
            }
        } else {
            try {
                ViewResolver vr = (ViewResolver)context.getBean(VIEW_RESOLVER_BEAN_NAME, ViewResolver.class);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = this.getDefaultStrategies(context, ViewResolver.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No ViewResolvers found in portlet '" + this.getPortletName() + "': using default"));
            }
        }
    }

    protected <T> T getDefaultStrategy(ApplicationContext context, Class<T> strategyInterface) {
        List<T> strategies = this.getDefaultStrategies(context, strategyInterface);
        if (strategies.size() != 1) {
            throw new BeanInitializationException("DispatcherPortlet needs exactly 1 strategy for interface [" + strategyInterface.getName() + "]");
        }
        return strategies.get(0);
    }

    protected <T> List<T> getDefaultStrategies(ApplicationContext context, Class<T> strategyInterface) {
        String key = strategyInterface.getName();
        String value = defaultStrategies.getProperty(key);
        if (value != null) {
            String[] classNames = StringUtils.commaDelimitedListToStringArray((String)value);
            ArrayList<Object> strategies = new ArrayList<Object>(classNames.length);
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)DispatcherPortlet.class.getClassLoader());
                    Object strategy = this.createDefaultStrategy(context, clazz);
                    strategies.add(strategy);
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanInitializationException("Could not find DispatcherPortlet's default strategy class [" + className + "] for interface [" + key + "]", (Throwable)ex);
                }
                catch (LinkageError err) {
                    throw new BeanInitializationException("Error loading DispatcherPortlet's default strategy class [" + className + "] for interface [" + key + "]: problem with class file or dependent class", (Throwable)err);
                }
                ++n2;
            }
            return strategies;
        }
        return new LinkedList();
    }

    protected Object createDefaultStrategy(ApplicationContext context, Class<?> clazz) {
        return context.getAutowireCapableBeanFactory().createBean(clazz);
    }

    public PortletMultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doActionService(ActionRequest request, ActionResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherPortlet with name '" + this.getPortletName() + "' received action request"));
        }
        ActionRequest processedRequest = request;
        HandlerExecutionChain mappedHandler = null;
        int interceptorIndex = -1;
        try {
            processedRequest = this.checkMultipart(request);
            mappedHandler = this.getHandler((PortletRequest)processedRequest);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.noHandlerFound((PortletRequest)processedRequest, (PortletResponse)response);
                return;
            }
            try {
                HandlerInterceptor[] interceptors = mappedHandler.getInterceptors();
                if (interceptors != null) {
                    int i = 0;
                    while (i < interceptors.length) {
                        HandlerInterceptor interceptor = interceptors[i];
                        if (!interceptor.preHandleAction(processedRequest, response, mappedHandler.getHandler())) {
                            this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
                            return;
                        }
                        interceptorIndex = i++;
                    }
                }
                HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
                ha.handleAction(processedRequest, response, mappedHandler.getHandler());
                this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
                return;
            }
            catch (Exception ex) {
                this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, ex);
                try {
                    this.exposeActionException((PortletRequest)request, (StateAwareResponse)response, ex);
                    this.logger.debug((Object)"Caught exception during action phase - forwarding to render phase", (Throwable)ex);
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ex;
                }
            }
            catch (Error err) {
                PortletException ex = new PortletException("Error occured during request processing: " + err.getMessage(), (Throwable)err);
                this.triggerAfterActionCompletion(mappedHandler, interceptorIndex, processedRequest, response, (Exception)ex);
                throw ex;
            }
        }
        finally {
            if (processedRequest instanceof MultipartActionRequest && processedRequest != request) {
                this.multipartResolver.cleanupMultipart((MultipartActionRequest)processedRequest);
            }
        }
    }

    @Override
    protected void doRenderService(RenderRequest request, RenderResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherPortlet with name '" + this.getPortletName() + "' received render request"));
        }
        HandlerExecutionChain mappedHandler = null;
        int interceptorIndex = -1;
        try {
            ModelAndView mv;
            try {
                PortletSession session;
                mappedHandler = this.getHandler((PortletRequest)request);
                if (mappedHandler == null || mappedHandler.getHandler() == null) {
                    this.noHandlerFound((PortletRequest)request, (PortletResponse)response);
                    return;
                }
                HandlerInterceptor[] interceptors = mappedHandler.getInterceptors();
                if (interceptors != null) {
                    int i = 0;
                    while (i < interceptors.length) {
                        HandlerInterceptor interceptor = interceptors[i];
                        if (!interceptor.preHandleRender(request, response, mappedHandler.getHandler())) {
                            this.triggerAfterRenderCompletion(mappedHandler, interceptorIndex, request, response, null);
                            return;
                        }
                        interceptorIndex = i++;
                    }
                }
                if ((session = request.getPortletSession(false)) != null) {
                    if (request.getParameter(ACTION_EXCEPTION_RENDER_PARAMETER) != null) {
                        Exception ex = (Exception)session.getAttribute(ACTION_EXCEPTION_SESSION_ATTRIBUTE);
                        if (ex != null) {
                            this.logger.debug((Object)"Render phase found exception caught during action phase - rethrowing it");
                            throw ex;
                        }
                    } else {
                        session.removeAttribute(ACTION_EXCEPTION_SESSION_ATTRIBUTE);
                    }
                }
                HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
                mv = ha.handleRender(request, response, mappedHandler.getHandler());
                if (interceptors != null) {
                    int i = interceptors.length - 1;
                    while (i >= 0) {
                        HandlerInterceptor interceptor = interceptors[i];
                        interceptor.postHandleRender(request, response, mappedHandler.getHandler(), mv);
                        --i;
                    }
                }
            }
            catch (ModelAndViewDefiningException ex) {
                this.logger.debug((Object)"ModelAndViewDefiningException encountered", (Throwable)((Object)ex));
                mv = ex.getModelAndView();
            }
            catch (Exception ex) {
                Object handler = mappedHandler != null ? mappedHandler.getHandler() : null;
                mv = this.processHandlerException(request, response, handler, ex);
            }
            if (mv != null && !mv.isEmpty()) {
                this.render(mv, (PortletRequest)request, (MimeResponse)response);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Null ModelAndView returned to DispatcherPortlet with name '" + this.getPortletName() + "': assuming HandlerAdapter completed request handling"));
            }
            this.triggerAfterRenderCompletion(mappedHandler, interceptorIndex, request, response, null);
        }
        catch (Exception ex) {
            this.triggerAfterRenderCompletion(mappedHandler, interceptorIndex, request, response, ex);
            throw ex;
        }
        catch (Error err) {
            PortletException ex = new PortletException("Error occured during request processing: " + err.getMessage(), (Throwable)err);
            this.triggerAfterRenderCompletion(mappedHandler, interceptorIndex, request, response, (Exception)ex);
            throw ex;
        }
    }

    @Override
    protected void doResourceService(ResourceRequest request, ResourceResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherPortlet with name '" + this.getPortletName() + "' received resource request"));
        }
        HandlerExecutionChain mappedHandler = null;
        int interceptorIndex = -1;
        try {
            ModelAndView mv;
            try {
                mappedHandler = this.getHandler((PortletRequest)request);
                if (mappedHandler == null || mappedHandler.getHandler() == null) {
                    this.noHandlerFound((PortletRequest)request, (PortletResponse)response);
                    return;
                }
                HandlerInterceptor[] interceptors = mappedHandler.getInterceptors();
                if (interceptors != null) {
                    int i = 0;
                    while (i < interceptors.length) {
                        HandlerInterceptor interceptor = interceptors[i];
                        if (!interceptor.preHandleResource(request, response, mappedHandler.getHandler())) {
                            this.triggerAfterResourceCompletion(mappedHandler, interceptorIndex, request, response, null);
                            return;
                        }
                        interceptorIndex = i++;
                    }
                }
                HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
                mv = ha.handleResource(request, response, mappedHandler.getHandler());
                if (interceptors != null) {
                    int i = interceptors.length - 1;
                    while (i >= 0) {
                        HandlerInterceptor interceptor = interceptors[i];
                        interceptor.postHandleResource(request, response, mappedHandler.getHandler(), mv);
                        --i;
                    }
                }
            }
            catch (ModelAndViewDefiningException ex) {
                this.logger.debug((Object)"ModelAndViewDefiningException encountered", (Throwable)((Object)ex));
                mv = ex.getModelAndView();
            }
            catch (Exception ex) {
                Object handler = mappedHandler != null ? mappedHandler.getHandler() : null;
                mv = this.processHandlerException(request, response, handler, ex);
            }
            if (mv != null && !mv.isEmpty()) {
                this.render(mv, (PortletRequest)request, (MimeResponse)response);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Null ModelAndView returned to DispatcherPortlet with name '" + this.getPortletName() + "': assuming HandlerAdapter completed request handling"));
            }
            this.triggerAfterResourceCompletion(mappedHandler, interceptorIndex, request, response, null);
        }
        catch (Exception ex) {
            this.triggerAfterResourceCompletion(mappedHandler, interceptorIndex, request, response, ex);
            throw ex;
        }
        catch (Error err) {
            PortletException ex = new PortletException("Error occured during request processing: " + err.getMessage(), (Throwable)err);
            this.triggerAfterResourceCompletion(mappedHandler, interceptorIndex, request, response, (Exception)ex);
            throw ex;
        }
    }

    @Override
    protected void doEventService(EventRequest request, EventResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherPortlet with name '" + this.getPortletName() + "' received action request"));
        }
        HandlerExecutionChain mappedHandler = null;
        int interceptorIndex = -1;
        try {
            mappedHandler = this.getHandler((PortletRequest)request);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.noHandlerFound((PortletRequest)request, (PortletResponse)response);
                return;
            }
            HandlerInterceptor[] interceptors = mappedHandler.getInterceptors();
            if (interceptors != null) {
                int i = 0;
                while (i < interceptors.length) {
                    HandlerInterceptor interceptor = interceptors[i];
                    if (!interceptor.preHandleEvent(request, response, mappedHandler.getHandler())) {
                        this.triggerAfterEventCompletion(mappedHandler, interceptorIndex, request, response, null);
                        return;
                    }
                    interceptorIndex = i++;
                }
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            ha.handleEvent(request, response, mappedHandler.getHandler());
            this.triggerAfterEventCompletion(mappedHandler, interceptorIndex, request, response, null);
        }
        catch (Exception ex) {
            this.triggerAfterEventCompletion(mappedHandler, interceptorIndex, request, response, ex);
            try {
                this.exposeActionException((PortletRequest)request, (StateAwareResponse)response, ex);
                this.logger.debug((Object)"Caught exception during event phase - forwarding to render phase", (Throwable)ex);
            }
            catch (IllegalStateException illegalStateException) {
                throw ex;
            }
        }
        catch (Error err) {
            PortletException ex = new PortletException("Error occured during request processing: " + err.getMessage(), (Throwable)err);
            this.triggerAfterEventCompletion(mappedHandler, interceptorIndex, request, response, (Exception)ex);
            throw ex;
        }
    }

    protected ActionRequest checkMultipart(ActionRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartActionRequest) {
                this.logger.debug((Object)"Request is already a MultipartActionRequest - probably in a forward");
            } else {
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    protected HandlerExecutionChain getHandler(PortletRequest request) throws Exception {
        for (HandlerMapping hm : this.handlerMappings) {
            HandlerExecutionChain handler;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherPortlet with name '" + this.getPortletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            return handler;
        }
        return null;
    }

    protected void noHandlerFound(PortletRequest request, PortletResponse response) throws Exception {
        if (pageNotFoundLogger.isWarnEnabled()) {
            pageNotFoundLogger.warn((Object)("No handler found for current request in DispatcherPortlet with name '" + this.getPortletName() + "', mode '" + request.getPortletMode() + "', phase '" + request.getAttribute("javax.portlet.lifecycle_phase") + "', parameters " + StylerUtils.style((Object)request.getParameterMap())));
        }
        throw new NoHandlerFoundException("No handler found for portlet request", request);
    }

    protected HandlerAdapter getHandlerAdapter(Object handler) throws PortletException {
        for (HandlerAdapter ha : this.handlerAdapters) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new PortletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    protected void exposeActionException(PortletRequest request, StateAwareResponse response, Exception ex) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            if (paramValues == null || response.getRenderParameterMap().containsKey(paramName)) continue;
            response.setRenderParameter(paramName, paramValues);
        }
        response.setRenderParameter(ACTION_EXCEPTION_RENDER_PARAMETER, ex.toString());
        request.getPortletSession().setAttribute(ACTION_EXCEPTION_SESSION_ATTRIBUTE, (Object)ex);
    }

    protected void render(ModelAndView mv, PortletRequest request, MimeResponse response) throws Exception {
        View view;
        if (mv.isReference()) {
            view = this.resolveViewName(mv.getViewName(), mv.getModelInternal(), request);
            if (view == null) {
                throw new PortletException("Could not resolve view with name '" + mv.getViewName() + "' in portlet with name '" + this.getPortletName() + "'");
            }
        } else {
            Object viewObject = mv.getView();
            if (viewObject == null) {
                throw new PortletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in portlet with name '" + this.getPortletName() + "'");
            }
            if (!(viewObject instanceof View)) {
                throw new PortletException("View object [" + viewObject + "] is not an instance of [org.springframework.web.servlet.View] - " + "DispatcherPortlet does not support any other view types");
            }
            view = (View)viewObject;
        }
        if (response.getContentType() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Portlet response content type already set to [" + response.getContentType() + "]"));
            }
        } else {
            String contentType = view.getContentType();
            if (contentType != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting portlet response content type to view-determined type [" + contentType + "]"));
                }
                response.setContentType(contentType);
            }
        }
        this.doRender(view, mv.getModelInternal(), request, response);
    }

    protected View resolveViewName(String viewName, Map model, PortletRequest request) throws Exception {
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, request.getLocale());
            if (view == null) continue;
            return view;
        }
        return null;
    }

    protected void doRender(View view, Map model, PortletRequest request, MimeResponse response) throws Exception {
        request.setAttribute(ViewRendererServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getPortletApplicationContext());
        request.setAttribute(ViewRendererServlet.VIEW_ATTRIBUTE, (Object)view);
        request.setAttribute(ViewRendererServlet.MODEL_ATTRIBUTE, (Object)model);
        this.getPortletContext().getRequestDispatcher(this.viewRendererUrl).include(request, (PortletResponse)response);
    }

    protected ModelAndView processHandlerException(RenderRequest request, RenderResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator<HandlerExceptionResolver> it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
            }
            this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
            return exMv;
        }
        throw ex;
    }

    protected ModelAndView processHandlerException(ResourceRequest request, ResourceResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator<HandlerExceptionResolver> it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
            }
            this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
            return exMv;
        }
        throw ex;
    }

    private void triggerAfterActionCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, ActionRequest request, ActionResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            int i = interceptorIndex;
            while (i >= 0) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterActionCompletion(request, response, mappedHandler.getHandler(), ex);
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
                --i;
            }
        }
    }

    private void triggerAfterRenderCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, RenderRequest request, RenderResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            int i = interceptorIndex;
            while (i >= 0) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterRenderCompletion(request, response, mappedHandler.getHandler(), ex);
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
                --i;
            }
        }
    }

    private void triggerAfterResourceCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, ResourceRequest request, ResourceResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            int i = interceptorIndex;
            while (i >= 0) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterResourceCompletion(request, response, mappedHandler.getHandler(), ex);
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
                --i;
            }
        }
    }

    private void triggerAfterEventCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, EventRequest request, EventResponse response, Exception ex) throws Exception {
        HandlerInterceptor[] interceptors;
        if (mappedHandler != null && (interceptors = mappedHandler.getInterceptors()) != null) {
            int i = interceptorIndex;
            while (i >= 0) {
                HandlerInterceptor interceptor = interceptors[i];
                try {
                    interceptor.afterEventCompletion(request, response, mappedHandler.getHandler(), ex);
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
                --i;
            }
        }
    }
}

