/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.runtime.internal.core.utils.StatusUtil;
import org.eclipse.virgo.ide.runtime.internal.ui.Messages;
import org.eclipse.virgo.ide.runtime.internal.ui.PDEHelper;
import org.eclipse.virgo.ide.runtime.internal.ui.PDEUIMessages;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDETargetPlatformComposite
extends Composite {
    private List<File> folders;
    private final Button enablePDEDevelopmentButton;
    private final TableViewer foldersTableViewer;
    private final Button addButton;
    private final Button removeButton;
    private final Button editButton;
    private final Label comment;
    private final IRunnableContext runnableContext;
    private final IRuntimeWorkingCopy runtimeWorkingCopy;
    private boolean repositoryConfigurationChanged;

    public PDETargetPlatformComposite(Composite parent, IRunnableContext runnableContext, IRuntimeWorkingCopy iRuntimeWorkingCopy) {
        super(parent, 0);
        this.runnableContext = runnableContext;
        this.runtimeWorkingCopy = iRuntimeWorkingCopy;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        this.enablePDEDevelopmentButton = new Button((Composite)this, 32);
        this.enablePDEDevelopmentButton.setSelection(false);
        this.enablePDEDevelopmentButton.setText(Messages.PDETargetPlatformComposite_enable_checkbox);
        this.enablePDEDevelopmentButton.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, -1).create());
        this.foldersTableViewer = new TableViewer((Composite)this);
        this.foldersTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.foldersTableViewer.setSorter(new ViewerSorter());
        this.foldersTableViewer.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.foldersTableViewer.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(1, 3).create());
        this.foldersTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = PDETargetPlatformComposite.this.foldersTableViewer.getStructuredSelection().size();
                PDETargetPlatformComposite.this.editButton.setEnabled(size == 1);
                PDETargetPlatformComposite.this.removeButton.setEnabled(size > 0);
            }
        });
        this.addButton = new Button((Composite)this, 8);
        this.addButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.addButton.setText(Messages.PDETargetPlatformComposite_add);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDETargetPlatformComposite.this.addPressed(e);
            }
        });
        this.removeButton = new Button((Composite)this, 8);
        this.removeButton.setText(Messages.PDETargetPlatformComposite_remove);
        this.removeButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDETargetPlatformComposite.this.removePressed(e);
            }
        });
        this.editButton = new Button((Composite)this, 8);
        this.editButton.setText(Messages.PDETargetPlatformComposite_edit);
        this.editButton.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 128).create());
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDETargetPlatformComposite.this.editPressed(e);
            }
        });
        this.comment = new Label((Composite)this, 64);
        this.comment.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, -1).create());
        this.comment.setText(Messages.PDETargetPlatformComposite_note);
        if (PDEHelper.existsTargetDefinition(this.runtimeWorkingCopy.getName())) {
            this.enableTargetPlatform(true);
            this.enablePDEDevelopmentButton.setSelection(true);
        } else {
            this.enableTargetPlatform(false);
        }
        this.enablePDEDevelopmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDETargetPlatformComposite.this.enableButtonSelected(e);
            }
        });
    }

    protected void editPressed(SelectionEvent e) {
        DirectoryDialog dlg = new DirectoryDialog(e.display.getActiveShell());
        dlg.setText(Messages.PDETargetPlatformComposite_edit_dialog_title);
        dlg.setMessage(Messages.PDETargetPlatformComposite_edit_dialog_message);
        String path = dlg.open();
        if (path != null) {
            LinkedHashSet<File> folders2 = new LinkedHashSet<File>(this.getTargetPlatformFolders());
            folders2.remove(this.foldersTableViewer.getStructuredSelection().getFirstElement());
            folders2.add(new File(path));
            ArrayList<File> folders3 = new ArrayList<File>(folders2);
            this.setTableInput(folders3);
            this.repositoryConfigurationChanged = true;
        }
    }

    protected void removePressed(SelectionEvent e) {
        LinkedHashSet<File> folders2 = new LinkedHashSet<File>(this.getTargetPlatformFolders());
        folders2.removeAll(this.foldersTableViewer.getStructuredSelection().toList());
        ArrayList<File> folders3 = new ArrayList<File>(folders2);
        this.setTableInput(folders3);
        this.repositoryConfigurationChanged = true;
    }

    protected void addPressed(SelectionEvent e) {
        DirectoryDialog dlg = new DirectoryDialog(e.display.getActiveShell());
        dlg.setText(Messages.PDETargetPlatformComposite_add_dialog_title);
        dlg.setMessage(Messages.PDETargetPlatformComposite_add_dialog_message);
        String path = dlg.open();
        if (path != null) {
            LinkedHashSet<File> folders2 = new LinkedHashSet<File>(this.getTargetPlatformFolders());
            folders2.add(new File(path));
            ArrayList<File> folders3 = new ArrayList<File>(folders2);
            this.setTableInput(folders3);
            this.repositoryConfigurationChanged = true;
        }
    }

    protected void enableButtonSelected(SelectionEvent e) {
        this.enableTargetPlatform(this.enablePDEDevelopmentButton.getSelection());
    }

    protected void enableTargetPlatform(boolean enabled) {
        this.comment.setEnabled(enabled);
        this.foldersTableViewer.getTable().setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        if (enabled) {
            try {
                this.runnableContext.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        PDETargetPlatformComposite.this.folders = PDEHelper.getFoldersForTargetDefinition(PDETargetPlatformComposite.this.runtimeWorkingCopy);
                        monitor.done();
                        if (PDETargetPlatformComposite.this.foldersTableViewer.getTable() != null && !PDETargetPlatformComposite.this.foldersTableViewer.getTable().isDisposed()) {
                            PDETargetPlatformComposite.this.foldersTableViewer.getTable().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    PDETargetPlatformComposite.this.foldersTableViewer.setInput((Object)PDETargetPlatformComposite.this.folders);
                                }
                            });
                        }
                    }
                });
            }
            catch (Exception e) {
                StatusUtil.error((String)Messages.PDETargetPlatformComposite_error_message, (Exception)e, (int)3);
            }
        } else {
            this.foldersTableViewer.setInput(Collections.emptyList());
        }
    }

    public Button getEnablePDEDevelopmentButton() {
        return this.enablePDEDevelopmentButton;
    }

    public void setTableInput(List<File> targetPlatformFolders) {
        this.folders = targetPlatformFolders;
        this.foldersTableViewer.setInput(targetPlatformFolders);
    }

    public List<File> getTargetPlatformFolders() {
        return this.folders;
    }

    public boolean isRepositoryConfigurationChanged() {
        return this.repositoryConfigurationChanged;
    }

    public void performFinish(IProgressMonitor monitor) {
        final List<File> folders = this.getTargetPlatformFolders();
        boolean changed = this.isRepositoryConfigurationChanged();
        Status st = PDEHelper.createTargetDefinition(monitor, this.runtimeWorkingCopy, folders);
        if (!st.isOK()) {
            StatusManager.getManager().handle((IStatus)st, 3);
        } else if (changed) {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    boolean applyToRepository = MessageDialog.openQuestion((Shell)PDETargetPlatformComposite.this.getShell(), (String)PDEUIMessages.PDETargetPlatformWizardFragment_update_dialog_title, (String)PDEUIMessages.PDETargetPlatformWizardFragment_update_dialog_message);
                    if (applyToRepository) {
                        try {
                            PDEHelper.updateRepositoryConfiguration(PDETargetPlatformComposite.this.runtimeWorkingCopy, folders);
                        }
                        catch (IOException e) {
                            StatusUtil.error((String)PDEUIMessages.PDETargetPlatformWizardFragment_update_dialog_error, (Exception)e, (int)3);
                        }
                    }
                }
            });
        }
    }

    class DirectoryLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        DirectoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element != null ? element.toString() : null;
        }
    }
}

