/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.ui.properties;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.virgo.ide.module.core.ServerModuleDelegate;

public class TestSourceFolderPreferencePage
extends PropertyPage {
    private IProject project;
    private boolean modified = false;
    private CheckboxTableViewer listViewer;
    private static final int PROJECT_LIST_MULTIPLIER = 30;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.initialize();
        Label description = this.createDescriptionLabel(composite);
        description.setLayoutData((Object)new GridData(4, 128, true, false));
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2176);
        this.listViewer.getTable().setFont(font);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        if (this.project != null && !this.project.isOpen()) {
            this.listViewer.getControl().setEnabled(false);
        }
        if (DialogUtil.inRegularFontMode((Composite)parent)) {
            data.heightHint = TestSourceFolderPreferencePage.getDefaultFontHeight((Control)this.listViewer.getTable(), 30);
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(font);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ClasspathEntryLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)new ClasspathEntryContentProvider());
        this.listViewer.setComparator(new ViewerComparator());
        this.listViewer.setInput((Object)this.project);
        this.listViewer.setCheckedElements(ServerModuleDelegate.getSourceClasspathEntries((IProject)this.project, (boolean)true).toArray());
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TestSourceFolderPreferencePage.this.modified = true;
            }
        });
        return composite;
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        this.noDefaultAndApplyButton();
        this.setDescription("Select Java source folders that contain unit and integration test classes.\nThe contents of those test folders will not get deployed to any server runtime.");
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        try {
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = JavaCore.create((IProject)this.project).getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    HashSet<IClasspathAttribute> attrs = new HashSet<IClasspathAttribute>();
                    IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
                    int n3 = iClasspathAttributeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathAttribute attr = iClasspathAttributeArray[n4];
                        if (!attr.getName().equals("org.eclipse.virgo.ide.jdt.core.test.classpathentry")) {
                            attrs.add(attr);
                        }
                        ++n4;
                    }
                    attrs.add(this.getClasspathAttribute(entry));
                    entries.add(JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])attrs.toArray(new IClasspathAttribute[attrs.size()])));
                } else {
                    entries.add(entry);
                }
                ++n2;
            }
            JavaCore.create((IProject)this.project).setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return true;
    }

    private IClasspathAttribute getClasspathAttribute(IClasspathEntry entry) {
        Object[] testFolders;
        IClasspathAttribute testFolderAttribute = JavaCore.newClasspathAttribute((String)"org.eclipse.virgo.ide.jdt.core.test.classpathentry", (String)"true");
        IClasspathAttribute sourceFolderAttribute = JavaCore.newClasspathAttribute((String)"org.eclipse.virgo.ide.jdt.core.test.classpathentry", (String)"false");
        Object[] objectArray = testFolders = this.listViewer.getCheckedElements();
        int n = testFolders.length;
        int n2 = 0;
        while (n2 < n) {
            Object testFolder = objectArray[n2];
            if (((IClasspathEntry)testFolder).getPath().equals((Object)entry.getPath())) {
                return testFolderAttribute;
            }
            ++n2;
        }
        return sourceFolderAttribute;
    }

    class ClasspathEntryContentProvider
    implements IStructuredContentProvider {
        ClasspathEntryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject) {
                ArrayList<IClasspathEntry> sourceFolders = new ArrayList<IClasspathEntry>();
                try {
                    IClasspathEntry[] iClasspathEntryArray = JavaCore.create((IProject)TestSourceFolderPreferencePage.this.project).getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3) {
                            sourceFolders.add(entry);
                        }
                        ++n2;
                    }
                    return sourceFolders.toArray(new IClasspathEntry[sourceFolders.size()]);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ClasspathEntryLabelProvider
    implements ILabelProvider {
        ClasspathEntryLabelProvider() {
        }

        public Image getImage(Object element) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packagefolder_obj.gif");
        }

        public String getText(Object element) {
            return ((IClasspathEntry)element).getPath().toString().substring(1);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

