/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.eclipse.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.virgo.ide.eclipse.wizards.NewJavaProjectWizardConstants;

@Deprecated
public class NewJavaProjectWizardPageOneCOPY
extends WizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPageOne";
    private final NameGroup fNameGroup;
    private final LocationGroup fLocationGroup;
    private final LayoutGroup fLayoutGroup;
    private final JREGroup fJREGroup;
    private final DetectGroup fDetectGroup;
    private final Validator fValidator;

    public NewJavaProjectWizardPageOneCOPY() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_page_title);
        this.setDescription(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_page_description);
        this.fNameGroup = new NameGroup();
        this.fLocationGroup = new LocationGroup();
        this.fJREGroup = new JREGroup();
        this.fLayoutGroup = new LayoutGroup();
        this.fDetectGroup = new DetectGroup();
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fDetectGroup.addObserver(this.fLayoutGroup);
        this.fDetectGroup.addObserver(this.fJREGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setProjectName("");
        this.setProjectLocationURI(null);
        this.initializeDefaultVM();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        Control nameControl = this.createNameControl(composite);
        nameControl.setLayoutData((Object)new GridData(768));
        Control locationControl = this.createLocationControl(composite);
        locationControl.setLayoutData((Object)new GridData(768));
        Control jreControl = this.createJRESelectionControl(composite);
        jreControl.setLayoutData((Object)new GridData(768));
        Control layoutControl = this.createProjectLayoutControl(composite);
        layoutControl.setLayoutData((Object)new GridData(768));
        Control infoControl = this.createInfoControl(composite);
        infoControl.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
    }

    protected Control createInfoControl(Composite composite) {
        return this.fDetectGroup.createControl(composite);
    }

    protected Control createJRESelectionControl(Composite composite) {
        return this.fJREGroup.createControl(composite);
    }

    protected Control createLocationControl(Composite composite) {
        return this.fLocationGroup.createControl(composite);
    }

    protected Control createNameControl(Composite composite) {
        return this.fNameGroup.createControl(composite);
    }

    protected Control createProjectLayoutControl(Composite composite) {
        return this.fLayoutGroup.createContent(composite);
    }

    public String getCompilerCompliance() {
        return this.fJREGroup.getSelectedCompilerCompliance();
    }

    public IClasspathEntry[] getDefaultClasspathEntries() {
        IClasspathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
        String compliance = this.getCompilerCompliance();
        Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
        if (compliance == null || defaultJRELibrary.length > 1 || !jreContainerPath.isPrefixOf(defaultJRELibrary[0].getPath())) {
            return defaultJRELibrary;
        }
        IPath newPath = this.fJREGroup.getJREContainerPath();
        if (newPath != null) {
            return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)newPath)};
        }
        return defaultJRELibrary;
    }

    public IPath getOutputLocation() {
        Path binPath;
        IPath outputLocationPath = new Path(this.getProjectName()).makeAbsolute();
        if (this.fLayoutGroup.isSrcBin() && (binPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"))).segmentCount() > 0) {
            outputLocationPath = outputLocationPath.append((IPath)binPath);
        }
        return outputLocationPath;
    }

    public URI getProjectLocationURI() {
        if (this.fLocationGroup.isLocationInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fLocationGroup.getLocation());
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public IClasspathEntry[] getSourceClasspathEntries() {
        Path srcPath;
        IPath sourceFolderPath = new Path(this.getProjectName()).makeAbsolute();
        if (this.fLayoutGroup.isSrcBin() && (srcPath = new Path(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"))).segmentCount() > 0) {
            sourceFolderPath = sourceFolderPath.append((IPath)srcPath);
        }
        return new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)sourceFolderPath)};
    }

    public void init(IStructuredSelection selection, IWorkbenchPart activePart) {
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private void initializeDefaultVM() {
        JavaRuntime.getDefaultVMInstall();
    }

    protected void setControl(Control newControl) {
        Dialog.applyDialogFont((Control)newControl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(newControl, "org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
        super.setControl(newControl);
    }

    public void setProjectLocationURI(URI uri) {
        IPath path = uri != null ? URIUtil.toPath((URI)uri) : null;
        this.fLocationGroup.setLocation(path);
    }

    public void setProjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.fNameGroup.setName(name);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private Link fHintText;
        private Label fIcon;
        private boolean fDetect = false;

        private boolean computeDetectState() {
            if (NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.isWorkspaceRadioSelected()) {
                String name = NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName();
                if (name.length() == 0 || JavaPlugin.getWorkspace().getRoot().findMember(name) != null) {
                    return false;
                }
                File directory = NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.getLocation().append(name).toFile();
                return directory.isDirectory();
            }
            File directory = NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.getLocation().toFile();
            return directory.isDirectory();
        }

        public Control createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 10;
            composite.setLayout((Layout)layout);
            this.fIcon = new Label(composite, 16384);
            this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            this.fIcon.setLayoutData((Object)gridData);
            this.fHintText = new Link(composite, 64);
            this.fHintText.setFont(composite.getFont());
            this.fHintText.addSelectionListener((SelectionListener)this);
            gridData = new GridData(4, 4, true, true);
            gridData.widthHint = NewJavaProjectWizardPageOneCOPY.this.convertWidthInCharsToPixels(50);
            gridData.heightHint = NewJavaProjectWizardPageOneCOPY.this.convertHeightInCharsToPixels(3);
            this.fHintText.setLayoutData((Object)gridData);
            this.handlePossibleJVMChange();
            return composite;
        }

        public void handlePossibleJVMChange() {
            if (JavaRuntime.getDefaultVMInstall() == null) {
                this.fHintText.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_NoJREFound_link);
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
                return;
            }
            String selectedCompliance = NewJavaProjectWizardPageOneCOPY.this.fJREGroup.getSelectedCompilerCompliance();
            if (selectedCompliance != null) {
                String defaultCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
                if (selectedCompliance.equals(defaultCompliance)) {
                    this.fHintText.setVisible(false);
                    this.fIcon.setVisible(false);
                } else {
                    this.fHintText.setText(Messages.format((String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_DetectGroup_differendWorkspaceCC_message, (Object[])new String[]{defaultCompliance, selectedCompliance}));
                    this.fHintText.setVisible(true);
                    this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                    this.fIcon.setVisible(true);
                }
                return;
            }
            selectedCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
            IVMInstall selectedJVM = NewJavaProjectWizardPageOneCOPY.this.fJREGroup.getSelectedJVM();
            if (selectedJVM == null) {
                selectedJVM = JavaRuntime.getDefaultVMInstall();
            }
            String jvmCompliance = "1.4";
            if (selectedJVM instanceof IVMInstall2) {
                jvmCompliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)selectedJVM), (String)"1.4");
            }
            if (!selectedCompliance.equals(jvmCompliance) && (JavaModelUtil.is50OrHigher((String)selectedCompliance) || JavaModelUtil.is50OrHigher((String)jvmCompliance))) {
                if (selectedCompliance.equals("1.5")) {
                    selectedCompliance = "5.0";
                } else if (selectedCompliance.equals("1.6")) {
                    selectedCompliance = "6.0";
                }
                this.fHintText.setText(Messages.format((String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_DetectGroup_jre_message, (Object[])new String[]{selectedCompliance, jvmCompliance}));
                this.fHintText.setVisible(true);
                this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.fIcon.setVisible(true);
            } else {
                this.fHintText.setVisible(false);
                this.fIcon.setVisible(false);
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                this.fDetect = this.computeDetectState();
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_DetectGroup_message);
                        this.fIcon.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                        this.fIcon.setVisible(true);
                    } else {
                        this.handlePossibleJVMChange();
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            String id = "JRE".equals(e.text) ? jreID : complianceId;
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaProjectWizardPageOneCOPY.this.getShell(), (String)id, (String[])new String[]{jreID, complianceId}, data).open();
            NewJavaProjectWizardPageOneCOPY.this.fJREGroup.handlePossibleJVMChange();
            this.handlePossibleJVMChange();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }

    private final class JREGroup
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private static final String LAST_SELECTED_EE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.execution.enviroment";
        private static final String LAST_SELECTED_JRE_SETTINGS_KEY = "org.eclipse.jdt.ui.last.selected.project.jre";
        private static final String LAST_SELECTED_JRE_KIND = "org.eclipse.jdt.ui.last.selected.jre.kind";
        private static final int DEFAULT_JRE = 0;
        private static final int PROJECT_JRE = 1;
        private static final int EE_JRE = 2;
        private final SelectionButtonDialogField fUseDefaultJRE = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fUseProjectJRE;
        private final SelectionButtonDialogField fUseEEJRE;
        private final ComboDialogField fJRECombo;
        private final ComboDialogField fEECombo;
        private Group fGroup;
        private Link fPreferenceLink;
        private IVMInstall[] fInstalledJVMs;
        private String[] fJRECompliance;
        private IExecutionEnvironment[] fInstalledEEs;
        private String[] fEECompliance;

        public JREGroup() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fUseProjectJRE = new SelectionButtonDialogField(16);
            this.fUseProjectJRE.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_JREGroup_specific_compliance);
            this.fJRECombo = new ComboDialogField(8);
            this.fillInstalledJREs(this.fJRECombo);
            this.fJRECombo.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseEEJRE = new SelectionButtonDialogField(16);
            this.fUseEEJRE.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_JREGroup_specific_EE);
            this.fEECombo = new ComboDialogField(8);
            this.fillExecutionEnvironments(this.fEECombo);
            this.fEECombo.setDialogFieldListener((IDialogFieldListener)this);
            switch (this.getLastSelectedJREKind()) {
                case 0: {
                    this.fUseDefaultJRE.setSelection(true);
                    break;
                }
                case 1: {
                    this.fUseProjectJRE.setSelection(true);
                    break;
                }
                case 2: {
                    this.fUseEEJRE.setSelection(true);
                }
            }
            this.fJRECombo.setEnabled(this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(this.fUseEEJRE.isSelected());
            this.fUseDefaultJRE.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseProjectJRE.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseEEJRE.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayout((Layout)NewJavaProjectWizardPageOneCOPY.this.initGridLayout(new GridLayout(2, false), true));
            this.fGroup.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_JREGroup_title);
            this.fUseDefaultJRE.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_JREGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            Composite nonDefaultJREComposite = new Composite((Composite)this.fGroup, 0);
            nonDefaultJREComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            nonDefaultJREComposite.setLayout((Layout)layout);
            this.fUseProjectJRE.doFillIntoGrid(nonDefaultJREComposite, 1);
            Combo comboControl = this.fJRECombo.getComboControl(nonDefaultJREComposite);
            comboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            comboControl.setVisibleItemCount(30);
            this.fUseEEJRE.doFillIntoGrid(nonDefaultJREComposite, 1);
            Combo eeComboControl = this.fEECombo.getComboControl(nonDefaultJREComposite);
            eeComboControl.setLayoutData((Object)new GridData(4, 2, true, false));
            eeComboControl.setVisibleItemCount(30);
            this.updateEnableState();
            return this.fGroup;
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
            NewJavaProjectWizardPageOneCOPY.this.fDetectGroup.handlePossibleJVMChange();
            if (field == this.fJRECombo) {
                if (this.fUseProjectJRE.isSelected()) {
                    this.storeSelectionValue(this.fJRECombo, LAST_SELECTED_JRE_SETTINGS_KEY);
                }
            } else if (field == this.fEECombo) {
                if (this.fUseEEJRE.isSelected()) {
                    this.storeSelectionValue(this.fEECombo, LAST_SELECTED_EE_SETTINGS_KEY);
                }
            } else if (field == this.fUseDefaultJRE) {
                if (this.fUseDefaultJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 0);
                    this.fUseProjectJRE.setSelection(false);
                    this.fUseEEJRE.setSelection(false);
                }
            } else if (field == this.fUseProjectJRE) {
                if (this.fUseProjectJRE.isSelected()) {
                    JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 1);
                    this.fUseDefaultJRE.setSelection(false);
                    this.fUseEEJRE.setSelection(false);
                }
            } else if (field == this.fUseEEJRE && this.fUseEEJRE.isSelected()) {
                JavaPlugin.getDefault().getDialogSettings().put(LAST_SELECTED_JRE_KIND, 2);
                this.fUseDefaultJRE.setSelection(false);
                this.fUseProjectJRE.setSelection(false);
            }
        }

        private void fillExecutionEnvironments(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedEE();
            int selectionIndex = -1;
            if (this.fUseEEJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledEEs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            Arrays.sort(this.fInstalledEEs, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return Policy.getComparator().compare(((IExecutionEnvironment)arg0).getId(), ((IExecutionEnvironment)arg1).getId());
                }
            });
            selectionIndex = -1;
            String[] eeLabels = new String[this.fInstalledEEs.length];
            this.fEECompliance = new String[this.fInstalledEEs.length];
            int i = 0;
            while (i < this.fInstalledEEs.length) {
                eeLabels[i] = this.fInstalledEEs[i].getId();
                if (selectedItem != null && eeLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fEECompliance[i] = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)this.fInstalledEEs[i]);
                ++i;
            }
            comboField.setItems(eeLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultEEName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private void fillInstalledJREs(ComboDialogField comboField) {
            String selectedItem = this.getLastSelectedJRE();
            int selectionIndex = -1;
            if (this.fUseProjectJRE.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledJVMs = this.getWorkspaceJREs();
            Arrays.sort(this.fInstalledJVMs, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    IVMInstall i0 = (IVMInstall)arg0;
                    IVMInstall i1 = (IVMInstall)arg1;
                    if (i1 instanceof IVMInstall2 && i0 instanceof IVMInstall2) {
                        String cc0 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)i0), (String)"1.4");
                        String cc1 = JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)i1), (String)"1.4");
                        int result = cc1.compareTo(cc0);
                        if (result != 0) {
                            return result;
                        }
                    }
                    return Policy.getComparator().compare(i0.getName(), i1.getName());
                }
            });
            selectionIndex = -1;
            String[] jreLabels = new String[this.fInstalledJVMs.length];
            this.fJRECompliance = new String[this.fInstalledJVMs.length];
            int i = 0;
            while (i < this.fInstalledJVMs.length) {
                jreLabels[i] = this.fInstalledJVMs[i].getName();
                if (selectedItem != null && jreLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                this.fJRECompliance[i] = this.fInstalledJVMs[i] instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)this.fInstalledJVMs[i]), (String)"1.4") : "1.4";
                ++i;
            }
            comboField.setItems(jreLabels);
            if (selectionIndex == -1) {
                comboField.selectItem(this.getDefaultJVMName());
            } else {
                comboField.selectItem(selectedItem);
            }
        }

        private String getDefaultEEName() {
            int n;
            IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
            IExecutionEnvironment[] environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            if (defaultVM != null) {
                IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
                n = environments.length;
                int n2 = 0;
                while (n2 < n) {
                    IExecutionEnvironment environment = iExecutionEnvironmentArray[n2];
                    IVMInstall eeDefaultVM = environment.getDefaultVM();
                    if (eeDefaultVM != null && defaultVM.getId().equals(eeDefaultVM.getId())) {
                        return environment.getId();
                    }
                    ++n2;
                }
            }
            String defaultCC = defaultVM instanceof IVMInstall2 ? JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)defaultVM), (String)"1.4") : "1.4";
            IExecutionEnvironment[] iExecutionEnvironmentArray = environments;
            int n3 = environments.length;
            n = 0;
            while (n < n3) {
                IExecutionEnvironment environment = iExecutionEnvironmentArray[n];
                String eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance((IExecutionEnvironment)environment);
                if (defaultCC.endsWith(eeCompliance)) {
                    return environment.getId();
                }
                ++n;
            }
            return "J2SE-1.5";
        }

        private String getDefaultJVMLabel() {
            return Messages.format((String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_JREGroup_default_compliance, (Object)this.getDefaultJVMName());
        }

        private String getDefaultJVMName() {
            IVMInstall install = JavaRuntime.getDefaultVMInstall();
            if (install != null) {
                return install.getName();
            }
            return NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_UnknownDefaultJRE_name;
        }

        public IPath getJREContainerPath() {
            int index;
            if (this.fUseProjectJRE.isSelected()) {
                int index2 = this.fJRECombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.fInstalledJVMs.length) {
                    return JavaRuntime.newJREContainerPath((IVMInstall)this.fInstalledJVMs[index2]);
                }
            } else if (this.fUseEEJRE.isSelected() && (index = this.fEECombo.getSelectionIndex()) >= 0 && index < this.fInstalledEEs.length) {
                return JavaRuntime.newJREContainerPath((IExecutionEnvironment)this.fInstalledEEs[index]);
            }
            return null;
        }

        private String getLastSelectedEE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_EE_SETTINGS_KEY);
        }

        private String getLastSelectedJRE() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            return settings.get(LAST_SELECTED_JRE_SETTINGS_KEY);
        }

        private int getLastSelectedJREKind() {
            IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
            if (settings.get(LAST_SELECTED_JRE_KIND) == null) {
                return 0;
            }
            return settings.getInt(LAST_SELECTED_JRE_KIND);
        }

        public String getSelectedCompilerCompliance() {
            int index;
            if (this.fUseProjectJRE.isSelected()) {
                int index2 = this.fJRECombo.getSelectionIndex();
                if (index2 >= 0 && index2 < this.fJRECompliance.length) {
                    return this.fJRECompliance[index2];
                }
            } else if (this.fUseEEJRE.isSelected() && (index = this.fEECombo.getSelectionIndex()) >= 0 && index < this.fEECompliance.length) {
                return this.fEECompliance[index];
            }
            return null;
        }

        public IVMInstall getSelectedJVM() {
            if (this.fUseProjectJRE.isSelected()) {
                int index = this.fJRECombo.getSelectionIndex();
                if (index >= 0 && index < this.fInstalledJVMs.length) {
                    return this.fInstalledJVMs[index];
                }
            } else {
                this.fUseEEJRE.isSelected();
            }
            return null;
        }

        private IVMInstall[] getWorkspaceJREs() {
            IVMInstallType[] types;
            ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
            IVMInstallType[] iVMInstallTypeArray = types = JavaRuntime.getVMInstallTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall[] installs;
                IVMInstallType type = iVMInstallTypeArray[n2];
                IVMInstall[] iVMInstallArray = installs = type.getVMInstalls();
                int n3 = installs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall install = iVMInstallArray[n4];
                    standins.add(new VMStandin(install));
                    ++n4;
                }
                ++n2;
            }
            return standins.toArray(new IVMInstall[standins.size()]);
        }

        public void handlePossibleJVMChange() {
            this.fUseDefaultJRE.setLabelText(this.getDefaultJVMLabel());
            this.fillInstalledJREs(this.fJRECombo);
            this.fillExecutionEnvironments(this.fEECombo);
        }

        private void storeSelectionValue(ComboDialogField combo, String preferenceKey) {
            int index = combo.getSelectionIndex();
            if (index == -1) {
                return;
            }
            String item = combo.getItems()[index];
            JavaPlugin.getDefault().getDialogSettings().put(preferenceKey, item);
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = NewJavaProjectWizardPageOneCOPY.this.fDetectGroup.mustDetect();
            this.fUseDefaultJRE.setEnabled(!detect);
            this.fUseProjectJRE.setEnabled(!detect);
            this.fUseEEJRE.setEnabled(!detect);
            this.fJRECombo.setEnabled(!detect && this.fUseProjectJRE.isSelected());
            this.fEECombo.setEnabled(!detect && this.fUseEEJRE.isSelected());
            if (this.fPreferenceLink != null) {
                this.fPreferenceLink.setEnabled(!detect);
            }
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!detect);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String jreID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
            String complianceId = "org.eclipse.jdt.ui.preferences.CompliancePreferencePage";
            HashMap<String, Boolean> data = new HashMap<String, Boolean>();
            data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaProjectWizardPageOneCOPY.this.getShell(), (String)jreID, (String[])new String[]{jreID, complianceId}, data).open();
            this.handlePossibleJVMChange();
            NewJavaProjectWizardPageOneCOPY.this.fDetectGroup.handlePossibleJVMChange();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }

    private final class LayoutGroup
    implements Observer,
    SelectionListener {
        private final SelectionButtonDialogField fStdRadio = new SelectionButtonDialogField(16);
        private final SelectionButtonDialogField fSrcBinRadio;
        private Group fGroup;
        private Link fPreferenceLink;

        public LayoutGroup() {
            this.fStdRadio.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LayoutGroup_option_oneFolder);
            this.fSrcBinRadio = new SelectionButtonDialogField(16);
            this.fSrcBinRadio.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LayoutGroup_option_separateFolders);
            boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
            this.fSrcBinRadio.setSelection(useSrcBin);
            this.fStdRadio.setSelection(!useSrcBin);
        }

        public Control createContent(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayout((Layout)NewJavaProjectWizardPageOneCOPY.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LayoutGroup_title);
            this.fStdRadio.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fStdRadio.getSelectionButton(null));
            this.fSrcBinRadio.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.updateEnableState();
            return this.fGroup;
        }

        public boolean isSrcBin() {
            return this.fSrcBinRadio.isSelected();
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            boolean detect = NewJavaProjectWizardPageOneCOPY.this.fDetectGroup.mustDetect();
            this.fStdRadio.setEnabled(!detect);
            this.fSrcBinRadio.setEnabled(!detect);
            if (this.fPreferenceLink != null) {
                this.fPreferenceLink.setEnabled(!detect);
            }
            if (this.fGroup != null) {
                this.fGroup.setEnabled(!detect);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.eclipse.jdt.ui.preferences.BuildPathPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)NewJavaProjectWizardPageOneCOPY.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            NewJavaProjectWizardPageOneCOPY.this.fDetectGroup.handlePossibleJVMChange();
            NewJavaProjectWizardPageOneCOPY.this.fJREGroup.handlePossibleJVMChange();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";
        protected final SelectionButtonDialogField fWorkspaceRadio = new SelectionButtonDialogField(16);
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;

        public LocationGroup() {
            this.fWorkspaceRadio.setDialogFieldListener((IDialogFieldListener)this);
            this.fWorkspaceRadio.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField((IStringButtonAdapter)this);
            this.fLocation.setDialogFieldListener((IDialogFieldListener)this);
            this.fLocation.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField((DialogField)this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(NewJavaProjectWizardPageOneCOPY.this.getShell());
            dialog.setMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public Control createControl(Composite composite) {
            int numColumns = 3;
            Group group = new Group(composite, 0);
            group.setLayout((Layout)NewJavaProjectWizardPageOneCOPY.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_LocationGroup_title);
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
            return group;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public IPath getLocation() {
            if (this.isWorkspaceRadioSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isLocationInWorkspace() {
            String location = NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.getLocation().toOSString();
            IPath projectPath = Path.fromOSString((String)location);
            return Platform.getLocation().isPrefixOf(projectPath);
        }

        public boolean isWorkspaceRadioSelected() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void setLocation(IPath path) {
            this.fWorkspaceRadio.setSelection(path == null);
            if (path != null) {
                this.fLocation.setText(path.toOSString());
            } else {
                this.fLocation.setText(this.getDefaultPath(NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public void update(Observable o, Object arg) {
            if (this.isWorkspaceRadioSelected()) {
                this.fLocation.setText(this.getDefaultPath(NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField = new StringDialogField();

        public NameGroup() {
            this.fNameField.setLabelText(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_NameGroup_label_text);
            this.fNameField.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)NewJavaProjectWizardPageOneCOPY.this.initGridLayout(new GridLayout(2, false), false));
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
            return nameComposite;
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(NewJavaProjectWizardPageOneCOPY.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        private boolean canCreate(File file) {
            while (!file.exists()) {
                if ((file = file.getParentFile()) != null) continue;
                return false;
            }
            return file.canWrite();
        }

        public void update(Observable o, Object arg) {
            String location;
            IWorkspace workspace = JavaPlugin.getWorkspace();
            String name = NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName();
            if (name.length() == 0) {
                NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(null);
                NewJavaProjectWizardPageOneCOPY.this.setMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_enterProjectName);
                NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(nameStatus.getMessage());
                NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                return;
            }
            IProject handle = workspace.getRoot().getProject(name);
            if (handle.exists()) {
                NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_projectAlreadyExists);
                NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                return;
            }
            IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name);
            if (projectLocation.toFile().exists()) {
                try {
                    String canonicalPath = projectLocation.toFile().getCanonicalPath();
                    projectLocation = new Path(canonicalPath);
                }
                catch (IOException e) {
                    JavaPlugin.log((Throwable)e);
                }
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName())) {
                    NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(Messages.format((String)NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_invalidProjectNameForWorkspaceRoot, (Object)existingName));
                    NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                    return;
                }
            }
            if ((location = NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.getLocation().toOSString()).length() == 0) {
                NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(null);
                NewJavaProjectWizardPageOneCOPY.this.setMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_enterLocation);
                NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_invalidDirectory);
                NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.isWorkspaceRadioSelected()) {
                projectPath = projectPath.append(NewJavaProjectWizardPageOneCOPY.this.fNameGroup.getName());
            }
            if (projectPath.toFile().exists()) {
                if (Platform.getLocation().isPrefixOf(projectPath)) {
                    if (!Platform.getLocation().equals((Object)projectPath.removeLastSegments(1))) {
                        NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_notOnWorkspaceRoot);
                        NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                        return;
                    }
                    if (!projectPath.toFile().exists()) {
                        NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_notExisingProjectOnWorkspaceRoot);
                        NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                        return;
                    }
                }
            } else if (!NewJavaProjectWizardPageOneCOPY.this.fLocationGroup.isWorkspaceRadioSelected()) {
                if (!this.canCreate(projectPath.toFile())) {
                    NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(NewJavaProjectWizardConstants.NewJavaProjectWizardPageOne_Message_cannotCreateAtExternalLocation);
                    NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                    return;
                }
                IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
                if (!locationStatus.isOK()) {
                    NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(locationStatus.getMessage());
                    NewJavaProjectWizardPageOneCOPY.this.setPageComplete(false);
                    return;
                }
            }
            NewJavaProjectWizardPageOneCOPY.this.setPageComplete(true);
            NewJavaProjectWizardPageOneCOPY.this.setErrorMessage(null);
            NewJavaProjectWizardPageOneCOPY.this.setMessage(null);
        }
    }
}

