/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.ui.internal.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.viewsupport.FilteredElementTreeSelectionDialog;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.virgo.ide.bundlor.internal.core.BundlorCorePlugin;
import org.eclipse.virgo.ide.bundlor.ui.BundlorUiPlugin;
import org.eclipse.virgo.ide.bundlor.ui.internal.properties.BundlorPropertiesPathDialog;
import org.osgi.service.prefs.BackingStoreException;

public class BundlorPreferencePage
extends PropertyPage {
    private IProject project;
    private boolean modified = false;
    private Table filenameTable;
    private TableViewer filenamesTableViewer;
    private Button addButton;
    private Button pathButton;
    private Button deleteButton;
    private List<String> filenames;
    private Button scanByteCode;
    private Button formatManifests;
    private boolean checkScanByteCodeButton;
    private boolean checkFormatManifestsButton;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite parentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        parentComposite.setLayout((Layout)layout);
        parentComposite.setLayoutData((Object)new GridData(768));
        parentComposite.setFont(font);
        this.initialize();
        this.scanByteCode = new Button(parentComposite, 32);
        this.scanByteCode.setText("Scan output folders instead of source folders to generate MANIFEST.MF");
        this.scanByteCode.setSelection(this.checkScanByteCodeButton);
        this.scanByteCode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundlorPreferencePage.this.modified = true;
            }
        });
        this.formatManifests = new Button(parentComposite, 32);
        this.formatManifests.setText("Auto-format generated MANIFEST.MF and TEST.MF files");
        this.formatManifests.setSelection(this.checkFormatManifestsButton);
        this.formatManifests.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundlorPreferencePage.this.modified = true;
            }
        });
        Label description = this.createDescriptionLabel(parentComposite);
        description.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite composite = new Composite(parentComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.filenameTable = new Table(composite, 68356);
        GridData data = new GridData(1808);
        this.filenameTable.setLayoutData((Object)data);
        this.filenamesTableViewer = new TableViewer(this.filenameTable);
        this.filenamesTableViewer.setContentProvider((IContentProvider)new PropertiesFileContentProvider());
        this.filenamesTableViewer.setLabelProvider((IBaseLabelProvider)new FilenameLabelProvider());
        this.filenamesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (obj != null) {
                    BundlorPreferencePage.this.deleteButton.setEnabled(true);
                } else {
                    BundlorPreferencePage.this.deleteButton.setEnabled(false);
                }
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(2);
        buttonComposite.setLayoutData((Object)data);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText("Add...");
        data = new GridData();
        data.widthHint = 100;
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredElementTreeSelectionDialog selDialog = new FilteredElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new WorkspaceResourceContentProvider());
                selDialog.setTitle("Select properties files");
                selDialog.setMessage("Select properties files in the workspace that should be\nused for variable substitution:");
                selDialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        Object[] objectArray = selection;
                        int n = selection.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (object instanceof IStorage) {
                                return new Status(0, "org.eclipse.virgo.ide.bundlor.ui", 0, "", null);
                            }
                            ++n2;
                        }
                        return new Status(4, "org.eclipse.virgo.ide.bundlor.ui", 0, "", null);
                    }
                });
                selDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                selDialog.setSorter((ViewerSorter)new JavaElementSorter());
                if (selDialog.open() == 0) {
                    IResource resource = (IResource)selDialog.getFirstResult();
                    if (resource instanceof IFile) {
                        if (resource.getProject().equals((Object)BundlorPreferencePage.this.project)) {
                            IPath projectRelativePath = resource.getProjectRelativePath();
                            String string = projectRelativePath.toString();
                            BundlorPreferencePage.this.filenames.add(string);
                        } else {
                            BundlorPreferencePage.this.filenames.add(resource.getFullPath().toString());
                        }
                    }
                    BundlorPreferencePage.this.modified = true;
                    BundlorPreferencePage.this.filenamesTableViewer.setInput((Object)BundlorPreferencePage.this.project);
                }
            }
        });
        this.pathButton = new Button(buttonComposite, 8);
        this.pathButton.setText("Enter Path...");
        data = new GridData();
        data.widthHint = 100;
        this.pathButton.setLayoutData((Object)data);
        this.pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundlorPropertiesPathDialog pathDialog = new BundlorPropertiesPathDialog(BundlorPreferencePage.this.getShell());
                if (pathDialog.open() == 0) {
                    String path = pathDialog.getPropertiesPath();
                    BundlorPreferencePage.this.filenames.add(path);
                    BundlorPreferencePage.this.modified = true;
                    BundlorPreferencePage.this.filenamesTableViewer.setInput((Object)BundlorPreferencePage.this.project);
                }
            }
        });
        this.deleteButton = new Button(buttonComposite, 8);
        this.deleteButton.setText("Delete");
        this.deleteButton.setLayoutData((Object)data);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selected = ((IStructuredSelection)BundlorPreferencePage.this.filenamesTableViewer.getSelection()).getFirstElement();
                BundlorPreferencePage.this.filenames.remove(selected);
                BundlorPreferencePage.this.filenamesTableViewer.setInput((Object)BundlorPreferencePage.this.project);
                BundlorPreferencePage.this.modified = true;
            }
        });
        this.filenamesTableViewer.setInput((Object)this.project);
        return parentComposite;
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        this.noDefaultAndApplyButton();
        this.setDescription("Define properties files that should be used for variable substitution during\ngeneration of MANIFEST.MF file:");
        if (this.project != null) {
            IEclipsePreferences node = this.getProjectPreferences(this.project);
            String properties = node.get("template.properties.files", "template.properties;build.properties");
            this.filenames = new ArrayList<String>(Arrays.asList(StringUtils.split((String)properties, (String)";")));
            this.checkScanByteCodeButton = node.getBoolean("byte.code.scanning", false);
            this.checkFormatManifestsButton = node.getBoolean("bundlor.generated.manifest.autoformatting", false);
        } else {
            this.filenames = new ArrayList<String>();
            this.checkScanByteCodeButton = false;
            this.checkFormatManifestsButton = false;
        }
    }

    public IEclipsePreferences getProjectPreferences(IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode("org.eclipse.virgo.ide.bundlor.core");
        return node;
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        IEclipsePreferences node = this.getProjectPreferences(this.project);
        node.put("template.properties.files", StringUtils.join(this.filenames, (String)";"));
        boolean oldScanByteCode = node.getBoolean("byte.code.scanning", false);
        node.putBoolean("byte.code.scanning", this.scanByteCode.getSelection());
        node.putBoolean("bundlor.generated.manifest.autoformatting", this.formatManifests.getSelection());
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
        if (oldScanByteCode != this.scanByteCode.getSelection()) {
            BundlorCorePlugin.getDefault().getManifestManager().clearPartialManifest(JavaCore.create((IProject)this.project));
        }
        return true;
    }

    class FilenameLabelProvider
    extends LabelProvider {
        FilenameLabelProvider() {
        }

        public Image getImage(Object element) {
            return BundlorUiPlugin.getImage("full/obj16/file_obj.gif");
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    class PropertiesFileContentProvider
    implements ITreeContentProvider {
        PropertiesFileContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject) {
                return BundlorPreferencePage.this.filenames.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    class WorkspaceResourceContentProvider
    implements ITreeContentProvider {
        WorkspaceResourceContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContainer) {
                try {
                    return ((IContainer)parentElement).members();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkspaceRoot) {
                ArrayList<IProject> projects = new ArrayList<IProject>();
                IProject[] iProjectArray = ((IWorkspaceRoot)inputElement).getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen() && project.isAccessible()) {
                        projects.add(project);
                    }
                    ++n2;
                }
                return projects.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

