/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.jdt.internal.core.classpath;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.virgo.ide.jdt.core.JdtCorePlugin;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainer;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathContainerUpdateJob;
import org.eclipse.virgo.ide.jdt.internal.core.classpath.ServerClasspathUtils;
import org.eclipse.virgo.ide.jdt.internal.core.util.ClasspathUtils;
import org.eclipse.virgo.ide.manifest.core.BundleManifestUtils;
import org.eclipse.virgo.ide.manifest.internal.core.BundleManifestManager;

public class ServerClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        if (containerPath.equals((Object)ServerClasspathContainer.CLASSPATH_CONTAINER_PATH)) {
            ServerClasspathContainer oldContainer = ClasspathUtils.getClasspathContainer(javaProject);
            ServerClasspathContainer newContainer = null;
            IClasspathEntry[] oldEntries = null;
            newContainer = oldContainer == null ? ((oldEntries = ServerClasspathUtils.readPersistedClasspathEntries(javaProject)) != null ? new ServerClasspathContainer(javaProject, oldEntries) : new ServerClasspathContainer(javaProject)) : new ServerClasspathContainer(javaProject, oldContainer.getClasspathEntries());
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{newContainer}, (IProgressMonitor)new NullProgressMonitor());
            if (oldEntries == null || this.hasManifestChanged(javaProject, false) || this.hasManifestChanged(javaProject, true)) {
                ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob(javaProject, BundleManifestManager.IMPORTS_CHANGED);
            }
        }
    }

    private boolean hasManifestChanged(IJavaProject javaProject, boolean testManifest) {
        IFile file = BundleManifestUtils.locateManifest((IJavaProject)javaProject, (boolean)testManifest);
        if (file != null && file.exists()) {
            try {
                String lastmodified = file.getPersistentProperty(new QualifiedName("org.eclipse.virgo.ide.jdt.core", "MANIFEST_TIMESTAMP"));
                return lastmodified == null || file.getLocalTimeStamp() != Long.valueOf(lastmodified).longValue();
            }
            catch (CoreException e) {
                JdtCorePlugin.log(e);
            }
        }
        return false;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null || project == null) {
            return null;
        }
        return String.valueOf(containerPath.segment(0)) + "/" + project.getPath().segment(0);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return "Bundle Dependencies";
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) throws CoreException {
        ClasspathUtils.storeSourceAttachments(javaProject, containerSuggestion);
        ServerClasspathContainerUpdateJob.scheduleClasspathContainerUpdateJob(javaProject, BundleManifestManager.IMPORTS_CHANGED);
    }

    public IClasspathContainer getFailureContainer(IPath containerPath, IJavaProject project) {
        return null;
    }
}

