/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.eclipse.editors;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class DependenciesSection
extends SectionPart {
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int UP_INDEX = 2;
    private static final int DOWN_INDEX = 3;
    private static final int PROPERTIES_INDEX = 4;
    private TableViewer fImportViewer;
    protected boolean fHandleDefaultButton = true;
    private final StructuredViewerPart fViewerPart;

    public DependenciesSection(FormPage page, Composite parent, String[] buttonLabels) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.initialize(page.getManagedForm());
        this.getSection().clientVerticalSpacing = 6;
        this.getSection().setData("part", (Object)this);
        this.fViewerPart = this.createViewerPart(buttonLabels);
        this.fViewerPart.setMinimumSize(50, 50);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
        this.getSection().setText(PDEUIMessages.RequiresSection_title);
        this.getTablePart().setEditable(false);
    }

    private void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
                break;
            }
            case 4: {
                this.handleOpenProperties();
            }
        }
    }

    private void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fImportViewer = tablePart.getTableViewer();
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 250;
        gd.grabExcessVerticalSpace = true;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        section.setLayoutData((Object)gd);
        section.setText(PDEUIMessages.RequiresSection_title);
        this.createSectionToolbar(section, toolkit);
        this.enableButtons();
    }

    private Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)span));
        return container;
    }

    private boolean createCount() {
        return true;
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new PartAdapter(buttonLabels);
    }

    private void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.fViewerPart.createControl(parent, style, span, toolkit);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.fViewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    protected abstract void enableButtons();

    protected abstract void entryModified(Object var1, String var2);

    protected int getAddIndex() {
        return 0;
    }

    protected int getDownIndex() {
        return 3;
    }

    protected int getPropertiesIndex() {
        return 4;
    }

    protected int getRemoveIndex() {
        return 1;
    }

    protected EditableTablePart getTablePart() {
        return (EditableTablePart)this.fViewerPart;
    }

    protected TableViewer getTableViewer() {
        return this.fImportViewer;
    }

    protected int getUpIndex() {
        return 2;
    }

    protected abstract void handleAdd();

    protected abstract void handleDoubleClick(IStructuredSelection var1);

    protected abstract void handleDown();

    protected abstract void handleOpenProperties();

    protected abstract void handleRemove();

    protected abstract void handleUp();

    protected abstract void initialize();

    protected abstract void selectionChanged(IStructuredSelection var1);

    class PartAdapter
    extends EditableTablePart {
        private Label fCount;

        public PartAdapter(String[] buttonLabels) {
            super(buttonLabels);
        }

        public void buttonSelected(Button button, int index) {
            DependenciesSection.this.buttonSelected(index);
            if (DependenciesSection.this.fHandleDefaultButton) {
                button.getShell().setDefaultButton(null);
            }
        }

        protected void createButtons(Composite parent, FormToolkit toolkit) {
            super.createButtons(parent, toolkit);
            DependenciesSection.this.enableButtons();
            if (DependenciesSection.this.createCount()) {
                Composite comp = toolkit.createComposite(this.fButtonContainer);
                comp.setLayout((Layout)this.createButtonsLayout());
                comp.setLayoutData((Object)new GridData(1816));
                this.fCount = toolkit.createLabel(comp, "");
                this.fCount.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                this.fCount.setLayoutData((Object)new GridData(768));
                DependenciesSection.this.getTablePart().getTableViewer().getTable().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        PartAdapter.this.updateLabel();
                    }
                });
            }
        }

        public void entryModified(Object entry, String value) {
            DependenciesSection.this.entryModified(entry, value);
        }

        public void handleDoubleClick(IStructuredSelection selection) {
            DependenciesSection.this.handleDoubleClick(selection);
        }

        public void selectionChanged(IStructuredSelection selection) {
            DependenciesSection.this.getManagedForm().fireSelectionChanged((IFormPart)DependenciesSection.this, (ISelection)selection);
            DependenciesSection.this.selectionChanged(selection);
        }

        protected void updateLabel() {
            if (this.fCount != null && !this.fCount.isDisposed()) {
                this.fCount.setText(NLS.bind((String)PDEUIMessages.TableSection_itemCount, (Object)Integer.toString(this.getTableViewer().getTable().getItemCount())));
            }
        }
    }
}

