/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.propertysubstitution;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.virgo.bundlor.support.ManifestModifier;
import org.eclipse.virgo.bundlor.support.ManifestTemplateModifier;
import org.eclipse.virgo.bundlor.support.TemplateHeaderReader;
import org.eclipse.virgo.bundlor.support.propertysubstitution.VersionExpansionTransformer;
import org.eclipse.virgo.util.common.PropertyPlaceholderResolver;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public final class PlaceholderManifestAndTemplateModifier
implements ManifestModifier,
ManifestTemplateModifier,
TemplateHeaderReader {
    private final Properties properties;

    public PlaceholderManifestAndTemplateModifier(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void modify(ManifestContents manifest) {
        VersionExpansionTransformer transformer = new VersionExpansionTransformer(manifest);
        PropertyPlaceholderResolver placeholderResolver = new PropertyPlaceholderResolver();
        for (Map.Entry entry : manifest.getMainAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            manifest.getMainAttributes().put(key, placeholderResolver.resolve(value, this.properties, (PropertyPlaceholderResolver.PlaceholderValueTransformer)transformer));
        }
        for (String name : manifest.getSectionNames()) {
            for (Map.Entry entry : manifest.getAttributesForSection(name).entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                manifest.getAttributesForSection(name).put(key, placeholderResolver.resolve(value, this.properties, (PropertyPlaceholderResolver.PlaceholderValueTransformer)transformer));
            }
        }
    }

    @Override
    public List<String> getTemplateOnlyHeaderNames() {
        return new VersionExpansionTransformer().getTemplateOnlyHeaderNames();
    }
}

