/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;

public class JspArtifactAnalyzer
implements ArtifactAnalyzer {
    private static final String PACKAGE_SUFFIX = ".*";
    private static final String TYPE_SUFFIX = ".class";
    private final Pattern pattern = Pattern.compile("<%@ page.*import=\"(.*?)\".*%>");

    @Override
    public void analyse(InputStream artifact, String artifactName, PartialManifest partialManifest) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(artifact));
        String line = in.readLine();
        while (line != null) {
            Matcher matcher = this.pattern.matcher(line);
            while (matcher.find()) {
                this.processImports(matcher.group(1), partialManifest);
            }
            line = in.readLine();
        }
    }

    @Override
    public boolean canAnalyse(String artifactName) {
        return artifactName.endsWith(".jsp");
    }

    private void processImports(String imports, PartialManifest partialManifest) {
        String[] stringArray = imports.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String importString = stringArray[n2];
            String trimmedString = importString.trim();
            if (trimmedString.endsWith(TYPE_SUFFIX)) {
                this.processType(trimmedString, partialManifest);
            } else if (trimmedString.endsWith(PACKAGE_SUFFIX)) {
                this.processPackage(trimmedString, partialManifest);
            }
            ++n2;
        }
    }

    private void processType(String importString, PartialManifest partialManifest) {
        String typeName = importString.substring(0, importString.length() - TYPE_SUFFIX.length());
        partialManifest.recordReferencedType(typeName);
    }

    private void processPackage(String importString, PartialManifest partialManifest) {
        String packageName = importString.substring(0, importString.length() - PACKAGE_SUFFIX.length());
        partialManifest.recordReferencedPackage(packageName);
    }
}

