/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.virgo.ide.runtime.core.artefacts.ArtefactSet;
import org.eclipse.virgo.ide.runtime.core.artefacts.IArtefact;
import org.eclipse.virgo.ide.runtime.core.artefacts.LocalArtefactSet;
import org.eclipse.virgo.ide.runtime.internal.ui.editor.Messages;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.IServerProjectArtefact;
import org.eclipse.virgo.ide.runtime.internal.ui.projects.IServerProjectContainer;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.LibrariesNode;
import org.eclipse.virgo.ide.runtime.internal.ui.providers.RuntimeLabelProvider;

public class RuntimeFullLabelProvider
extends RuntimeLabelProvider {
    public String getText(Object element) {
        if (element instanceof IServerProjectArtefact) {
            return String.valueOf(this.getText(((IServerProjectArtefact)element).getContainer())) + " - " + this.getText(((IServerProjectArtefact)element).getArtefact());
        }
        if (element instanceof IServerProjectContainer) {
            return String.valueOf(this.getText(((IServerProjectContainer)element).getServer())) + " - " + this.getText(((IServerProjectContainer)element).getArtefactSet());
        }
        if (element instanceof LibrariesNode) {
            return String.valueOf(this.getText(((LibrariesNode)element).getServer())) + " " + Messages.RepositoryBrowserEditorPage_BundlesAndLibraries;
        }
        if (element instanceof IFile) {
            return ((IFile)element).getName();
        }
        if (element instanceof ArtefactSet) {
            ArtefactSet set = (ArtefactSet)element;
            String label = set.getArtefactType().getPluralLabel();
            if (element instanceof LocalArtefactSet) {
                label = String.valueOf(((LocalArtefactSet)element).getRelativePath()) + " [" + label + "]";
            }
            return label;
        }
        if (element instanceof IArtefact) {
            IArtefact version = (IArtefact)element;
            StringBuilder l = new StringBuilder();
            if (version.getName() != null) {
                l.append(version.getName());
                l.append(" - ");
            }
            l.append(version.getSymbolicName());
            l.append(" (");
            l.append(version.getVersion());
            l.append(")");
            return l.toString();
        }
        return super.getText(element);
    }
}

