/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;

public class ConstraintExtensionRegistry {
    private static final String WILDCARD_EDITOR_ID = "*";
    private static final String CONSTRAINT_ATTRIBUTE_NAME = "constraint";
    private static final String VALIDATION_RUNTIME_CONSTRAINT_EXTENSION_ID = "org.eclipse.viatra.addon.validation.runtime.constraint";
    private static final String EDITOR_ID_ATTRIBUTE_NAME = "editorId";
    private static final String ENABLED_FOR_EDITOR_ATTRIBUTE_NAME = "enabledForEditor";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    static Set<String> genericEditorIds = Stream.of("org.eclipse.emf.ecore.presentation.XMLReflectiveEditorID", "org.eclipse.emf.ecore.presentation.ReflectiveEditorID", "org.eclipse.emf.genericEditor").collect(Collectors.toSet());
    private static IMultiLookup<String, IProvider<IConstraintSpecification>> editorConstraintSpecificationMap;

    private ConstraintExtensionRegistry() {
    }

    protected static synchronized IMultiLookup<String, IProvider<IConstraintSpecification>> getEditorConstraintSpecificationMap() {
        if (editorConstraintSpecificationMap == null) {
            editorConstraintSpecificationMap = ConstraintExtensionRegistry.loadConstraintSpecificationsFromExtensions();
        }
        return editorConstraintSpecificationMap;
    }

    public static synchronized boolean isConstraintSpecificationsRegisteredForEditorId(String editorId) {
        IMultiLookup<String, IProvider<IConstraintSpecification>> specificationMap = ConstraintExtensionRegistry.getEditorConstraintSpecificationMap();
        if (specificationMap.lookupExists((Object)WILDCARD_EDITOR_ID)) {
            return true;
        }
        return specificationMap.lookupExists((Object)editorId);
    }

    public static synchronized Set<IConstraintSpecification> getConstraintSpecificationsForEditorId(String editorId) {
        if (genericEditorIds.contains(editorId)) {
            Set<IConstraintSpecification> constraintSpecifications = ConstraintExtensionRegistry.unwrapConstraintSpecifications(StreamSupport.stream(ConstraintExtensionRegistry.getEditorConstraintSpecificationMap().distinctValues().spliterator(), false));
            return constraintSpecifications;
        }
        Set<IConstraintSpecification> set = ConstraintExtensionRegistry.unwrapConstraintSpecifications(Stream.concat(ConstraintExtensionRegistry.getEditorConstraintSpecificationMap().lookupOrEmpty((Object)editorId).asStream(), ConstraintExtensionRegistry.getEditorConstraintSpecificationMap().lookupOrEmpty((Object)WILDCARD_EDITOR_ID).asStream()));
        return set;
    }

    private static Set<IConstraintSpecification> unwrapConstraintSpecifications(Stream<IProvider<IConstraintSpecification>> providers) {
        return providers.filter(Objects::nonNull).map(Supplier::get).collect(Collectors.toSet());
    }

    private static synchronized IMultiLookup<String, IProvider<IConstraintSpecification>> loadConstraintSpecificationsFromExtensions() {
        IMultiLookup result = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(VALIDATION_RUNTIME_CONSTRAINT_EXTENSION_ID);
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals(CONSTRAINT_ATTRIBUTE_NAME)) {
                    ConstraintExtensionRegistry.processConstraintSpecificationConfigurationElement((IMultiLookup<String, IProvider<IConstraintSpecification>>)result, ce);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static void processConstraintSpecificationConfigurationElement(IMultiLookup<String, IProvider<IConstraintSpecification>> result, IConfigurationElement ce) {
        ArrayList<String> ids = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (child.getName().equals(ENABLED_FOR_EDITOR_ATTRIBUTE_NAME) && (id = child.getAttribute(EDITOR_ID_ATTRIBUTE_NAME)) != null && !id.equals("")) {
                ids.add(id);
            }
            ++n2;
        }
        ConstraintSpecificationProvider constraintSpecificationProvider = new ConstraintSpecificationProvider(ce);
        if (ids.isEmpty()) {
            ids.add(WILDCARD_EDITOR_ID);
        }
        for (String id : ids) {
            result.addPair((Object)id, (Object)constraintSpecificationProvider);
        }
    }

    private static final class ConstraintSpecificationProvider
    implements IProvider<IConstraintSpecification> {
        private final IConfigurationElement element;
        private IConstraintSpecification constraintSpecification;

        public ConstraintSpecificationProvider(IConfigurationElement element) {
            this.element = element;
            this.constraintSpecification = null;
        }

        public IConstraintSpecification get() {
            try {
                if (this.constraintSpecification == null) {
                    this.constraintSpecification = (IConstraintSpecification)this.element.createExecutableExtension(ConstraintExtensionRegistry.CLASS_ATTRIBUTE_NAME);
                }
                return this.constraintSpecification;
            }
            catch (CoreException e) {
                throw new IllegalArgumentException("Error initializing constraint specification", e);
            }
        }
    }
}

