/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.integration.zest.viewer;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra.integration.zest.viewer.IGraphEdgeContentProvider;
import org.eclipse.viatra.integration.zest.viewer.internal.GraphModelEdgeFactory;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.GraphModelEntityFactory;
import org.eclipse.zest.core.viewers.internal.GraphModelEntityRelationshipFactory;
import org.eclipse.zest.core.viewers.internal.GraphModelFactory;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;

public class ViatraGraphViewer
extends GraphViewer {
    private IStylingGraphModelFactory overriddenModelFactory = null;
    private static final double MINIMUM_ZOOM = 0.1;
    private static final double MAXIMUM_ZOOM = 10.0;

    public ViatraGraphViewer(Composite composite, int style) {
        super(composite, style);
        final Graph graph = this.getGraphControl();
        graph.addGestureListener(new GestureListener(){
            double zoom = 1.0;

            public void gesture(GestureEvent e) {
                switch (e.detail) {
                    case 2: {
                        this.zoom = graph.getRootLayer().getScale();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 32: {
                        double newValue = this.zoom * e.magnification;
                        if (!(newValue >= 0.1) || !(newValue <= 10.0)) break;
                        graph.getRootLayer().setScale(newValue);
                        graph.getRootLayer().repaint();
                    }
                }
            }
        });
    }

    public void removeNode(Object element) {
        GraphNode node = (GraphNode)this.findItem(element);
        if (node != null) {
            if (this.getLayoutAlgorithm() != null) {
                this.getLayoutAlgorithm().removeEntity(node.getLayoutEntity());
                Stream<Object> connectionStream = Stream.concat(node.getSourceConnections().stream(), node.getTargetConnections().stream()).map(GraphConnection.class::cast);
                List sourceRelationships = connectionStream.map(GraphConnection::getLayoutRelationship).collect(Collectors.toList());
                this.getLayoutAlgorithm().removeRelationships(sourceRelationships);
            }
            node.dispose();
        }
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (contentProvider instanceof IGraphContentProvider) {
            this.overriddenModelFactory = null;
            super.setContentProvider(contentProvider);
        } else if (contentProvider instanceof IGraphEntityContentProvider) {
            this.overriddenModelFactory = null;
            super.setContentProvider(contentProvider);
        } else if (contentProvider instanceof IGraphEntityRelationshipContentProvider) {
            this.overriddenModelFactory = null;
            super.setContentProvider(contentProvider);
        } else if (contentProvider instanceof IGraphEdgeContentProvider) {
            this.overriddenModelFactory = null;
            super.setContentProvider(contentProvider);
        } else {
            throw new IllegalArgumentException("Invalid content provider, only IGraphContentProvider, IGraphEntityContentProvider, or IGraphEntityRelationshipContentProvider are supported.");
        }
    }

    protected IStylingGraphModelFactory getFactory() {
        if (this.overriddenModelFactory == null) {
            if (this.getContentProvider() instanceof IGraphEdgeContentProvider) {
                this.overriddenModelFactory = new GraphModelEdgeFactory((AbstractStructuredGraphViewer)this);
            } else if (this.getContentProvider() instanceof IGraphContentProvider) {
                this.overriddenModelFactory = new GraphModelFactory((AbstractStructuredGraphViewer)this);
            } else if (this.getContentProvider() instanceof IGraphEntityContentProvider) {
                this.overriddenModelFactory = new GraphModelEntityFactory((AbstractStructuredGraphViewer)this);
            } else if (this.getContentProvider() instanceof IGraphEntityRelationshipContentProvider) {
                this.overriddenModelFactory = new GraphModelEntityRelationshipFactory((AbstractStructuredGraphViewer)this);
            }
        }
        return this.overriddenModelFactory;
    }
}

