/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures.internal;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.viatra.integration.uml.derivedfeatures.internal.PackageAllImportedPackages;
import org.eclipse.viatra.integration.uml.derivedfeatures.internal.PackageDirectlyVisibleMember;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFQuerySpecificationWithGenericMatcher;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

/**
 * A pattern-specific query specification that can instantiate GenericPatternMatcher in a type-safe way.
 * 
 * <p>Original source:
 *         <code><pre>
 *         (member-{@literal >}select( m | m.oclIsKindOf(PackageableElement) and self.makesVisible(m))-{@literal >}collect(oclAsType(PackageableElement))-{@literal >}asSet())
 *         
 *         private pattern packageVisibleMember(package_: Package, visibleMember: PackageableElement) {
 *             find packageDirectlyVisibleMember(package_, visibleMember);
 *         } or {
 *             find packageAllImportedPackages(package_, importedPackage);
 *             find packageDirectlyVisibleMember(importedPackage, visibleMember);
 *         }
 * </pre></code>
 * 
 * @see GenericPatternMatcher
 * @see GenericPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class PackageVisibleMember extends BaseGeneratedEMFQuerySpecificationWithGenericMatcher {
  private PackageVisibleMember() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws ViatraQueryRuntimeException if the pattern definition could not be loaded
   * 
   */
  public static PackageVisibleMember instance() {
    try{
        return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
        throw processInitializerError(err);
    }
  }
  
  /**
   * Inner class allowing the singleton instance of {@link PackageVisibleMember} to be created 
   *     <b>not</b> at the class load time of the outer class, 
   *     but rather at the first call to {@link PackageVisibleMember#instance()}.
   * 
   * <p> This workaround is required e.g. to support recursion.
   * 
   */
  private static class LazyHolder {
    private static final PackageVisibleMember INSTANCE = new PackageVisibleMember();
    
    /**
     * Statically initializes the query specification <b>after</b> the field {@link #INSTANCE} is assigned.
     * This initialization order is required to support indirect recursion.
     * 
     * <p> The static initializer is defined using a helper field to work around limitations of the code generator.
     * 
     */
    private static final Object STATIC_INITIALIZER = ensureInitialized();
    
    public static Object ensureInitialized() {
      INSTANCE.ensureInitializedInternal();
      return null;
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private static final PackageVisibleMember.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    private final PParameter parameter_package_ = new PParameter("package_", "org.eclipse.uml2.uml.Package", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "Package")), PParameterDirection.INOUT);
    
    private final PParameter parameter_visibleMember = new PParameter("visibleMember", "org.eclipse.uml2.uml.PackageableElement", new EClassTransitiveInstancesKey((EClass)getClassifierLiteralSafe("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")), PParameterDirection.INOUT);
    
    private final List<PParameter> parameters = Arrays.asList(parameter_package_, parameter_visibleMember);
    
    private GeneratedPQuery() {
      super(PVisibility.PRIVATE);
    }
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.integration.uml.derivedfeatures.packageVisibleMember";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("package_","visibleMember");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return parameters;
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() {
      setEvaluationHints(new QueryEvaluationHint(null, QueryEvaluationHint.BackendRequirement.UNSPECIFIED));
      Set<PBody> bodies = new LinkedHashSet<>();
      {
          PBody body = new PBody(this);
          PVariable var_package_ = body.getOrCreateVariableByName("package_");
          PVariable var_visibleMember = body.getOrCreateVariableByName("visibleMember");
          new TypeConstraint(body, Tuples.flatTupleOf(var_package_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_visibleMember), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_package_, parameter_package_),
             new ExportedParameter(body, var_visibleMember, parameter_visibleMember)
          ));
          //     find packageDirectlyVisibleMember(package_, visibleMember)
          new PositivePatternCall(body, Tuples.flatTupleOf(var_package_, var_visibleMember), PackageDirectlyVisibleMember.instance().getInternalQueryRepresentation());
          bodies.add(body);
      }
      {
          PBody body = new PBody(this);
          PVariable var_package_ = body.getOrCreateVariableByName("package_");
          PVariable var_visibleMember = body.getOrCreateVariableByName("visibleMember");
          PVariable var_importedPackage = body.getOrCreateVariableByName("importedPackage");
          new TypeConstraint(body, Tuples.flatTupleOf(var_package_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
          new TypeConstraint(body, Tuples.flatTupleOf(var_visibleMember), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "PackageableElement")));
          body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
             new ExportedParameter(body, var_package_, parameter_package_),
             new ExportedParameter(body, var_visibleMember, parameter_visibleMember)
          ));
          //     find packageAllImportedPackages(package_, importedPackage)
          new PositivePatternCall(body, Tuples.flatTupleOf(var_package_, var_importedPackage), PackageAllImportedPackages.instance().getInternalQueryRepresentation());
          //     find packageDirectlyVisibleMember(importedPackage, visibleMember)
          new PositivePatternCall(body, Tuples.flatTupleOf(var_importedPackage, var_visibleMember), PackageDirectlyVisibleMember.instance().getInternalQueryRepresentation());
          bodies.add(body);
      }
      return bodies;
    }
  }
}
