/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.transformationview.util;

import org.eclipse.viatra.examples.cps.application.ui.transformationview.util.TransformationTypeNames;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.CPSTransformationWrapper;
import org.eclipse.viatra.examples.cps.xform.m2m.launcher.TransformationType;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;

@Data
public class TransformationConnector {
    private final TransformationType transformationType;
    private final CPSTransformationWrapper wrapper;
    private final EMFModelConnector modelConnector;
    private final CPSToDeployment tracemodel;

    public String toString() {
        String _title = this.modelConnector.getOwner().getTitle();
        String _plus = String.valueOf(_title) + ": ";
        String _friendlyName = TransformationTypeNames.getFriendlyName(this.transformationType);
        String _plus_1 = String.valueOf(_plus) + _friendlyName;
        return String.valueOf(_plus_1) + " transformation";
    }

    public TransformationConnector(TransformationType transformationType, CPSTransformationWrapper wrapper, EMFModelConnector modelConnector, CPSToDeployment tracemodel) {
        this.transformationType = transformationType;
        this.wrapper = wrapper;
        this.modelConnector = modelConnector;
        this.tracemodel = tracemodel;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transformationType == null ? 0 : this.transformationType.hashCode());
        result = 31 * result + (this.wrapper == null ? 0 : this.wrapper.hashCode());
        result = 31 * result + (this.modelConnector == null ? 0 : this.modelConnector.hashCode());
        result = 31 * result + (this.tracemodel == null ? 0 : this.tracemodel.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransformationConnector other = (TransformationConnector)obj;
        if (this.transformationType == null ? other.transformationType != null : !this.transformationType.equals((Object)other.transformationType)) {
            return false;
        }
        if (this.wrapper == null ? other.wrapper != null : !this.wrapper.equals(other.wrapper)) {
            return false;
        }
        if (this.modelConnector == null ? other.modelConnector != null : !this.modelConnector.equals(other.modelConnector)) {
            return false;
        }
        return !(this.tracemodel == null ? other.tracemodel != null : !this.tracemodel.equals(other.tracemodel));
    }

    @Pure
    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    @Pure
    public CPSTransformationWrapper getWrapper() {
        return this.wrapper;
    }

    @Pure
    public EMFModelConnector getModelConnector() {
        return this.modelConnector;
    }

    @Pure
    public CPSToDeployment getTracemodel() {
        return this.tracemodel;
    }
}

