/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.application.ui.cpsgenerator;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.viatra.examples.cps.application.ui.CPSApplicationUIPlugin;
import org.eclipse.viatra.examples.cps.application.ui.cpsgenerator.ConstraintDetailsPage;
import org.eclipse.viatra.examples.cps.application.ui.cpsgenerator.ConstraintTypePage;
import org.eclipse.viatra.examples.cps.application.ui.cpsgenerator.NewFileCreationPage;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystemPackage;
import org.eclipse.viatra.examples.cps.generator.CPSPlanBuilder;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSGeneratorInput;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.ICPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.IConstraints;
import org.eclipse.viatra.examples.cps.planexecutor.PlanExecutor;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPlan;
import org.eclipse.viatra.examples.cps.planexecutor.api.Initializer;

public class CPSGeneratorWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "Generate CPS Model";
    private static final String DEFAULT_FILENAME = "My";
    private static final String EXTENSION = "cyberphysicalsystem";
    private NewFileCreationPage newFileCreationPage;
    private ConstraintTypePage constraintPage;
    private ConstraintDetailsPage detailsPage;
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(CPSApplicationUIPlugin.getDefault().getImageRegistry().getDescriptor("NewCyberPhysicalSystem"));
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new NewFileCreationPage("CPSWizardNewFileCreationPage", this.selection, EXTENSION);
        this.newFileCreationPage.setTitle(TITLE);
        this.newFileCreationPage.setDescription("Create a new CyberPhysicalSystem model file");
        this.newFileCreationPage.setFileName("My.cyberphysicalsystem");
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String modelFilename = "My.cyberphysicalsystem";
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = DEFAULT_FILENAME + i + "." + EXTENSION;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.constraintPage = new ConstraintTypePage();
        this.constraintPage.setTitle(TITLE);
        this.addPage((IWizardPage)this.constraintPage);
        this.detailsPage = new ConstraintDetailsPage();
        this.detailsPage.setTitle(TITLE);
        this.addPage((IWizardPage)this.detailsPage);
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.newFileCreationPage.getModelRelativePath());
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            CyberPhysicalSystem rootObject = CPSGeneratorWizard.this.createModel();
                            resource.getContents().add((Object)rootObject);
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resource.save(options);
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.viatra.examples.cps.application.ui", "Error creating file " + modelFile.getName(), (Throwable)e));
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            BasicNewResourceWizard.selectAndReveal((IResource)modelFile, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
            if (this.constraintPage.shouldOpenModel()) {
                IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)modelFile, (boolean)true);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            this.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error creating file", (String)e.getTargetException().getMessage());
            return false;
        }
        catch (Exception e) {
            this.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error creating file", (String)e.getMessage());
            return false;
        }
    }

    private CyberPhysicalSystem createModel() {
        CyberPhysicalSystem cps = CyberPhysicalSystemPackage.eINSTANCE.getCyberPhysicalSystemFactory().createCyberPhysicalSystem();
        ICPSConstraints plainConstaints = this.constraintPage.getConstraints();
        ICPSConstraints constraints = plainConstaints != null ? plainConstaints : this.detailsPage.getConstraints();
        CPSGeneratorInput input = new CPSGeneratorInput(this.constraintPage.getSeed(), (IConstraints)constraints, cps);
        PlanExecutor generator = new PlanExecutor();
        CPSFragment fragment = (CPSFragment)generator.process((IPlan)CPSPlanBuilder.buildDefaultPlan(), (Initializer)input);
        fragment.getEngine().dispose();
        return cps;
    }

    private void log(Exception exception) {
        CPSApplicationUIPlugin.getDefault().logException("An error happened: " + exception.getMessage(), exception);
    }
}

