/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime.validation;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.types.EMFTypeSystem;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IIssueCallback;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Expression;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

public class SurrogatePatternValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String FEATURE_PARAMETER_NAME = "feature";
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.query.patternlanguage.surrogate.";
    public static final String GENERAL_ISSUE_CODE = "org.eclipse.viatra.query.patternlanguage.surrogate.general";
    public static final String METAMODEL_ISSUE_CODE = "org.eclipse.viatra.query.patternlanguage.surrogate.faulty_metamodel";
    public static final String PATTERN_ISSUE_CODE = "org.eclipse.viatra.query.patternlanguage.surrogate.faulty_pattern";
    public static final String ANNOTATION_ISSUE_CODE = "org.eclipse.viatra.query.patternlanguage.surrogate.faulty_annotation";
    @Inject
    private EMFTypeInferrer typeInferrer;
    @Inject
    private EMFTypeSystem typeSystem;

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        EClassifier classifier;
        boolean foundErrors = false;
        Pattern pattern = (Pattern)annotation.eContainer();
        foundErrors = this.checkFeatureUniquenessOnSurrogateAnnotations(annotation, validator, pattern);
        if (foundErrors) {
            return;
        }
        if (pattern.getParameters().size() != 2) {
            validator.error("Surrogate pattern must have exactly 2 parameters.", (EObject)pattern, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__PARAMETERS, PATTERN_ISSUE_CODE, new String[0]);
            return;
        }
        Variable source = (Variable)pattern.getParameters().get(0);
        IInputKey sourceTypeKey = null;
        EClass sourceClass = null;
        if (source != null) {
            sourceTypeKey = this.typeInferrer.getType((Expression)source);
            sourceClass = this.typeSystem.inputKeyToClassifier(sourceTypeKey).filter(input -> input instanceof EClass).orElse(null);
        }
        if (sourceClass == null) {
            validator.error("The 'source' parameter must be EClass.", (EObject)source, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__TYPE, PATTERN_ISSUE_CODE, new String[0]);
            return;
        }
        String featureName = null;
        Pattern contextForFeature = null;
        EAttribute contextESFForFeature = null;
        ValueReference ref = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)FEATURE_PARAMETER_NAME);
        if (ref == null) {
            featureName = pattern.getName();
            contextForFeature = pattern;
            contextESFForFeature = PatternLanguagePackage.Literals.PATTERN__NAME;
        } else if (ref instanceof StringValue) {
            featureName = ((StringValue)ref).getValue();
            contextForFeature = ref;
            contextESFForFeature = PatternLanguagePackage.Literals.STRING_VALUE__VALUE;
        }
        if (featureName == null || featureName.isEmpty()) {
            validator.error("The 'feature' parameter must not be empty.", (EObject)ref, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, ANNOTATION_ISSUE_CODE, new String[0]);
            return;
        }
        EStructuralFeature feature = null;
        for (EStructuralFeature f : sourceClass.getEStructuralFeatures()) {
            if (!featureName.equals(f.getName())) continue;
            feature = f;
            break;
        }
        if (feature == null) {
            validator.error(String.format("Cannot find feature %s of EClass %s.", featureName, sourceClass.getName()), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, ANNOTATION_ISSUE_CODE, new String[0]);
            return;
        }
        if (feature instanceof EReference) {
            boolean featureError = false;
            if (!feature.isDerived()) {
                validator.error(String.format("Feature %s is not derived.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
                featureError = true;
            }
            if (!feature.isTransient()) {
                validator.error(String.format("Feature %s is not transient.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
                featureError = true;
            }
            if (!feature.isVolatile()) {
                validator.error(String.format("Feature %s is not volatile.", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
                featureError = true;
            }
            if (featureError) {
                return;
            }
        }
        if ((classifier = feature.getEGenericType().getEClassifier()) == null) {
            validator.error(String.format("Feature %s has no type information set in the metamodel", featureName), (EObject)contextForFeature, (EStructuralFeature)contextESFForFeature, METAMODEL_ISSUE_CODE, new String[0]);
            return;
        }
        Variable target = (Variable)pattern.getParameters().get(1);
        Optional targetClassifier = this.typeSystem.inputKeyToClassifier(this.typeInferrer.getType((Expression)target));
        if (!targetClassifier.isPresent()) {
            validator.warning("Cannot find target EClassifier", (EObject)target, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__TYPE, PATTERN_ISSUE_CODE, new String[0]);
        } else if (!Objects.equals(classifier, targetClassifier.get())) {
            validator.warning(String.format("The 'target' parameter type %s is not equal to actual feature type %s.", featureName, sourceClass.getName()), (EObject)target, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__TYPE, PATTERN_ISSUE_CODE, new String[0]);
        }
    }

    private boolean checkFeatureUniquenessOnSurrogateAnnotations(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        Collection qbfAnnotations = PatternLanguageHelper.getAnnotationsByName((Pattern)pattern, (String)"Surrogate");
        if (qbfAnnotations.size() > 1) {
            ValueReference feature = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)FEATURE_PARAMETER_NAME);
            if (feature == null) {
                validator.error("Feature must be specified when multiple Surrogate annotations are used on a single pattern.", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, ANNOTATION_ISSUE_CODE, new String[0]);
                return true;
            }
            String featureName = ((StringValue)feature).getValue();
            for (Annotation antn : qbfAnnotations) {
                String otherFeatureName;
                ValueReference otherFeature = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)antn, (String)FEATURE_PARAMETER_NAME);
                if (otherFeature == null || !featureName.equals(otherFeatureName = ((StringValue)otherFeature).getValue())) continue;
                validator.error("Feature must be unique among multiple Surrogate annotations used on a single pattern.", (EObject)annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, ANNOTATION_ISSUE_CODE, new String[0]);
                return true;
            }
        }
        return false;
    }
}

