/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.statistics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfBaseStatisticsDataTest {
    private static final String fTestName = "StatisticsDataTest";
    private final @NonNull String fTypeId1 = "Some type1";
    private final @NonNull String fTypeId2 = "Some type2";
    private final String fLabel0 = "label1";
    private final String fLabel1 = "label2";
    private final String fLabel2 = "label3";
    private final String[] fLabels = new String[]{"label1", "label2", "label3"};
    private final ITmfTimestamp fTimestamp1 = TmfTimestamp.create((long)12345L, (int)2);
    private final ITmfTimestamp fTimestamp2 = TmfTimestamp.create((long)12350L, (int)2);
    private final ITmfTimestamp fTimestamp3 = TmfTimestamp.create((long)12355L, (int)2);
    private final TmfEventType fType1 = new TmfEventType("Some type1", TmfEventField.makeRoot((String[])this.fLabels));
    private final TmfEventType fType2 = new TmfEventType("Some type1", TmfEventField.makeRoot((String[])this.fLabels));
    private final TmfEventType fType3 = new TmfEventType("Some type2", TmfEventField.makeRoot((String[])this.fLabels));
    private final ITmfEvent fEvent1;
    private final ITmfEvent fEvent2;
    private final ITmfEvent fEvent3;
    private final TmfEventField fContent1 = new TmfEventField(":root:", (Object)"Some content", null);
    private final TmfEventField fContent2;
    private final TmfEventField fContent3;
    private final TmfStatisticsTree fStatsTree;

    public TmfBaseStatisticsDataTest() {
        this.fEvent1 = new TmfEvent(null, -1L, this.fTimestamp1, (ITmfEventType)this.fType1, (ITmfEventField)this.fContent1);
        this.fContent2 = new TmfEventField(":root:", (Object)"Some other content", null);
        this.fEvent2 = new TmfEvent(null, -1L, this.fTimestamp2, (ITmfEventType)this.fType2, (ITmfEventField)this.fContent2);
        this.fContent3 = new TmfEventField(":root:", (Object)"Some other different content", null);
        this.fEvent3 = new TmfEvent(null, -1L, this.fTimestamp3, (ITmfEventType)this.fType3, (ITmfEventField)this.fContent3);
        this.fStatsTree = new TmfStatisticsTree();
        this.fStatsTree.setTotal(fTestName, true, 3L);
        this.fStatsTree.setTypeCount(fTestName, this.fEvent1.getType().getName(), true, 1L);
        this.fStatsTree.setTypeCount(fTestName, this.fEvent2.getType().getName(), true, 1L);
        this.fStatsTree.setTypeCount(fTestName, this.fEvent3.getType().getName(), true, 1L);
    }

    @Test
    public void testGetChildren() {
        Collection childrenTreeNode = this.fStatsTree.getRootNode().getChildren();
        Assert.assertEquals((String)"getChildren", (long)1L, (long)childrenTreeNode.size());
        TmfStatisticsTreeNode treeNode = (TmfStatisticsTreeNode)childrenTreeNode.iterator().next();
        Assert.assertEquals((String)"getChildren", (Object)fTestName, (Object)treeNode.getName());
        childrenTreeNode = this.fStatsTree.getNode(new String[]{fTestName}).getChildren();
        Assert.assertEquals((String)"getChildren", (long)1L, (long)childrenTreeNode.size());
        treeNode = (TmfStatisticsTreeNode)childrenTreeNode.iterator().next();
        Assert.assertEquals((String)"getChildren", (Object)Messages.TmfStatisticsData_EventTypes, (Object)treeNode.getName());
        Vector<String> keyExpected = new Vector<String>();
        keyExpected.add(this.fEvent1.getName());
        keyExpected.add(this.fEvent3.getName());
        childrenTreeNode = treeNode.getChildren();
        Assert.assertEquals((String)"getChildren", (long)2L, (long)childrenTreeNode.size());
        for (TmfStatisticsTreeNode temp : childrenTreeNode) {
            Assert.assertEquals((long)0L, (long)temp.getChildren().size());
            if (keyExpected.contains(temp.getName())) {
                keyExpected.removeElement(temp.getName());
                continue;
            }
            Assert.fail();
        }
        childrenTreeNode = ((TmfStatisticsTreeNode)childrenTreeNode.iterator().next()).getChildren();
        Assert.assertEquals((String)"getChildren", (long)0L, (long)childrenTreeNode.size());
    }

    @Test
    public void testRegisterEvent() {
        TmfStatisticsTreeNode trace = this.fStatsTree.getNode(new String[]{fTestName});
        Assert.assertEquals((String)"registerEvent", (long)3L, (long)trace.getValues().getTotal());
        Collection childrenTreeNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}).getChildren();
        for (TmfStatisticsTreeNode child : childrenTreeNode) {
            if (child.getName().compareTo(this.fEvent1.getType().getName()) == 0) {
                Assert.assertEquals((String)"registerEvent", (long)1L, (long)child.getValues().getTotal());
                continue;
            }
            if (child.getName().compareTo(this.fEvent3.getType().getName()) != 0) continue;
            Assert.assertEquals((String)"registerEvent", (long)1L, (long)child.getValues().getTotal());
        }
    }

    @Test
    public void testGet() {
        TmfStatisticsTreeNode traceRoot = this.fStatsTree.getNode(new String[]{fTestName});
        Assert.assertNotNull((String)"get", (Object)traceRoot);
        Assert.assertEquals((String)"get", (long)0L, (long)traceRoot.getPath()[0].compareTo(fTestName));
        Assert.assertEquals((String)"get", (long)3L, (long)traceRoot.getValues().getTotal());
        Assert.assertEquals((String)"get", (long)1L, (long)traceRoot.getNbChildren());
    }

    @Test
    public void testGetOrCreate() {
        Object[] newEventType = new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, "Fancy Type"};
        TmfStatisticsTreeNode newEventTypeNode = this.fStatsTree.getNode((String[])newEventType);
        Assert.assertNull((Object)newEventTypeNode);
        newEventTypeNode = this.fStatsTree.getOrCreateNode((String[])newEventType);
        Assert.assertNotNull((Object)newEventTypeNode);
        Assert.assertTrue((boolean)Arrays.equals(newEventType, newEventTypeNode.getPath()));
        newEventTypeNode.reset();
        newEventTypeNode = this.fStatsTree.getNode((String[])newEventType);
        Assert.assertNotNull((Object)newEventTypeNode);
        newEventTypeNode = this.fStatsTree.getOrCreateNode((String[])newEventType);
        Assert.assertNotNull((Object)newEventTypeNode);
        Assert.assertTrue((boolean)Arrays.equals(newEventType, newEventTypeNode.getPath()));
    }

    @Test
    public void testGetParent() {
        TmfStatisticsTreeNode parentNode = this.fStatsTree.getRootNode().getParent();
        Assert.assertNull((Object)parentNode);
        parentNode = this.fStatsTree.getNode(new String[]{fTestName}).getParent();
        Assert.assertNotNull((Object)parentNode);
        Assert.assertEquals((Object)parentNode.getPath().toString(), (Object)this.fStatsTree.getRootNode().getPath().toString());
        parentNode = this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}).getParent();
        Assert.assertNotNull((Object)parentNode);
        Assert.assertEquals((Object)parentNode.getPath().toString(), (Object)this.fStatsTree.getNode(new String[]{fTestName}).getPath().toString());
    }

    @Test
    public void testReset() {
        this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}).reset();
        Assert.assertEquals((long)0L, (long)this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}).getChildren().size());
        Assert.assertNull((Object)this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, this.fType1.getName()}));
        Assert.assertNull((Object)this.fStatsTree.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, this.fType3.getName()}));
        this.fStatsTree.getNode(new String[]{fTestName}).reset();
        Assert.assertEquals((long)0L, (long)this.fStatsTree.getNode(new String[]{fTestName}).getChildren().size());
    }
}

