/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXAxisChartViewer;
import org.eclipse.ui.IViewPart;
import org.junit.Assert;
import org.junit.Test;

public class KernelMemoryUsageViewTest
extends XYDataProviderBaseTest {
    private static final @NonNull String TITLE = "Relative Kernel Memory Usage";
    private static final @NonNull String TOTAL_PID = "bug446190:total";
    private static final @NonNull String SESSIOND_PID = "bug446190:482";
    private static final @NonNull String CONSUMERD_PID = "bug446190:496";
    private static final RGB GREEN = new RGB(0, 255, 0);
    private static final RGB RED = new RGB(255, 0, 0);
    private static final RGB BLUE = new RGB(0, 0, 255);
    private static final int NUMBER_OF_POINT = 50;
    private static final int MORE_POINTS = 100;
    private String fTraceName = null;

    @Test
    public void testKernelMemoryView() {
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof KernelMemoryUsageView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)KernelMemoryUsageViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        chartViewer.setNbPoints(50);
        SWTBotTree treeBot = this.getSWTBotView().bot().tree();
        SWTBotTreeItem totalNode = treeBot.getTreeItem(this.fTraceName);
        SWTBotUtils.waitUntil(root -> root.getItems().length >= 5, (Object)totalNode, (String)"Did not finish loading");
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 1, (Object)chart, (String)"No data available");
        this.verifySeriesStyle(TOTAL_PID, ISeries.SeriesType.LINE, BLUE, LineStyle.SOLID, false);
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[0]), (Object)"resources/kernelmemory/kernel-memory-res50.json", (String)"Chart data is not valid");
        SWTBotTreeItem sessiondEntry = totalNode.getNode("lttng-sessiond");
        sessiondEntry.check();
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"Only total available");
        this.verifySeriesStyle(SESSIOND_PID, ISeries.SeriesType.LINE, RED, LineStyle.SOLID, false);
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{SESSIOND_PID}), (Object)"resources/kernelmemory/kernel-memory-res50Selected.json", (String)"Chart data is not valid");
        SWTBotTreeItem consumerdEntry = totalNode.getNode("lttng-consumerd");
        consumerdEntry.check();
        chartViewer.setNbPoints(100);
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 3, (Object)chart, (String)"Only total and sessiond available");
        this.verifySeriesStyle(CONSUMERD_PID, ISeries.SeriesType.LINE, GREEN, LineStyle.SOLID, false);
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{CONSUMERD_PID}), (Object)"resources/kernelmemory/kernel-memory-res100Selected.json", (String)"Chart data is not valid");
    }

    @Test
    public void testFilter() {
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof KernelMemoryUsageView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)KernelMemoryUsageViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        SWTBotUtils.waitUntil(bot -> bot.tree().getTreeItem(this.fTraceName).getItems().length == 5, (Object)this.getSWTBotView().bot(), (String)"Failed to load the filtered threads");
        this.getSWTBotView().toolbarButton("Showing active threads").click();
        SWTBotUtils.waitUntil(bot -> bot.tree().getTreeItem(this.fTraceName).getItems().length == 16, (Object)this.getSWTBotView().bot(), (String)"Failed to load all the threads");
        this.getSWTBotView().toolbarButton("Showing all threads").click();
        SWTBotUtils.waitUntil(bot -> bot.tree().getTreeItem(this.fTraceName).getItems().length == 5, (Object)this.getSWTBotView().bot(), (String)"Failed to filter the threads");
    }

    protected @NonNull String getMainSeriesName() {
        return TOTAL_PID;
    }

    protected @NonNull String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview";
    }

    protected ITmfTrace getTestTrace() {
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
        this.fTraceName = trace.getName();
        return trace;
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
    }
}

