/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportExportWizard;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.DelegateProgressMonitorInUIThreadAndPreservingFocus;
import org.eclipse.ui.internal.wizards.datatransfer.ProjectConfiguratorExtensionManager;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJob;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SmartImportRootWizardPage
extends WizardPage {
    static final String IMPORTED_SOURCES = SmartImportRootWizardPage.class.getName() + ".knownSources";
    private static final String STORE_HIDE_ALREADY_OPEN = "SmartImportRootWizardPage.STORE_HIDE_ALREADY_OPEN";
    private static final String STORE_NESTED_PROJECTS = "SmartImportRootWizardPage.STORE_NESTED_PROJECTS";
    private static final String STORE_CLOSE_IMPORTED = "SmartImportRootWizardPage.STORE_CLOSE_IMPORTED";
    private static final String STORE_CONFIGURE_NATURES = "SmartImportRootWizardPage.STORE_CONFIGURE_NATURES";
    private File selection;
    private Combo rootDirectoryText;
    private ControlDecoration rootDirectoryTextDecorator;
    private CheckboxTreeViewer tree;
    private boolean hideAlreadyOpen = false;
    private ControlDecoration proposalSelectionDecorator;
    private Set<File> directoriesToImport;
    private Label selectionSummary;
    protected Map<File, List<ProjectConfigurator>> potentialProjects = Collections.emptyMap();
    private boolean closeProjectsAfterImport = false;
    private boolean detectNestedProjects = true;
    private boolean configureProjects = true;
    private Set<IWorkingSet> workingSets;
    private WorkingSetGroup workingSetsGroup;
    protected Supplier<ProgressMonitorPart> wizardProgressMonitor = new Supplier<ProgressMonitorPart>(){
        private ProgressMonitorPart progressMonitorPart;

        @Override
        public ProgressMonitorPart get() {
            if (this.progressMonitorPart == null) {
                try {
                    SmartImportRootWizardPage.this.getWizard().getContainer().run(false, true, monitor -> {
                        if (monitor instanceof ProgressMonitorPart) {
                            this.progressMonitorPart = (ProgressMonitorPart)monitor;
                        }
                    });
                }
                catch (InvocationTargetException ite) {
                    Status status = new Status(4, "org.eclipse.ui.ide", DataTransferMessages.SmartImportWizardPage_scanProjectsFailed, ite.getCause());
                    StatusManager.getManager().handle((IStatus)status, 3);
                }
                catch (InterruptedException operationCanceled) {
                    Thread.interrupted();
                }
            }
            return this.progressMonitorPart;
        }
    };
    private Job refreshProposalsJob;
    private ProgressManager.JobMonitor jobMonitor;
    private DelegateProgressMonitorInUIThreadAndPreservingFocus delegateMonitor;
    private SelectionListener cancelWorkListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            SmartImportRootWizardPage.this.stopAndDisconnectCurrentWork();
        }
    };
    private Button selectAllButton;
    private Button deselectAllButton;

    public SmartImportRootWizardPage(SmartImportWizard wizard, File initialSelection, Set<IWorkingSet> initialWorkingSets) {
        super(SmartImportRootWizardPage.class.getName());
        this.selection = initialSelection;
        this.workingSets = initialWorkingSets;
        if (this.workingSets == null) {
            this.workingSets = new HashSet<IWorkingSet>();
        }
        this.setWizard((IWizard)wizard);
    }

    public void setWizard(IWizard easymportWizard) {
        Assert.isTrue((boolean)(easymportWizard instanceof SmartImportWizard));
        super.setWizard(easymportWizard);
    }

    public SmartImportWizard getWizard() {
        return (SmartImportWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        this.setTitle(DataTransferMessages.SmartImportWizardPage_importProjectsInFolderTitle);
        this.setDescription(DataTransferMessages.SmartImportWizardPage_importProjectsInFolderDescription);
        this.initializeDialogUnits((Control)parent);
        this.loadWidgetStates();
        Composite res = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(10, 10).numColumns(4).equalWidth(false).applyTo(res);
        this.createInputSelectionOptions(res);
        GridData proposalsGroupLayoutData = new GridData(4, 4, true, true, 4, 1);
        proposalsGroupLayoutData.verticalIndent = 12;
        this.createProposalsGroup(res).setLayoutData((Object)proposalsGroupLayoutData);
        this.createConfigurationOptions(res);
        this.createWorkingSetsGroup(res);
        this.createLink(res);
        if (this.selection != null) {
            this.rootDirectoryText.setText(this.selection.getAbsolutePath());
            this.validatePage();
        }
        this.setControl((Control)res);
    }

    private void createLink(Composite res) {
        Link showOtherImportWizards = new Link(res, 0);
        showOtherImportWizards.setText("<A>" + DataTransferMessages.SmartImportWizardPage_showOtherSpecializedImportWizard + "</A>");
        showOtherImportWizards.setLayoutData((Object)new GridData(0x1000008, 0x1000008, true, false, 4, 1));
        showOtherImportWizards.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportWizard importWizard = new ImportExportWizard("import");
                StructuredSelection sel = null;
                sel = SmartImportRootWizardPage.this.selection != null ? new StructuredSelection((Object)SmartImportRootWizardPage.this.selection) : new StructuredSelection();
                importWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)sel);
                IDialogSettings workbenchSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(WorkbenchPlugin.class)).getDialogSettings();
                IDialogSettings wizardSettings = workbenchSettings.getSection("ImportExportAction");
                if (wizardSettings == null) {
                    wizardSettings = workbenchSettings.addNewSection("ImportExportAction");
                }
                importWizard.setDialogSettings(wizardSettings);
                importWizard.addPages();
                SmartImportRootWizardPage.this.getWizard().getContainer().showPage(importWizard.getPages()[0]);
            }
        });
    }

    private void createWorkingSetsGroup(Composite parent) {
        Composite workingSetComposite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 128, true, false, 4, 1);
        layoutData.verticalIndent = 10;
        workingSetComposite.setLayoutData((Object)layoutData);
        GridLayoutFactory.fillDefaults().applyTo(workingSetComposite);
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        String[] workingSetIds = (String[])Arrays.stream(registry.getNewPageWorkingSetDescriptors()).map(WorkingSetDescriptor::getId).toArray(String[]::new);
        StructuredSelection wsSel = null;
        if (this.workingSets != null) {
            wsSel = new StructuredSelection(this.workingSets.toArray());
        }
        this.workingSetsGroup = new WorkingSetGroup(workingSetComposite, (IStructuredSelection)wsSel, workingSetIds);
    }

    private void createInputSelectionOptions(Composite parent) {
        Label rootDirectoryLabel = new Label(parent, 0);
        rootDirectoryLabel.setText(DataTransferMessages.SmartImportWizardPage_selectRootDirectory);
        this.rootDirectoryText = new Combo(parent, 2048);
        String[] knownSources = this.getWizard().getDialogSettings().getArray(IMPORTED_SOURCES);
        if (knownSources != null) {
            this.rootDirectoryText.setItems(knownSources);
        }
        GridData rootDirectoryTextLayoutData = new GridData(4, 0x1000000, true, false);
        this.rootDirectoryText.setLayoutData((Object)rootDirectoryTextLayoutData);
        this.rootDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SmartImportRootWizardPage.this.selection = new File(((Combo)e.widget).getText());
                if (SmartImportWizard.isValidArchive(SmartImportRootWizardPage.this.selection)) {
                    if (SmartImportWizard.getExpandDirectory(SmartImportRootWizardPage.this.selection).isDirectory()) {
                        if (MessageDialog.openConfirm((Shell)SmartImportRootWizardPage.this.getShell(), (String)DataTransferMessages.SmartImportWizardPage_overwriteArchiveDirectory_title, (String)NLS.bind((String)DataTransferMessages.SmartImportWizardPage_overwriteArchiveDirectory_message, (Object)SmartImportWizard.getExpandDirectory(SmartImportRootWizardPage.this.selection)))) {
                            this.expandSelectedArchive();
                        }
                    } else {
                        this.expandSelectedArchive();
                    }
                }
                SmartImportRootWizardPage.this.validatePage();
                SmartImportRootWizardPage.this.refreshProposals();
            }

            private void expandSelectedArchive() {
                try {
                    SmartImportRootWizardPage.this.getContainer().run(true, true, monitor -> {
                        SmartImportRootWizardPage.this.getWizard().expandArchive(SmartImportRootWizardPage.this.selection, monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    });
                }
                catch (Exception ex) {
                    MessageDialog.openWarning((Shell)SmartImportRootWizardPage.this.getShell(), (String)DataTransferMessages.SmartImportWizardPage_incompleteExpand_title, (String)NLS.bind((String)DataTransferMessages.SmartImportWizardPage_incompleteExpand_title, (Object)SmartImportWizard.getExpandDirectory(SmartImportRootWizardPage.this.selection)));
                }
            }
        });
        this.rootDirectoryTextDecorator = new ControlDecoration((Control)this.rootDirectoryText, 16512);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        rootDirectoryTextLayoutData.horizontalIndent += errorImage.getBounds().width;
        this.rootDirectoryTextDecorator.setImage(errorImage);
        this.rootDirectoryTextDecorator.setDescriptionText(DataTransferMessages.SmartImportWizardPage_incorrectRootDirectory);
        this.rootDirectoryTextDecorator.hide();
        Button directoryButton = new Button(parent, 8);
        directoryButton.setText(DataTransferMessages.SmartImportWizardPage_browse);
        this.setButtonLayoutData(directoryButton);
        directoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory;
                DirectoryDialog dialog = new DirectoryDialog(SmartImportRootWizardPage.this.getShell(), 0x10000000);
                dialog.setText(DataTransferMessages.SmartImportWizardPage_browseForFolder);
                dialog.setMessage(DataTransferMessages.SmartImportWizardPage_selectFolderOrArchiveToImport);
                if (SmartImportRootWizardPage.this.rootDirectoryText.getText() != null) {
                    File current = new File(SmartImportRootWizardPage.this.rootDirectoryText.getText());
                    if (current.isDirectory()) {
                        dialog.setFilterPath(current.getAbsolutePath());
                    } else if (current.isFile()) {
                        dialog.setFilterPath(current.getParentFile().getAbsolutePath());
                    }
                }
                if (dialog.getFilterPath() == null) {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                }
                if ((directory = dialog.open()) != null) {
                    SmartImportRootWizardPage.this.rootDirectoryText.setText(directory);
                }
            }
        });
        Button browseArchiveButton = new Button(parent, 8);
        browseArchiveButton.setText(DataTransferMessages.SmartImportWizardPage_selectArchiveButton);
        this.setButtonLayoutData(browseArchiveButton);
        browseArchiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String archive;
                FileDialog dialog = new FileDialog(SmartImportRootWizardPage.this.getShell(), 0x10000000);
                dialog.setText(DataTransferMessages.SmartImportWizardPage_selectArchiveTitle);
                dialog.setFilterExtensions(new String[]{"*.zip;*.tar;*.tar.gz"});
                dialog.setFilterNames(new String[]{DataTransferMessages.SmartImportWizardPage_allSupportedArchives});
                if (SmartImportRootWizardPage.this.rootDirectoryText.getText() != null) {
                    File current = new File(SmartImportRootWizardPage.this.rootDirectoryText.getText());
                    if (current.isDirectory()) {
                        dialog.setFilterPath(current.getAbsolutePath());
                    } else if (current.isFile()) {
                        dialog.setFilterPath(current.getParentFile().getAbsolutePath());
                        dialog.setFileName(current.getName());
                    }
                }
                if (dialog.getFilterPath() == null) {
                    dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toString());
                }
                if ((archive = dialog.open()) != null) {
                    SmartImportRootWizardPage.this.rootDirectoryText.setText(archive);
                }
            }
        });
    }

    private void createConfigurationOptions(Composite parent) {
        Button closeProjectsCheckbox = new Button(parent, 32);
        closeProjectsCheckbox.setText(DataTransferMessages.SmartImportWizardPage_closeProjectsAfterImport);
        closeProjectsCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        closeProjectsCheckbox.setSelection(this.closeProjectsAfterImport);
        closeProjectsCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.closeProjectsAfterImport = closeProjectsCheckbox.getSelection();
        }));
        Link showDetectorsLink = new Link(parent, 0);
        showDetectorsLink.setText(DataTransferMessages.SmartImportWizardPage_showAvailableDetectors);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 4;
        showDetectorsLink.setLayoutData((Object)gridData);
        showDetectorsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder message = new StringBuilder();
                message.append(DataTransferMessages.SmartImportWizardPage_availableDetectors_description);
                message.append('\n');
                message.append('\n');
                ArrayList<String> extensionsLabels = new ArrayList<String>(ProjectConfiguratorExtensionManager.getAllExtensionLabels());
                extensionsLabels.sort(null);
                for (String extensionLabel : extensionsLabels) {
                    message.append("* ");
                    message.append(extensionLabel);
                    message.append('\n');
                }
                MessageDialog.openInformation((Shell)SmartImportRootWizardPage.this.getShell(), (String)DataTransferMessages.SmartImportWizardPage_availableDetectors_title, (String)message.toString());
            }
        });
        GridData layoutData = new GridData(16384, 0x1000000, false, false, 4, 1);
        final Button detectNestedProjectsCheckbox = new Button(parent, 32);
        detectNestedProjectsCheckbox.setText(DataTransferMessages.SmartImportWizardPage_detectNestedProjects);
        detectNestedProjectsCheckbox.setLayoutData((Object)layoutData);
        detectNestedProjectsCheckbox.setSelection(this.detectNestedProjects);
        detectNestedProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartImportRootWizardPage.this.detectNestedProjects = detectNestedProjectsCheckbox.getSelection();
                SmartImportRootWizardPage.this.refreshProposals();
            }
        });
        final Button configureProjectsCheckbox = new Button(parent, 32);
        configureProjectsCheckbox.setText(DataTransferMessages.SmartImportWizardPage_configureProjects);
        configureProjectsCheckbox.setLayoutData((Object)layoutData);
        configureProjectsCheckbox.setSelection(this.configureProjects);
        configureProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SmartImportRootWizardPage.this.configureProjects = configureProjectsCheckbox.getSelection();
                SmartImportRootWizardPage.this.refreshProposals();
            }
        });
    }

    private Composite createProposalsGroup(Composite parent) {
        Composite res = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(res);
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filterTree = new FilteredTree(res, 2080, patternFilter, true){

            public CheckboxTreeViewer doCreateTreeViewer(Composite treeParent, int style) {
                CheckboxTreeViewer checkboxTreeViewer = new CheckboxTreeViewer(treeParent, style);
                checkboxTreeViewer.setUseHashlookup(true);
                return checkboxTreeViewer;
            }
        };
        this.tree = (CheckboxTreeViewer)filterTree.getViewer();
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.heightHint = 90;
        this.tree.getControl().setLayoutData((Object)treeGridData);
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Map)inputElement).keySet().toArray(File[]::new);
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.tree.setComparator(new ViewerComparator(){

            public int compare(Viewer v, Object o1, Object o2) {
                return ((File)o1).getAbsolutePath().compareTo(((File)o2).getAbsolutePath());
            }
        });
        this.tree.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return SmartImportRootWizardPage.this.directoriesToImport.contains(element);
            }
        });
        this.tree.addCheckStateListener(event -> {
            if (this.isExistingProject((File)event.getElement()) || this.isExistingProjectName((File)event.getElement())) {
                this.tree.setChecked(event.getElement(), false);
                return;
            }
            if (event.getChecked()) {
                this.directoriesToImport.add((File)event.getElement());
            } else {
                this.directoriesToImport.remove(event.getElement());
            }
            this.proposalsSelectionChanged();
        });
        this.tree.getTree().setHeaderVisible(true);
        TreeViewerColumn pathColumn = new TreeViewerColumn((TreeViewer)this.tree, 0);
        pathColumn.setLabelProvider((CellLabelProvider)new FolderForProjectsLabelProvider());
        this.tree.getTree().getColumn(0).setText(DataTransferMessages.SmartImportProposals_folder);
        this.tree.getTree().getColumn(0).setWidth(500);
        TreeViewerColumn projectTypeColumn = new TreeViewerColumn((TreeViewer)this.tree, 0);
        projectTypeColumn.setLabelProvider((CellLabelProvider)new ProjectConfiguratorLabelProvider());
        this.tree.getTree().getColumn(1).setText(DataTransferMessages.SmartImportProposals_importAs);
        this.tree.getTree().getColumn(1).setWidth(150);
        this.proposalSelectionDecorator = new ControlDecoration((Control)this.tree.getTree(), 16512);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.proposalSelectionDecorator.setImage(errorImage);
        this.proposalSelectionDecorator.setDescriptionText(DataTransferMessages.SmartImportWizardPage_selectAtLeastOneFolderToOpenAsProject);
        this.proposalSelectionDecorator.hide();
        Composite selectionButtonsGroup = new Composite(res, 0);
        GridLayoutFactory.fillDefaults().applyTo(selectionButtonsGroup);
        selectionButtonsGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        this.selectAllButton = new Button(selectionButtonsGroup, 8);
        this.setButtonLayoutData(this.selectAllButton);
        this.selectAllButton.setText(DataTransferMessages.DataTransfer_selectAll);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = SmartImportRootWizardPage.this.tree.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    File dir = (File)item.getData();
                    if (SmartImportRootWizardPage.this.isExistingProject(dir) || SmartImportRootWizardPage.this.isExistingProjectName(dir)) {
                        SmartImportRootWizardPage.this.tree.setChecked((Object)dir, false);
                    } else {
                        SmartImportRootWizardPage.this.tree.setChecked((Object)dir, true);
                        SmartImportRootWizardPage.this.directoriesToImport.add(dir);
                    }
                    ++n2;
                }
                SmartImportRootWizardPage.this.proposalsSelectionChanged();
            }
        });
        this.deselectAllButton = new Button(selectionButtonsGroup, 8);
        this.setButtonLayoutData(this.deselectAllButton);
        this.deselectAllButton.setText(DataTransferMessages.DataTransfer_deselectAll);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = SmartImportRootWizardPage.this.tree.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    SmartImportRootWizardPage.this.tree.setChecked(item, false);
                    SmartImportRootWizardPage.this.directoriesToImport.remove(item);
                    ++n2;
                }
                SmartImportRootWizardPage.this.proposalsSelectionChanged();
            }
        });
        this.selectionSummary = new Label(selectionButtonsGroup, 0);
        this.selectionSummary.setLayoutData((Object)new GridData(4, 1024, true, true, 1, 1));
        this.selectionSummary.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_selectionSummary, (Object)0, (Object)0));
        Button hideProjectsAlreadyInWorkspace = new Button(selectionButtonsGroup, 32);
        hideProjectsAlreadyInWorkspace.setText(DataTransferMessages.SmartImportProposals_hideExistingProjects);
        hideProjectsAlreadyInWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){
            final ViewerFilter existingProjectsFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !SmartImportRootWizardPage.this.isExistingProject((File)element);
                }
            };

            public void widgetSelected(SelectionEvent e) {
                ViewerFilter[] currentFilters = SmartImportRootWizardPage.this.tree.getFilters();
                ViewerFilter[] newFilters = null;
                SmartImportRootWizardPage.this.hideAlreadyOpen = ((Button)e.widget).getSelection();
                if (SmartImportRootWizardPage.this.hideAlreadyOpen) {
                    newFilters = new ViewerFilter[currentFilters.length + 1];
                    System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                    newFilters[newFilters.length - 1] = this.existingProjectsFilter;
                } else {
                    ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(currentFilters.length > 0 ? currentFilters.length - 1 : 0);
                    ViewerFilter[] viewerFilterArray = currentFilters;
                    int n = currentFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter filter = viewerFilterArray[n2];
                        if (filter != this.existingProjectsFilter) {
                            filters.add(filter);
                        }
                        ++n2;
                    }
                    newFilters = filters.toArray(new ViewerFilter[filters.size()]);
                }
                SmartImportRootWizardPage.this.tree.setFilters(newFilters);
            }
        });
        hideProjectsAlreadyInWorkspace.setSelection(this.hideAlreadyOpen);
        hideProjectsAlreadyInWorkspace.notifyListeners(13, new Event());
        this.tree.setInput(Collections.emptyMap());
        return res;
    }

    protected boolean isExistingProject(File element) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IPath location = project.getLocation();
            if (location != null && element.equals(location.toFile())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isExistingProjectName(File element) {
        String name = element.getName();
        return !name.isEmpty() && ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists();
    }

    protected void validatePage() {
        this.setErrorMessage(null);
        if (this.tree.getCheckedElements().length == 0) {
            this.proposalSelectionDecorator.show();
            this.setErrorMessage(this.proposalSelectionDecorator.getDescriptionText());
        } else {
            this.proposalSelectionDecorator.hide();
        }
        if (!this.sourceIsValid()) {
            this.rootDirectoryTextDecorator.show();
            this.setErrorMessage(this.rootDirectoryTextDecorator.getDescriptionText());
        } else {
            this.rootDirectoryTextDecorator.hide();
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        return this.sourceIsValid() && this.getWizard().createOrGetConfiguredImportJob() != null && (this.getWizard().createOrGetConfiguredImportJob().getDirectoriesToImport() == null || !this.getWizard().createOrGetConfiguredImportJob().getDirectoriesToImport().isEmpty());
    }

    private boolean sourceIsValid() {
        return this.selection != null && (this.selection.isDirectory() || SmartImportWizard.isValidArchive(this.selection));
    }

    public File getSelectedRoot() {
        return this.selection;
    }

    public void setInitialImportRoot(File directoryOrArchive) {
        this.selection = directoryOrArchive;
        this.rootDirectoryText.setText(directoryOrArchive.getAbsolutePath());
        this.refreshProposals();
    }

    public Set<IWorkingSet> getSelectedWorkingSets() {
        this.workingSets = new HashSet<IWorkingSet>();
        Runnable workingSetsRetriever = () -> Collections.addAll(this.workingSets, this.workingSetsGroup.getSelectedWorkingSets());
        if (Display.getCurrent() == null) {
            this.getContainer().getShell().getDisplay().syncExec(workingSetsRetriever);
        } else {
            workingSetsRetriever.run();
        }
        return this.workingSets;
    }

    private void proposalsSelectionChanged() {
        if (this.getWizard().createOrGetConfiguredImportJob() != null) {
            if (this.potentialProjects.size() == 1 && this.potentialProjects.values().iterator().next().isEmpty()) {
                this.getWizard().createOrGetConfiguredImportJob().setDirectoriesToImport(null);
                this.getWizard().createOrGetConfiguredImportJob().setExcludedDirectories(null);
                this.selectionSummary.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_selectionSummary, (Object)this.directoriesToImport.size(), (Object)1));
            } else {
                HashSet<File> excludedDirectories = new HashSet<File>(((Map)this.tree.getInput()).keySet());
                for (File directory : this.directoriesToImport) {
                    excludedDirectories.remove(directory);
                }
                this.getWizard().createOrGetConfiguredImportJob().setDirectoriesToImport(this.directoriesToImport);
                this.getWizard().createOrGetConfiguredImportJob().setExcludedDirectories(excludedDirectories);
                this.selectionSummary.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_selectionSummary, (Object)this.directoriesToImport.size(), (Object)this.potentialProjects.size()));
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isDetectNestedProject() {
        return this.detectNestedProjects;
    }

    public boolean isConfigureProjects() {
        return this.configureProjects;
    }

    boolean isCloseProjectsAfterImport() {
        return this.closeProjectsAfterImport;
    }

    private void refreshProposals() {
        this.stopAndDisconnectCurrentWork();
        this.potentialProjects = Collections.emptyMap();
        this.proposalsUpdated();
        if (this.sourceIsValid()) {
            this.tree.getControl().setEnabled(false);
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
            final TreeItem computingItem = new TreeItem(this.tree.getTree(), -1);
            computingItem.setText(NLS.bind((String)DataTransferMessages.SmartImportJob_inspecting, (Object)this.selection.getAbsolutePath()));
            final SmartImportJob importJob = this.getWizard().createOrGetConfiguredImportJob();
            this.refreshProposalsJob = new Job(NLS.bind((String)DataTransferMessages.SmartImportJob_inspecting, (Object)this.selection.getAbsolutePath())){

                public IStatus run(IProgressMonitor monitor) {
                    SmartImportRootWizardPage.this.potentialProjects = importJob.getImportProposals(monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!SmartImportRootWizardPage.this.potentialProjects.containsKey(importJob.getRoot())) {
                        SmartImportRootWizardPage.this.potentialProjects.put(importJob.getRoot(), Collections.emptyList());
                    }
                    return Status.OK_STATUS;
                }
            };
            Control previousFocusControl = this.tree.getControl().getDisplay().getFocusControl();
            if (previousFocusControl == null) {
                previousFocusControl = this.rootDirectoryText;
            }
            Point initialSelection = this.rootDirectoryText.getSelection();
            this.wizardProgressMonitor.get().attachToCancelComponent(null);
            this.wizardProgressMonitor.get().setVisible(true);
            previousFocusControl.setFocus();
            this.rootDirectoryText.setSelection(initialSelection);
            ToolItem stopButton = SmartImportRootWizardPage.getStopButton(this.wizardProgressMonitor.get());
            stopButton.addSelectionListener(this.cancelWorkListener);
            this.jobMonitor = ProgressManager.getInstance().progressFor(this.refreshProposalsJob);
            this.delegateMonitor = new DelegateProgressMonitorInUIThreadAndPreservingFocus(this.wizardProgressMonitor.get());
            this.jobMonitor.addProgressListener((IProgressMonitor)this.delegateMonitor);
            this.refreshProposalsJob.setPriority(10);
            this.refreshProposalsJob.setUser(true);
            this.refreshProposalsJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Control control = SmartImportRootWizardPage.this.tree.getControl();
                    if (!control.isDisposed()) {
                        control.getDisplay().asyncExec(() -> {
                            IStatus result = event.getResult();
                            if (!control.isDisposed() && result.isOK()) {
                                computingItem.dispose();
                                if (SmartImportRootWizardPage.this.sourceIsValid() && SmartImportRootWizardPage.this.getWizard().createOrGetConfiguredImportJob() == importJob) {
                                    SmartImportRootWizardPage.this.proposalsUpdated();
                                }
                                SmartImportRootWizardPage.this.tree.getTree().setEnabled(SmartImportRootWizardPage.this.potentialProjects.size() > 1);
                                SmartImportRootWizardPage.this.selectAllButton.setEnabled(SmartImportRootWizardPage.this.potentialProjects.size() > 1);
                                SmartImportRootWizardPage.this.deselectAllButton.setEnabled(SmartImportRootWizardPage.this.potentialProjects.size() > 1);
                            } else if (result.getCode() == 8) {
                                computingItem.setText(DataTransferMessages.SmartImportProposals_inspecitionCanceled);
                            } else if (result.getCode() == 4) {
                                computingItem.setText(NLS.bind((String)DataTransferMessages.SmartImportProposals_errorWhileInspecting, (Object)result.getMessage()));
                            }
                            if (!SmartImportRootWizardPage.this.wizardProgressMonitor.get().isDisposed() && SmartImportRootWizardPage.this.refreshProposalsJob.getState() == 0) {
                                SmartImportRootWizardPage.this.wizardProgressMonitor.get().setVisible(false);
                            }
                        });
                    }
                }
            });
            this.refreshProposalsJob.schedule(0L);
        }
    }

    private static ToolItem getStopButton(ProgressMonitorPart part) {
        Control[] controlArray = part.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof ToolBar) {
                ToolItem[] toolItemArray = ((ToolBar)control).getItems();
                int n3 = toolItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ToolItem item = toolItemArray[n4];
                    if (item.getToolTipText().equals(JFaceResources.getString((String)"ProgressMonitorPart.cancelToolTip"))) {
                        return item;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private void stopAndDisconnectCurrentWork() {
        if (this.refreshProposalsJob != null) {
            this.refreshProposalsJob.cancel();
        }
    }

    private void proposalsUpdated() {
        this.tree.setInput(this.potentialProjects);
        this.directoriesToImport = new HashSet<File>();
        for (File dir : this.potentialProjects.keySet()) {
            if (this.isExistingProject(dir) || this.isExistingProjectName(dir)) continue;
            this.directoriesToImport.add(dir);
        }
        this.tree.setCheckedElements(this.directoriesToImport.toArray(new Object[this.directoriesToImport.size()]));
        this.proposalsSelectionChanged();
        this.validatePage();
    }

    public void dispose() {
        this.saveWidgetStates();
        this.stopAndDisconnectCurrentWork();
        SmartImportRootWizardPage.getStopButton(this.wizardProgressMonitor.get()).removeSelectionListener(this.cancelWorkListener);
        super.dispose();
    }

    private void loadWidgetStates() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && dialogSettings.get(STORE_HIDE_ALREADY_OPEN) != null) {
            this.hideAlreadyOpen = dialogSettings.getBoolean(STORE_HIDE_ALREADY_OPEN);
            this.closeProjectsAfterImport = dialogSettings.getBoolean(STORE_CLOSE_IMPORTED);
            this.detectNestedProjects = dialogSettings.getBoolean(STORE_NESTED_PROJECTS);
            this.configureProjects = dialogSettings.getBoolean(STORE_CONFIGURE_NATURES);
        }
    }

    private void saveWidgetStates() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            dialogSettings.put(STORE_HIDE_ALREADY_OPEN, this.hideAlreadyOpen);
            dialogSettings.put(STORE_CLOSE_IMPORTED, this.closeProjectsAfterImport);
            dialogSettings.put(STORE_NESTED_PROJECTS, this.detectNestedProjects);
            dialogSettings.put(STORE_CONFIGURE_NATURES, this.configureProjects);
        }
    }

    public ProgressMonitorPart getWizardProgressMonitor() {
        return this.wizardProgressMonitor.get();
    }

    public void setCloseProjectsAfterImport(boolean closeProjectsAfterImport) {
        this.closeProjectsAfterImport = closeProjectsAfterImport;
    }

    private class FolderForProjectsLabelProvider
    extends CellLabelProvider
    implements IColorProvider {
        private FolderForProjectsLabelProvider() {
        }

        public String getText(Object o) {
            Path relative;
            Path parent;
            Path rootPath;
            File file = (File)o;
            Path filePath = file.toPath();
            if (filePath.startsWith(rootPath = SmartImportRootWizardPage.this.getWizard().createOrGetConfiguredImportJob().getRoot().toPath()) && (parent = rootPath.getParent()) != null && (relative = parent.relativize(filePath)).getNameCount() > 0) {
                return relative.toString();
            }
            return filePath.toString();
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (SmartImportRootWizardPage.this.isExistingProject((File)o) || SmartImportRootWizardPage.this.isExistingProjectName((File)o)) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            Color color = this.getForeground(cell.getElement());
            if (color != null) {
                cell.setForeground(color);
            }
        }
    }

    private class ProjectConfiguratorLabelProvider
    extends CellLabelProvider
    implements IColorProvider {
        private ProjectConfiguratorLabelProvider() {
        }

        public String getText(Object o) {
            File file = (File)o;
            if (SmartImportRootWizardPage.this.isExistingProject(file)) {
                return DataTransferMessages.SmartImportProposals_alreadyImportedAsProject_title;
            }
            if (SmartImportRootWizardPage.this.isExistingProjectName(file)) {
                return DataTransferMessages.SmartImportProposals_anotherProjectWithSameNameExists_title;
            }
            List<ProjectConfigurator> configurators = SmartImportRootWizardPage.this.potentialProjects.get(file);
            if (configurators.isEmpty()) {
                return "";
            }
            return ProjectConfiguratorExtensionManager.getLabel(configurators.get(0));
        }

        public Color getBackground(Object o) {
            return null;
        }

        public Color getForeground(Object o) {
            if (SmartImportRootWizardPage.this.isExistingProject((File)o) || SmartImportRootWizardPage.this.isExistingProjectName((File)o)) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            Color color = this.getForeground(cell.getElement());
            if (color != null) {
                cell.setForeground(color);
            }
        }
    }
}

