/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.internal.ui.synchronize.patch.PatchModelProvider;
import org.eclipse.team.internal.ui.synchronize.patch.PatchWorkbenchLabelProvider;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class PatchSyncLabelProvider
extends SynchronizationLabelProvider {
    private PatchWorkbenchLabelProvider delegate;

    @Override
    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        this.delegate = new PatchWorkbenchLabelProvider();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    @Override
    protected ILabelProvider getDelegateLabelProvider() {
        return this.delegate;
    }

    @Override
    protected IDiff getDiff(Object element) {
        if (element instanceof PatchDiffNode) {
            IResource resource = PatchModelProvider.getResource((PatchDiffNode)element);
            return this.getContext().getDiffTree().getDiff(resource);
        }
        return super.getDiff(element);
    }

    @Override
    protected Image getCompareImage(Image base, int kind) {
        switch (kind & 0xC) {
            case 4: {
                kind = kind & 0xFFFFFFFB | 8;
                break;
            }
            case 8: {
                kind = kind & 0xFFFFFFF7 | 4;
                break;
            }
        }
        return super.getCompareImage(base, kind);
    }
}

