/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.VariablesPlugin;

public class AntClasspathEntry
implements IAntClasspathEntry {
    private String entryString;
    private boolean eclipseRequired = false;
    private URL url = null;

    @Override
    public String getLabel() {
        return this.entryString;
    }

    @Override
    public URL getEntryURL() {
        if (this.url != null) {
            return this.url;
        }
        try {
            String expanded = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.entryString);
            return new URL("file:" + expanded);
        }
        catch (CoreException e) {
            try {
                return new URL("file:" + this.entryString);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            AntCorePlugin.log(e);
            return null;
        }
    }

    public AntClasspathEntry(String entryString) {
        this.entryString = entryString;
    }

    public AntClasspathEntry(URL url) {
        this.url = url;
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            this.entryString = URIUtil.toFile((URI)URIUtil.toURI((URL)fileURL)).getAbsolutePath();
        }
        catch (IOException | URISyntaxException e) {
            AntCorePlugin.log(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IAntClasspathEntry) {
            IAntClasspathEntry other = (IAntClasspathEntry)obj;
            return this.entryString.equals(other.getLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.entryString.hashCode();
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public boolean isEclipseRuntimeRequired() {
        return this.eclipseRequired;
    }

    public void setEclipseRuntimeRequired(boolean eclipseRequired) {
        this.eclipseRequired = eclipseRequired;
    }
}

