/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.eclipse.core.runtime.Platform;

public class Tracer {
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private final String prefix;
    private static final PrintStream out = System.out;

    public static boolean isTracingEnabled(String debugOption) {
        return Platform.isRunning() && Boolean.parseBoolean(Platform.getDebugOption((String)debugOption));
    }

    public static Tracer create(String prefix, String debugOption) {
        if (Tracer.isTracingEnabled(debugOption)) {
            return new Tracer(prefix);
        }
        return null;
    }

    protected Tracer(String prefix) {
        this.prefix = prefix;
    }

    public void trace(Object o) {
        out.printf("%s %s: %s\n", this.getTimestamp(), this.prefix, o);
    }

    public void trace(String msg, Object ... params) {
        this.trace(String.format(msg, params));
    }

    public void traceStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        t.printStackTrace(printer);
        printer.flush();
        this.trace(writer.toString());
    }

    private String getTimestamp() {
        return timeFormatter.format(Instant.now());
    }
}

