/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace;

import java.util.UUID;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class UUIDParser
implements ICommonTreeParser {
    private static final String INVALID_FORMAT_FOR_UUID = "Invalid format for UUID";
    private static final String INVALID_VALUE_FOR_UUID = "Invalid value for UUID";
    public static final UUIDParser INSTANCE = new UUIDParser();

    private UUIDParser() {
    }

    @Override
    public UUID parse(ICTFMetadataNode tree, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        ICTFMetadataNode firstChild = tree.getChild(0);
        if (TsdlUtils.isAnyUnaryString(firstChild)) {
            if (tree.getChildCount() > 1) {
                throw new ParseException(INVALID_VALUE_FOR_UUID);
            }
            String uuidstr = UnaryStringParser.INSTANCE.parse(firstChild, null);
            try {
                return UUID.fromString(uuidstr);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(INVALID_FORMAT_FOR_UUID, e);
            }
        }
        throw new ParseException(INVALID_VALUE_FOR_UUID);
    }
}

