/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.AbstractStandardImportWizardTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class StandardImportGzipTraceTest
extends AbstractStandardImportWizardTest {
    private static final String ROOT_FOLDER = "/";
    private static File fGzipTrace;

    @BeforeClass
    public static void initGzip() {
        StandardImportGzipTraceTest.zipTrace();
    }

    @Before
    public void setup() {
        this.createProject();
        SWTBotPreferences.TIMEOUT = 20000L;
    }

    @After
    public void tearDown() {
        SWTBotUtils.deleteProject("Tracing", StandardImportGzipTraceTest.getSWTBot());
    }

    @Test
    public void testGzipImport() {
        SWTWorkbenchBot bot = StandardImportGzipTraceTest.getSWTBot();
        this.openImportWizard();
        SWTBotImportWizardUtils.selectImportFromArchive((SWTBot)bot, fGzipTrace.getAbsolutePath());
        SWTBotImportWizardUtils.selectFolder((SWTBot)bot, true, ROOT_FOLDER);
        SWTBotCheckBox checkBox = bot.checkBox(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        Assert.assertFalse((boolean)checkBox.isEnabled());
        SWTBotCombo comboBox = bot.comboBoxWithLabel(Messages.ImportTraceWizard_TraceType);
        comboBox.setSelection("Test trace : TMF Tests");
        this.importFinish();
        Assert.assertNotNull((Object)fGzipTrace);
        String name = fGzipTrace.getName();
        Assert.assertNotNull((Object)name);
        Assert.assertTrue((name.length() > 3 ? 1 : 0) != 0);
        String traceName = name.substring(0, name.length() - 3);
        Assert.assertNotNull((Object)traceName);
        Assert.assertFalse((boolean)traceName.isEmpty());
        SWTBotView projectExplorer = bot.viewById("org.eclipse.ui.navigator.ProjectExplorer");
        projectExplorer.setFocus();
        SWTBotTree tree = projectExplorer.bot().tree();
        SWTBotTreeItem treeItem = SWTBotUtils.getTreeItem(projectExplorer.bot(), tree, "Tracing", "Traces [1]", traceName);
        treeItem.doubleClick();
        WaitUtils.waitForJobs();
        SWTBot editorBot = SWTBotUtils.activeEventsEditor(bot).bot();
        SWTBotTable editorTable = editorBot.table();
        editorBot.waitUntil(ConditionHelpers.isTableCellFilled(editorTable, "Type-1", 2, 2));
        editorBot.waitUntil(ConditionHelpers.isTableCellFilled(editorTable, "", 1, 0));
        String c22 = editorTable.cell(2, 2);
        String c10 = editorTable.cell(1, 0);
        Assert.assertEquals((Object)"Type-1", (Object)c22);
        Assert.assertEquals((Object)"", (Object)c10);
    }

    private static void zipTrace() {
        try {
            fGzipTrace = File.createTempFile("trace", ".gz");
            byte[] buffer = new byte[1024];
            Throwable throwable = null;
            Object var2_4 = null;
            try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(fGzipTrace));){
                Throwable throwable2 = null;
                Object var5_9 = null;
                try (FileInputStream in = new FileInputStream(TmfTestTrace.A_TEST_10K2.getFullPath());){
                    int len;
                    while ((len = in.read(buffer)) > 0) {
                        gzos.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                gzos.finish();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

