/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.event.BinaryFTraceConstants;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceDataType;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFormatField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceValueSign;

public class BinaryFTraceParsingUtils {
    private BinaryFTraceParsingUtils() {
    }

    protected static BinaryFTraceEventFormat parseEventFormat(String strEventFormat) {
        int nameLabelIndex = strEventFormat.indexOf("Name:");
        int idLabelIndex = strEventFormat.indexOf("ID");
        int formatLabelIndex = strEventFormat.indexOf("format:");
        int formatStringLabelIndex = strEventFormat.indexOf("print fmt:");
        String eventFormatName = strEventFormat.substring(nameLabelIndex + "Name:".length() + 1, idLabelIndex).trim();
        int eventFormatID = Integer.parseInt(strEventFormat.substring(idLabelIndex + "ID".length() + 1, formatLabelIndex).trim());
        String strEventFields = strEventFormat.substring(formatLabelIndex + "format:".length() + 1, formatStringLabelIndex).trim();
        String formatString = strEventFormat.substring(formatStringLabelIndex);
        String[] fields = strEventFields.split("\n");
        HashMap<String, BinaryFTraceFormatField> lstFieldsCommon = new HashMap<String, BinaryFTraceFormatField>();
        HashMap<String, BinaryFTraceFormatField> lstFieldsCustom = new HashMap<String, BinaryFTraceFormatField>();
        int i = 0;
        while (i < fields.length) {
            String strField = fields[i].trim();
            if (!strField.equals("")) {
                BinaryFTraceFormatField eventFormatField = BinaryFTraceParsingUtils.parseEventFormatField(strField);
                if (eventFormatField.getFieldName().contains("common_")) {
                    lstFieldsCommon.put(eventFormatField.getFieldName(), eventFormatField);
                } else {
                    lstFieldsCustom.put(eventFormatField.getFieldName(), eventFormatField);
                }
            }
            ++i;
        }
        return new BinaryFTraceEventFormat(eventFormatID, eventFormatName, lstFieldsCommon, lstFieldsCustom, formatString);
    }

    protected static List<BinaryFTraceFormatField> parseEventFormatFields(String[] fields) {
        ArrayList<BinaryFTraceFormatField> lstFields = new ArrayList<BinaryFTraceFormatField>();
        int i = 0;
        while (i < fields.length) {
            String strField = fields[i].trim();
            if (!strField.isEmpty()) {
                BinaryFTraceFormatField eventFormatField = BinaryFTraceParsingUtils.parseEventFormatField(strField);
                lstFields.add(eventFormatField);
            }
            ++i;
        }
        return lstFields;
    }

    private static BinaryFTraceFormatField parseEventFormatField(String strField) {
        String[] fieldProperties;
        BinaryFTraceFormatField.BinaryFTraceFormatFieldBuilder eventFormatBuilder = new BinaryFTraceFormatField.BinaryFTraceFormatFieldBuilder();
        String[] stringArray = fieldProperties = strField.split(";");
        int n = fieldProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            String[] keyValuePair = property.split(":");
            String key = keyValuePair[0].trim();
            String value = keyValuePair[1].trim();
            switch (key) {
                case "field": {
                    Matcher fieldNameMatcher = BinaryFTraceConstants.FIELD_NAME_PATTERN.matcher(value);
                    if (!fieldNameMatcher.matches()) break;
                    String fieldName = fieldNameMatcher.group("identifier");
                    eventFormatBuilder.fieldName(fieldName);
                    int arrayLength = -1;
                    String strArrayLength = fieldNameMatcher.group("arrayLength");
                    if (strArrayLength != null) {
                        arrayLength = strArrayLength.trim().isEmpty() ? 0 : Integer.parseInt(strArrayLength);
                    } else if (fieldNameMatcher.group("arrayType") != null) {
                        arrayLength = 0;
                    }
                    eventFormatBuilder.array(arrayLength);
                    BinaryFTraceDataType type = BinaryFTraceDataType.getDataType(fieldNameMatcher.group("type"));
                    eventFormatBuilder.fieldType(type);
                    boolean isDataLoc = fieldNameMatcher.group("dataLoc") != null;
                    eventFormatBuilder.dataLoc(isDataLoc);
                    boolean isPointer = fieldNameMatcher.group("pointer") != null;
                    eventFormatBuilder.pointer(isPointer);
                    eventFormatBuilder.strFieldType(value);
                    break;
                }
                case "offset": {
                    eventFormatBuilder.offset(Integer.parseInt(value));
                    break;
                }
                case "size": {
                    eventFormatBuilder.size(Integer.parseInt(value));
                    break;
                }
                case "signed": {
                    BinaryFTraceValueSign sign = BinaryFTraceValueSign.getEnumFromString(value);
                    if (sign == null) break;
                    eventFormatBuilder.signed(sign);
                    break;
                }
            }
            ++n2;
        }
        return eventFormatBuilder.build();
    }
}

