/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;

@NonNullByDefault
public class StringDeclaration
extends Declaration {
    private static final StringDeclaration STRING_DEC_UTF8 = new StringDeclaration(Encoding.UTF8);
    private static final StringDeclaration STRING_DEC_ASCII = new StringDeclaration(Encoding.ASCII);
    private static final StringDeclaration STRING_DEC_NO_ENC = new StringDeclaration(Encoding.NONE);
    private static final int BITS_PER_BYTE = 8;
    private final Encoding fEncoding;

    private StringDeclaration(Encoding encoding) {
        this.fEncoding = encoding;
    }

    public static StringDeclaration getStringDeclaration() {
        return STRING_DEC_UTF8;
    }

    public static StringDeclaration getStringDeclaration(Encoding encoding) {
        switch (encoding) {
            case ASCII: {
                return STRING_DEC_ASCII;
            }
            case NONE: {
                return STRING_DEC_NO_ENC;
            }
            case UTF8: {
                return STRING_DEC_UTF8;
            }
        }
        throw new IllegalArgumentException("Unrecognized encoding: " + String.valueOf((Object)encoding));
    }

    public Encoding getEncoding() {
        return this.fEncoding;
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return 8;
    }

    @Override
    public StringDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        String value = this.read(input);
        return new StringDefinition(this, definitionScope, fieldName, value);
    }

    private String read(BitBuffer input) throws CTFException {
        this.alignRead(input);
        StringBuilder sb = new StringBuilder();
        char c = (char)input.get(8, false);
        while (c != '\u0000') {
            sb.append(c);
            c = (char)input.get(8, false);
        }
        return sb.toString();
    }

    public String toString() {
        return "[declaration] string[" + Integer.toHexString(this.hashCode()) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31;
        switch (this.fEncoding) {
            case ASCII: {
                ++result;
                break;
            }
            case NONE: {
                result += 2;
                break;
            }
            case UTF8: {
                result += 3;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringDeclaration other = (StringDeclaration)obj;
        return this.fEncoding == other.fEncoding;
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration other) {
        return this.equals(other);
    }
}

