/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.statesystem;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.provider.StateSystemDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.Messages;
import org.eclipse.tracecompass.tmf.ui.views.statesystem.StateSystemEvent;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

class StateSystemPresentationProvider
extends TimeGraphPresentationProvider {
    public static final int NUM_COLORS = 9;
    private static final StateItem[] STATE_TABLE = new StateItem[10];
    private IPaletteProvider fPalette = new RotatingPaletteProvider.Builder().setNbColors(9).build();

    static {
        StateSystemPresentationProvider.STATE_TABLE[9] = new StateItem(new RGB(192, 192, 192), "UNKNOWN");
    }

    StateSystemPresentationProvider() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public StateItem[] getStateTable() {
        if (STATE_TABLE[0] == null) {
            @NonNull List colors = this.fPalette.get();
            int i = 0;
            while (i < colors.size()) {
                RGBAColor rgbaColor = (RGBAColor)colors.get(i);
                StateSystemPresentationProvider.STATE_TABLE[i] = new StateItem(RGBAUtil.fromInt((int)rgbaColor.toInt()).rgb, rgbaColor.toString());
                ++i;
            }
        }
        return STATE_TABLE;
    }

    @Override
    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent) {
            ITmfTreeDataModel model;
            TimeEvent timeEvent = (TimeEvent)event;
            String value = timeEvent.getLabel();
            if (value != null) {
                return Math.floorMod(value.hashCode(), 9);
            }
            ITimeGraphEntry entry = event.getEntry();
            if (entry != null && ((model = ((TimeGraphEntry)entry).getEntryModel()) instanceof StateSystemDataProvider.StateSystemEntryModel || model instanceof StateSystemDataProvider.ModuleEntryModel)) {
                return -1;
            }
            return 9;
        }
        return -1;
    }

    @Override
    public String getEventName(ITimeEvent event) {
        if (event instanceof StateSystemEvent) {
            Object object = ((StateSystemEvent)event).getInterval().getValue();
            return object != null ? object.getClass().getSimpleName() : Messages.TypeNull;
        }
        return null;
    }

    @Override
    public String getStateTypeName(ITimeGraphEntry entry) {
        if (entry instanceof TimeGraphEntry) {
            ITmfTreeDataModel model = ((TimeGraphEntry)entry).getEntryModel();
            if (model instanceof StateSystemDataProvider.TraceEntryModel) {
                return Messages.TraceEntry_StateTypeName;
            }
            if (model instanceof StateSystemDataProvider.ModuleEntryModel) {
                return Messages.ModuleEntry_StateTypeName;
            }
            if (model instanceof StateSystemDataProvider.StateSystemEntryModel) {
                return Messages.StateSystemEntry_StateTypeName;
            }
        }
        return Messages.AttributeEntry_StateTypeName;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        Map parameters;
        Map<String, String> retMap = super.getEventHoverToolTipInfo(event, hoverTime);
        if (retMap == null) {
            retMap = new LinkedHashMap<String, String>(1);
        }
        if (!(event.getEntry() instanceof TimeGraphEntry)) {
            return retMap;
        }
        TimeGraphEntry entry = (TimeGraphEntry)event.getEntry();
        ITimeGraphDataProvider<? extends TimeGraphEntryModel> dataProvider = BaseDataProviderTimeGraphView.getProvider(entry);
        @NonNull @NonNull @NonNull TmfModelResponse response = dataProvider.fetchTooltip(parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(hoverTime, hoverTime, 1, Collections.singletonList(entry.getEntryModel().getId()))), null);
        @NonNull @NonNull Map map = (Map)response.getModel();
        if (map != null) {
            retMap.putAll(map);
        }
        return retMap;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof TimeEvent) {
            ITimeGraphEntry entry = event.getEntry();
            ITmfTreeDataModel model = ((TimeGraphEntry)entry).getEntryModel();
            if (model instanceof StateSystemDataProvider.StateSystemEntryModel) {
                TimeGraphEntry moduleEntry = (TimeGraphEntry)entry.getParent();
                StateSystemDataProvider.ModuleEntryModel moduleModel = (StateSystemDataProvider.ModuleEntryModel)moduleEntry.getEntryModel();
                ITmfAnalysisModuleWithStateSystems module = moduleModel.getModule();
                if (module instanceof TmfAbstractAnalysisModule) {
                    retMap.putAll(((TmfAbstractAnalysisModule)module).getProperties());
                }
            } else if (model instanceof StateSystemDataProvider.ModuleEntryModel) {
                ITmfAnalysisModuleWithStateSystems module = ((StateSystemDataProvider.ModuleEntryModel)model).getModule();
                retMap.put(Messages.ModuleHelpText, module.getHelpText());
                retMap.put(Messages.ModuleIsAutomatic, Boolean.toString(module.isAutomatic()));
            }
        }
        return retMap;
    }
}

