/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ease.ui.views.shell.dropins.AbstractDropin;
import org.eclipse.ease.ui.views.shell.dropins.IShellDropin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TabFolder;

public class DropinsSelectionProvider
implements ISelectionProvider,
SelectionListener,
ISelectionChangedListener {
    private final ListenerList<ISelectionChangedListener> fListeners = new ListenerList();
    private final Collection<IShellDropin> fDropins;

    public DropinsSelectionProvider(TabFolder tabFolder, Collection<IShellDropin> dropins) {
        this.fDropins = dropins;
        for (IShellDropin dropin : dropins) {
            dropin.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        tabFolder.addSelectionListener((SelectionListener)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.getSelectionProvider().getSelection();
    }

    public void setSelection(ISelection selection) {
        this.getSelectionProvider().setSelection(selection);
    }

    private ISelectionProvider getSelectionProvider() {
        for (IShellDropin dropin : this.fDropins) {
            if (!dropin.getPartControl(null, null).isVisible()) continue;
            return dropin.getSelectionProvider();
        }
        return AbstractDropin.EMPTY_SELECTION_PROVIDER;
    }

    public void widgetSelected(SelectionEvent e) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.fListeners) {
            listener.selectionChanged(event);
        }
    }
}

