/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.model;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.ui.refactoring.model.AbstractSynchronizationCompareAdapter;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.model.JavaModelProvider;
import org.eclipse.wst.jsdt.internal.ui.model.JavaSynchronizationContentProvider;

public final class JavaSynchronizationCompareAdapter
extends AbstractSynchronizationCompareAdapter {
    private static final String MODEL_PROVIDER_ID = "modelProviderId";
    private static final String MODEL_PROVIDERS = "modelProviders";
    private static final String RESOURCE_PATH = "resourcePath";
    private static final String RESOURCE_TYPE = "resourceType";
    private static final String RESOURCES = "resources";
    private static final String WORKING_SET_NAME = "workingSetName";
    private static final String WORKING_SETS = "workingSets";

    public ICompareInput asCompareInput(ISynchronizationContext context, Object element) {
        if (element instanceof RefactoringDescriptorProxy) {
            return super.asCompareInput(context, element);
        }
        IResource resource = JavaModelProvider.getResource(element);
        if (resource != null) {
            return super.asCompareInput(context, (Object)resource);
        }
        return null;
    }

    public ResourceMapping[] restore(IMemento memento) {
        IMemento[] children = memento.getChildren(RESOURCES);
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int index = 0;
        while (index < children.length) {
            String pathString;
            Integer typeInt = children[index].getInteger(RESOURCE_TYPE);
            if (typeInt != null && (pathString = children[index].getString(RESOURCE_PATH)) != null) {
                ResourceMapping mapping;
                IWorkspaceRoot resource = null;
                Path path = new Path(pathString);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                switch (typeInt) {
                    case 8: {
                        resource = root;
                        break;
                    }
                    case 4: {
                        resource = root.getProject(path.lastSegment());
                        break;
                    }
                    case 1: {
                        resource = root.getFile((IPath)path);
                        break;
                    }
                    case 2: {
                        resource = root.getFolder((IPath)path);
                    }
                }
                if (resource != null && (mapping = JavaSynchronizationContentProvider.getResourceMapping(resource)) != null) {
                    result.add(mapping);
                }
            }
            ++index;
        }
        children = memento.getChildren(WORKING_SETS);
        index = 0;
        while (index < children.length) {
            ResourceMapping mapping;
            IWorkingSet set;
            String name = children[index].getString(WORKING_SET_NAME);
            if (name != null && (set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name)) != null && (mapping = JavaSynchronizationContentProvider.getResourceMapping(set)) != null) {
                result.add(mapping);
            }
            ++index;
        }
        children = memento.getChildren(MODEL_PROVIDERS);
        index = 0;
        while (index < children.length) {
            IModelProviderDescriptor descriptor;
            String id = children[index].getString(MODEL_PROVIDER_ID);
            if (id != null && (descriptor = ModelProvider.getModelProviderDescriptor((String)id)) != null) {
                try {
                    ResourceMapping mapping;
                    ModelProvider provider = descriptor.getModelProvider();
                    if (provider != null && (mapping = JavaSynchronizationContentProvider.getResourceMapping(provider)) != null) {
                        result.add(mapping);
                    }
                }
                catch (CoreException event) {
                    JavaScriptPlugin.log(event);
                }
            }
            ++index;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public void save(ResourceMapping[] mappings, IMemento memento) {
        int index = 0;
        while (index < mappings.length) {
            IJavaScriptElement element;
            IResource resource;
            Object object = mappings[index].getModelObject();
            if (object instanceof IJavaScriptElement && (resource = (IResource)(element = (IJavaScriptElement)object).getAdapter(IResource.class)) != null) {
                IMemento child = memento.createChild(RESOURCES);
                child.putInteger(RESOURCE_TYPE, resource.getType());
                child.putString(RESOURCE_PATH, resource.getFullPath().toString());
            }
            if (object instanceof IResource) {
                IResource resource2 = (IResource)object;
                IMemento child = memento.createChild(RESOURCES);
                child.putInteger(RESOURCE_TYPE, resource2.getType());
                child.putString(RESOURCE_PATH, resource2.getFullPath().toString());
            } else if (object instanceof IWorkingSet) {
                memento.createChild(WORKING_SETS).putString(WORKING_SET_NAME, ((IWorkingSet)object).getName());
            } else if (object instanceof ModelProvider) {
                memento.createChild(MODEL_PROVIDERS).putString(MODEL_PROVIDER_ID, ((ModelProvider)object).getId());
            }
            ++index;
        }
    }
}

