/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.cdt.utils.WindowsArgumentQuoter;
import org.eclipse.cdt.utils.pty.ConPTYKernel32;

public class ConPTY {
    private Handles handles = new Handles();

    public ConPTY() throws IOException {
        this.handles.pseudoConsole = new WinNT.HANDLEByReference();
        this.handles.pipeIn = new WinNT.HANDLEByReference();
        this.handles.pipeOut = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference phPipePTYIn = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference phPipePTYOut = new WinNT.HANDLEByReference();
        boolean res = ConPTYKernel32.INSTANCE.CreatePipe(phPipePTYIn, this.handles.pipeOut, null, 0);
        ConPTY.checkErr(res, "CreatePipe");
        res = ConPTYKernel32.INSTANCE.CreatePipe(this.handles.pipeIn, phPipePTYOut, null, 0);
        ConPTY.checkErr(res, "CreatePipe");
        ConPTYKernel32.COORD_ByValue consoleSize = new ConPTYKernel32.COORD_ByValue();
        consoleSize.X = (short)80;
        consoleSize.Y = (short)24;
        WinNT.HRESULT hr = ConPTYKernel32.INSTANCE.CreatePseudoConsole(consoleSize, phPipePTYIn.getValue(), phPipePTYOut.getValue(), new WinDef.DWORD(0L), this.handles.pseudoConsole);
        ConPTY.checkErr(hr, "CreatePseudoConsole");
        res = ConPTYKernel32.INSTANCE.CloseHandle(phPipePTYOut.getValue());
        ConPTY.checkErr(res, "CloseHandle");
        res = ConPTYKernel32.INSTANCE.CloseHandle(phPipePTYIn.getValue());
        ConPTY.checkErr(res, "CloseHandle");
    }

    public int exec(String[] cmdarray, String[] envp, String dir) throws IOException {
        String quoted = WindowsArgumentQuoter.quoteArgv(cmdarray, false);
        this.handles.startupInfo = new ConPTYKernel32.STARTUPINFOEX();
        this.handles.threadAttributeListMemory = ConPTY.PrepareStartupInformation(this.handles.startupInfo, this.handles.pseudoConsole);
        this.handles.processInformation = new WinBase.PROCESS_INFORMATION();
        boolean status = ConPTYKernel32.INSTANCE.CreateProcess(null, quoted, null, null, false, new WinDef.DWORD(525312L), (Pointer)ConPTY.toByteArray(envp), dir, this.handles.startupInfo, this.handles.processInformation);
        ConPTY.checkErr(status, "CreateProcess");
        return this.getPID();
    }

    public static Memory toByteArray(String[] envp) throws IOException {
        if (envp == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String[] stringArray = envp;
        int n = envp.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            bos.write(string.getBytes(StandardCharsets.UTF_16LE));
            bos.write(0);
            bos.write(0);
            ++n2;
        }
        bos.write(0);
        bos.write(0);
        byte[] byteArray = bos.toByteArray();
        Memory memory = new Memory((long)byteArray.length);
        memory.write(0L, byteArray, 0, byteArray.length);
        return memory;
    }

    public int getPID() {
        this.handles.pid = this.handles.processInformation.dwProcessId.intValue();
        return this.handles.pid;
    }

    private static Memory PrepareStartupInformation(ConPTYKernel32.STARTUPINFOEX pStartupInfo, WinNT.HANDLEByReference phPC) throws IOException {
        pStartupInfo.StartupInfo.cb = new WinDef.DWORD((long)pStartupInfo.size());
        pStartupInfo.StartupInfo.hStdOutput = new WinNT.HANDLE();
        pStartupInfo.StartupInfo.hStdError = new WinNT.HANDLE();
        pStartupInfo.StartupInfo.hStdInput = new WinNT.HANDLE();
        pStartupInfo.StartupInfo.dwFlags = 256;
        ConPTYKernel32.SIZE_TByReference attrListSize = new ConPTYKernel32.SIZE_TByReference();
        boolean res = ConPTYKernel32.INSTANCE.InitializeProcThreadAttributeList(Pointer.NULL, new WinDef.DWORD(1L), new WinDef.DWORD(0L), attrListSize);
        Kernel32.INSTANCE.SetLastError(0);
        Memory memory = new Memory(attrListSize.getValue().longValue());
        res = ConPTYKernel32.INSTANCE.InitializeProcThreadAttributeList((Pointer)memory, new WinDef.DWORD(1L), new WinDef.DWORD(0L), attrListSize);
        ConPTY.checkErr(res, "InitializeProcThreadAttributeList");
        BaseTSD.DWORD_PTR dwPROC_THREAD_ATTRIBUTE_PSEUDOCONSOLE = new BaseTSD.DWORD_PTR(131094L);
        res = ConPTYKernel32.INSTANCE.UpdateProcThreadAttribute((Pointer)memory, new WinDef.DWORD(0L), dwPROC_THREAD_ATTRIBUTE_PSEUDOCONSOLE, new WinDef.PVOID(phPC.getValue().getPointer()), new BaseTSD.SIZE_T((long)Native.POINTER_SIZE), null, null);
        ConPTY.checkErr(res, "UpdateProcThreadAttribute");
        pStartupInfo.lpAttributeList = memory.share(0L);
        return memory;
    }

    public int waitFor() {
        try {
            int what = 0;
            WinNT.HANDLE hProc = Kernel32.INSTANCE.OpenProcess(0x100400, false, this.getPID());
            ConPTY.checkErr(hProc, "OpenProcess");
            what = Kernel32.INSTANCE.WaitForSingleObject(hProc, -1);
            IntByReference exit_code = new IntByReference(0);
            if (what == 0) {
                Kernel32.INSTANCE.GetExitCodeProcess(hProc, exit_code);
            }
            boolean closeHandle = Kernel32.INSTANCE.CloseHandle(hProc);
            ConPTY.checkErr(closeHandle, "CloseHandle");
            return exit_code.getValue();
        }
        catch (IOException e) {
            return -1;
        }
    }

    public synchronized void close() throws IOException {
        if (this.handles == null) {
            return;
        }
        boolean res = ConPTYKernel32.INSTANCE.CloseHandle(this.handles.processInformation.hThread);
        ConPTY.checkErr(res, "CloseHandle processInformation.hThread");
        res = ConPTYKernel32.INSTANCE.CloseHandle(this.handles.processInformation.hProcess);
        ConPTY.checkErr(res, "CloseHandle processInformation.hProcess");
        ConPTYKernel32.INSTANCE.DeleteProcThreadAttributeList(this.handles.startupInfo.lpAttributeList);
        this.handles.threadAttributeListMemory.clear();
        ConPTYKernel32.INSTANCE.ClosePseudoConsole(this.handles.pseudoConsole.getValue());
        res = ConPTYKernel32.INSTANCE.CancelIoEx(this.handles.pipeIn.getValue(), Pointer.NULL);
        int err = Native.getLastError();
        if (err != 1168) {
            ConPTY.checkErr(res, "CancelIoEx");
        }
        res = ConPTYKernel32.INSTANCE.CloseHandle(this.handles.pipeOut.getValue());
        ConPTY.checkErr(res, "CloseHandle pipeOut");
        res = ConPTYKernel32.INSTANCE.CloseHandle(this.handles.pipeIn.getValue());
        ConPTY.checkErr(res, "CloseHandle pipeIn");
        this.handles = null;
    }

    public int read(byte[] buf) throws IOException {
        if (this.handles == null) {
            throw new IOException("ConPTY is closed.");
        }
        WinNT.HANDLEByReference pipe = this.handles.pipeIn;
        IntByReference dwBytesRead = new IntByReference(0);
        boolean fRead = false;
        fRead = Kernel32.INSTANCE.ReadFile(pipe.getValue(), buf, buf.length, dwBytesRead, null);
        ConPTY.checkErr(fRead, "ReadFile");
        int value = dwBytesRead.getValue();
        if (value == 0) {
            return -1;
        }
        return value;
    }

    public void write(byte[] buf) throws IOException {
        if (this.handles == null) {
            throw new IOException("ConPTY is closed.");
        }
        IntByReference dwBytesWritten = new IntByReference(0);
        boolean fWritten = false;
        fWritten = Kernel32.INSTANCE.WriteFile(this.handles.pipeOut.getValue(), buf, buf.length, dwBytesWritten, null);
        ConPTY.checkErr(fWritten, "WriteFile");
    }

    public void setTerminalSize(int width, int height) throws IOException {
        if (this.handles == null) {
            throw new IOException("ConPTY is closed.");
        }
        ConPTYKernel32.COORD_ByValue consoleSize = new ConPTYKernel32.COORD_ByValue();
        consoleSize.X = (short)width;
        consoleSize.Y = (short)height;
        WinNT.HRESULT result = ConPTYKernel32.INSTANCE.ResizePseudoConsole(this.handles.pseudoConsole.getValue(), consoleSize);
        ConPTY.checkErr(result, "ResizePseudoConsole");
    }

    private static void checkErr(WinNT.HRESULT hr, String method) throws IOException {
        if (!WinError.S_OK.equals((Object)hr)) {
            String msg = Kernel32Util.getLastErrorMessage();
            throw new IOException(String.format("%s: %s", method, msg));
        }
    }

    private static void checkErr(boolean status, String method) throws IOException {
        if (!status) {
            int lastError = Native.getLastError();
            String msg = Kernel32Util.formatMessage((int)lastError);
            throw new IOException(String.format("%s: %s: %s", method, lastError, msg));
        }
    }

    private static void checkErr(WinNT.HANDLE handle, String method) throws IOException {
        if (handle == null) {
            String msg = Kernel32Util.getLastErrorMessage();
            throw new IOException(String.format("%s: %s", method, msg));
        }
    }

    private static class Handles {
        private WinNT.HANDLEByReference pseudoConsole;
        private ConPTYKernel32.STARTUPINFOEX startupInfo;
        private Memory threadAttributeListMemory;
        private WinBase.PROCESS_INFORMATION processInformation;
        private WinNT.HANDLEByReference pipeOut;
        private WinNT.HANDLEByReference pipeIn;
        public int pid;

        private Handles() {
        }
    }
}

