/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.linecharts;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.extensions.core.AbstractPointSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;

public class LineSeriesSettings
extends AbstractPointSeriesSettings
implements ILineSeriesSettings {
    private int antialias = -1;
    private boolean enableArea = true;
    private Color lineColor = Display.getDefault().getSystemColor(3);
    private int lineWidth = 1;
    private boolean enableStack = false;
    private boolean enableStep = false;
    private LineStyle lineStyle = LineStyle.SOLID;
    private ILineSeriesSettings seriesSettingsHighlight = null;

    @Override
    public int getAntialias() {
        return this.antialias;
    }

    @Override
    public void setAntialias(int antialias) {
        this.antialias = antialias;
    }

    @Override
    public boolean isEnableArea() {
        return this.enableArea;
    }

    @Override
    public void setEnableArea(boolean enableArea) {
        this.enableArea = enableArea;
    }

    @Override
    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public boolean isEnableStack() {
        return this.enableStack;
    }

    @Override
    public void setEnableStack(boolean enableStack) {
        this.enableStack = enableStack;
    }

    @Override
    public boolean isEnableStep() {
        return this.enableStep;
    }

    @Override
    public void setEnableStep(boolean enableStep) {
        this.enableStep = enableStep;
    }

    @Override
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Override
    public ISeriesSettings getSeriesSettingsHighlight() {
        if (this.seriesSettingsHighlight == null) {
            try {
                this.seriesSettingsHighlight = (ILineSeriesSettings)this.clone();
                this.seriesSettingsHighlight.setHighlight(true);
            }
            catch (CloneNotSupportedException e) {
                this.seriesSettingsHighlight = new LineSeriesSettings();
            }
        }
        return this.seriesSettingsHighlight;
    }

    @Override
    public ISeriesSettings makeDeepCopy() {
        LineSeriesSettings lineSeriesSettings = new LineSeriesSettings();
        this.transfer(lineSeriesSettings);
        return lineSeriesSettings;
    }

    @Override
    public boolean transfer(ISeriesSettings seriesSettingsSink) {
        boolean success = false;
        if (seriesSettingsSink instanceof ILineSeriesSettings) {
            LineSeriesSettings source = this;
            ILineSeriesSettings sink = (ILineSeriesSettings)seriesSettingsSink;
            sink.setDescription(source.getDescription());
            sink.setVisible(source.isVisible());
            sink.setVisibleInLegend(source.isVisibleInLegend());
            sink.setAntialias(source.getAntialias());
            sink.setEnableArea(source.isEnableArea());
            sink.setSymbolType(source.getSymbolType());
            sink.setSymbolSize(source.getSymbolSize());
            sink.setSymbolColor(source.getSymbolColor());
            sink.setLineColor(source.getLineColor());
            sink.setLineWidth(source.getLineWidth());
            sink.setEnableStack(source.isEnableStack());
            sink.setEnableStep(source.isEnableStep());
            sink.setLineStyle(source.getLineStyle());
            sink.setHighlight(source.isHighlight());
            success = true;
        }
        return success;
    }

    protected Object clone() throws CloneNotSupportedException {
        LineSeriesSettings lineSeriesSettings = new LineSeriesSettings();
        this.transfer(lineSeriesSettings);
        return lineSeriesSettings;
    }
}

