/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.core.analysis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.SegmentSpecifier;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class InAndOutAnalysisStateProvider
extends CallStackStateProvider {
    private List<@NonNull SegmentSpecifier> fList;
    private final Map<Object, Multimap<String, SegmentSpecifier.SegmentContext>> fTable = new HashMap<Object, Multimap<String, SegmentSpecifier.SegmentContext>>();
    private SegmentSpecifier.SegmentContext fLast = null;
    private SegmentSpecifier.SegmentContext fFirst = null;

    public InAndOutAnalysisStateProvider(ITmfTrace trace, List<@NonNull SegmentSpecifier> list) {
        super(Objects.requireNonNull(trace));
        this.fList = list;
    }

    public int getVersion() {
        return 1;
    }

    public CallStackStateProvider getNewInstance() {
        return new InAndOutAnalysisStateProvider(this.getTrace(), this.fList);
    }

    protected boolean considerEvent(ITmfEvent event) {
        this.fFirst = null;
        this.fLast = null;
        for (SegmentSpecifier spec : this.fList) {
            String outContext;
            Optional ctx;
            Multimap<String, SegmentSpecifier.SegmentContext> contexts;
            Object classifier;
            SegmentSpecifier.SegmentContext context = spec.getSegmentContext(event);
            if (context != null && (classifier = context.getClassifier()) != null) {
                Multimap map = this.fTable.computeIfAbsent(classifier, unused -> HashMultimap.create());
                map.put((Object)String.valueOf(context.getContext()), (Object)context);
                this.fFirst = context;
                return true;
            }
            if (!spec.matchesOutName(event) || (classifier = spec.getClassifier(event)) == null || (contexts = this.fTable.get(classifier)) == null || contexts.isEmpty() || !(ctx = contexts.get((Object)String.valueOf(outContext = spec.getOutContext(event))).stream().findAny()).isPresent()) continue;
            this.fLast = (SegmentSpecifier.SegmentContext)ctx.get();
            return true;
        }
        return false;
    }

    protected @Nullable ITmfStateValue functionEntry(ITmfEvent event) {
        SegmentSpecifier.SegmentContext segmentContext = this.fFirst;
        if (segmentContext == null) {
            return null;
        }
        return TmfStateValue.newValueString((String)segmentContext.getLabel());
    }

    protected @Nullable ITmfStateValue functionExit(ITmfEvent event) {
        Optional victim;
        if (this.fLast == null) {
            return null;
        }
        Multimap<String, SegmentSpecifier.SegmentContext> map = this.fTable.get(this.fLast.getClassifier());
        if (map != null && (victim = map.get((Object)this.fLast.getContext()).stream().findAny()).isPresent()) {
            map.remove((Object)this.fLast.getContext(), victim.get());
        }
        return TmfStateValue.newValueString((String)this.fLast.getLabel());
    }

    protected int getProcessId(@NonNull ITmfEvent event) {
        int cls = InAndOutAnalysisStateProvider.classifierFrom(this.fFirst);
        if (cls > -1) {
            return cls;
        }
        cls = InAndOutAnalysisStateProvider.classifierFrom(this.fLast);
        if (cls > -1) {
            return cls;
        }
        return 0;
    }

    private static int classifierFrom(SegmentSpecifier.SegmentContext context) {
        Object clsPrime = null;
        if (context != null) {
            clsPrime = context.getClassifier();
        }
        if (clsPrime instanceof Number) {
            return ((Number)clsPrime).intValue();
        }
        if (clsPrime instanceof String) {
            try {
                return Integer.parseInt((String)clsPrime);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    protected @Nullable String getProcessName(@NonNull ITmfEvent event) {
        if (this.fFirst != null) {
            return String.valueOf(this.fFirst.getClassifier());
        }
        if (this.fLast != null) {
            return String.valueOf(this.fLast.getClassifier());
        }
        return this.getThreadName(event);
    }

    protected @Nullable String getThreadName(@NonNull ITmfEvent event) {
        if (this.fFirst != null) {
            return this.fFirst.getContext();
        }
        if (this.fLast != null) {
            return this.fLast.getContext();
        }
        return String.format("0x%08x", this.getThreadId(event));
    }

    protected long getThreadId(ITmfEvent event) {
        try {
            if (this.fFirst != null) {
                return Integer.parseInt(this.fFirst.getContext());
            }
            if (this.fLast != null) {
                return Integer.parseInt(this.fLast.getContext());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1L;
    }
}

