/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.QueryParameters;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.TableColumnHeader;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.TreeModelWrapper;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.VirtualTableModelWrapper;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.QueryParametersUtil;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlOutputElement;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.XmlDataProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.annotations.TraceAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.w3c.dom.Element;

@Path(value="/experiments/{expUUID}/outputs")
public class DataProviderService {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(DataProviderService.class);
    private final DataProviderManager manager = DataProviderManager.getInstance();

    @GET
    @Produces(value={"application/json"})
    public Response getProviders(@PathParam(value="expUUID") UUID expUUID) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List list = DataProviderManager.getInstance().getAvailableProviders((ITmfTrace)experiment);
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH)));
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.XY)));
        list.removeIf(dp -> dp.getId().endsWith("org.eclipse.tracecompass.internal.analysis.timing.core.event.matching"));
        return Response.ok((Object)list).build();
    }

    @GET
    @Path(value="/{outputId}")
    @Produces(value={"application/json"})
    public Response getProvider(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId) {
        TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
        if (experiment == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List list = DataProviderManager.getInstance().getAvailableProviders((ITmfTrace)experiment);
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH)));
        list.addAll(DataProviderService.getXmlDataProviderDescriptors((ITmfTrace)experiment, EnumSet.of(XmlUtils.OutputType.XY)));
        Optional<IDataProviderDescriptor> provider = list.stream().filter(p -> p.getId().equals(outputId)).findFirst();
        if (provider.isPresent()) {
            return Response.ok((Object)provider.get()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Path(value="/XY/{outputId}/tree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getXYTree(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/XY/{outputId}/xy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getXY(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getXY", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeXYDataProvider provider = (ITmfTreeXYDataProvider)this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeXYDataProvider.class);
            if (provider == null) {
                provider = (ITmfTreeXYDataProvider)DataProviderService.getXmlProvider((ITmfTrace)experiment, outputId, EnumSet.of(XmlUtils.OutputType.XY));
            }
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateRequestedQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            @NonNull TmfModelResponse response = provider.fetchXY(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GET
    @Path(value="/XY/{outputId}/tooltip")
    @Produces(value={"application/json"})
    public Response getXYTooltip(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, @QueryParam(value="xValue") long xValue, @QueryParam(value="yValue") long yValue, @QueryParam(value="entryId") long entryId) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"XY tooltip are not implemented yet").build();
    }

    @POST
    @Path(value="/timeGraph/{outputId}/tree")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTimeGraphTree(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        return this.getTree(expUUID, outputId, queryParameters);
    }

    @POST
    @Path(value="/timeGraph/{outputId}/states")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getStates(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getStates", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateRequestedQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            TmfModelResponse response = provider.fetchRowModel(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/timeGraph/{outputId}/arrows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getArrows(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getArrows", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateArrowsQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            @NonNull @NonNull TmfModelResponse response = provider.fetchArrows(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @GET
    @Path(value="/markerSets")
    @Produces(value={"application/json"})
    public Response getMarkerSets(@PathParam(value="expUUID") UUID expUUID) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getMarkerSets", new Object[0]).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            List markerSets = MarkerConfigXmlParser.getMarkerSets();
            return Response.ok((Object)new TmfModelResponse((Object)markerSets, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @GET
    @Path(value="/{outputId}/annotations")
    @Produces(value={"application/json"})
    public Response getAnnotationCategories(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, @QueryParam(value="markerSetId") String markerSetId) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing parameter outputId").build();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getAnnotationCategories", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            boolean isComplete = true;
            AnnotationCategoriesModel model = null;
            TraceAnnotationProvider traceAnnotationProvider = ExperimentManagerService.getTraceAnnotationProvider(expUUID);
            if (traceAnnotationProvider != null) {
                @NonNull @NonNull @NonNull ImmutableMap params = markerSetId == null ? Collections.emptyMap() : ImmutableMap.of((Object)"requested_marker_set", (Object)markerSetId);
                @NonNull TmfModelResponse traceAnnotations = traceAnnotationProvider.fetchAnnotationCategories((Map)params, null);
                if (traceAnnotations.getStatus() == ITmfResponse.Status.CANCELLED || traceAnnotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationCategoriesModel(Collections.emptyList()), traceAnnotations.getStatus(), traceAnnotations.getStatusMessage())).build();
                }
                isComplete &= traceAnnotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = (AnnotationCategoriesModel)traceAnnotations.getModel();
            }
            if (provider instanceof IOutputAnnotationProvider) {
                @NonNull TmfModelResponse annotations = ((IOutputAnnotationProvider)provider).fetchAnnotationCategories(Collections.emptyMap(), null);
                if (annotations.getStatus() == ITmfResponse.Status.CANCELLED || annotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationCategoriesModel(Collections.emptyList()), annotations.getStatus(), annotations.getStatusMessage())).build();
                }
                isComplete &= annotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = AnnotationCategoriesModel.of((AnnotationCategoriesModel[])new AnnotationCategoriesModel[]{model, (AnnotationCategoriesModel)annotations.getModel()});
            }
            if (isComplete) {
                return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
            }
            return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/{outputId}/annotations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAnnotations(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getAnnotations", new Object[0]).setCategory(outputId).build();){
            Set selectedCategories;
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateAnnotationsQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            boolean isComplete = true;
            AnnotationModel model = null;
            TraceAnnotationProvider traceAnnotationProvider = ExperimentManagerService.getTraceAnnotationProvider(expUUID);
            if (traceAnnotationProvider != null) {
                @NonNull TmfModelResponse traceAnnotations = traceAnnotationProvider.fetchAnnotations(params, null);
                if (traceAnnotations.getStatus() == ITmfResponse.Status.CANCELLED || traceAnnotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationModel(Collections.emptyMap()), traceAnnotations.getStatus(), traceAnnotations.getStatusMessage())).build();
                }
                isComplete &= traceAnnotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = (AnnotationModel)traceAnnotations.getModel();
            }
            if (provider instanceof IOutputAnnotationProvider) {
                @NonNull TmfModelResponse annotations = ((IOutputAnnotationProvider)provider).fetchAnnotations(params, null);
                if (annotations.getStatus() == ITmfResponse.Status.CANCELLED || annotations.getStatus() == ITmfResponse.Status.FAILED) {
                    return Response.ok((Object)new TmfModelResponse((Object)new AnnotationModel(Collections.emptyMap()), annotations.getStatus(), annotations.getStatusMessage())).build();
                }
                isComplete &= annotations.getStatus() == ITmfResponse.Status.COMPLETED;
                model = AnnotationModel.of((AnnotationModel[])new AnnotationModel[]{model, (AnnotationModel)annotations.getModel()});
            }
            if ((selectedCategories = DataProviderParameterUtils.extractSelectedCategories(params)) != null && model != null) {
                @NonNull LinkedHashMap<@NonNull K, @NonNull @NonNull V> allAnnotations = new LinkedHashMap(model.getAnnotations());
                allAnnotations.keySet().removeIf(cat -> !selectedCategories.contains(cat));
                model = new AnnotationModel(allAnnotations);
            }
            if (isComplete) {
                return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
            }
            return Response.ok((Object)new TmfModelResponse(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/timeGraph/{outputId}/tooltip")
    @Produces(value={"application/json"})
    public Response getTimeGraphTooltip(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getTimeGraphTooltip", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> provider = this.getTimeGraphProvider((ITmfTrace)experiment, outputId);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateTooltipQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            @NonNull @NonNull @NonNull TmfModelResponse response = provider.fetchTooltip(params, null);
            return Response.ok((Object)response).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ITimeGraphDataProvider<@NonNull ITimeGraphEntryModel> getTimeGraphProvider(@NonNull ITmfTrace trace, String outputId) {
        @NonNull ITimeGraphDataProvider provider = (ITimeGraphDataProvider)this.manager.getDataProvider(trace, outputId, ITimeGraphDataProvider.class);
        if (provider == null && outputId != null) {
            provider = (ITimeGraphDataProvider)DataProviderService.getXmlProvider(trace, outputId, EnumSet.of(XmlUtils.OutputType.TIME_GRAPH));
        }
        return provider;
    }

    @POST
    @Path(value="/table/{outputId}/columns")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getColumns(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response response = this.getTree(expUUID, outputId, queryParameters);
        Object entity = response.getEntity();
        if (!(entity instanceof TmfModelResponse)) {
            return response;
        }
        Object model = ((TmfModelResponse)entity).getModel();
        if (!(model instanceof TreeModelWrapper)) {
            return response;
        }
        List<@NonNull ITmfTreeDataModel> entries = ((TreeModelWrapper)model).getEntries();
        ArrayList<TableColumnHeader> columns = new ArrayList<TableColumnHeader>();
        for (ITmfTreeDataModel dataModel : entries) {
            columns.add(new TableColumnHeader(dataModel));
        }
        return Response.ok((Object)new TmfModelResponse(columns, ((TmfModelResponse)entity).getStatus(), ((TmfModelResponse)entity).getStatusMessage())).build();
    }

    @POST
    @Path(value="/table/{outputId}/lines")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLines(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getLines", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            ITmfVirtualTableDataProvider provider = (ITmfVirtualTableDataProvider)this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfVirtualTableDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            Map<String, Object> params = queryParameters.getParameters();
            String errorMessage = QueryParametersUtil.validateLinesQueryParameters(params);
            if (errorMessage != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
            }
            TmfModelResponse response = provider.fetchLines(params, null);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)response.getStatusMessage()).build();
            }
            return Response.ok((Object)new TmfModelResponse((Object)new VirtualTableModelWrapper((ITmfVirtualTableModel)response.getModel()), response.getStatus(), response.getStatusMessage())).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <P extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> P getXmlProvider(@NonNull ITmfTrace trace, @NonNull String id, EnumSet<XmlUtils.OutputType> types) {
        for (XmlUtils.OutputType viewType : types) {
            for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()) && id.equals(element.getId()))) {
                Element viewElement = TmfXmlUtils.getElementInFile((String)element2.getPath(), (String)viewType.getXmlElem(), (String)id);
                if (viewElement != null && viewType == XmlUtils.OutputType.XY) {
                    return (P)XmlDataProviderManager.getInstance().getXyProvider(trace, viewElement);
                }
                if (viewElement == null || viewType != XmlUtils.OutputType.TIME_GRAPH) continue;
                return (P)XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
            }
        }
        return null;
    }

    private static @NonNull List<IDataProviderDescriptor> getXmlDataProviderDescriptors(@NonNull ITmfTrace trace, EnumSet<XmlUtils.OutputType> types) {
        ArrayList<IDataProviderDescriptor> descriptors = new ArrayList<IDataProviderDescriptor>();
        Map modules = TmfAnalysisManager.getAnalysisModules(trace.getClass());
        for (XmlUtils.OutputType viewType : types) {
            block1: for (XmlOutputElement element2 : Iterables.filter((Iterable)XmlUtils.getXmlOutputElements().values(), element -> element.getXmlElem().equals(viewType.getXmlElem()))) {
                DataProviderDescriptor.Builder builder = new DataProviderDescriptor.Builder();
                String label = String.valueOf(element2.getLabel());
                String elemId = element2.getId();
                if (elemId == null) continue;
                builder.setId(elemId).setName(label).setDescription(label);
                if (viewType == XmlUtils.OutputType.XY) {
                    builder.setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY);
                } else if (viewType == XmlUtils.OutputType.TIME_GRAPH) {
                    builder.setProviderType(IDataProviderDescriptor.ProviderType.TIME_GRAPH);
                }
                for (String id : element2.getAnalyses()) {
                    if (!modules.containsKey(id)) continue;
                    descriptors.add(builder.build());
                    continue block1;
                }
            }
        }
        return descriptors;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response getTree(UUID expUUID, String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Map<String, Object> params = queryParameters.getParameters();
        String errorMessage = QueryParametersUtil.validateTreeQueryParameters(params);
        if (errorMessage != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getTree", new Object[0]).setCategory(outputId).build();){
            TmfModelResponse tmfModelResponse;
            TmfModelResponse treeResponse;
            Object model;
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull Object provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                provider = DataProviderService.getXmlProvider((ITmfTrace)experiment, outputId, EnumSet.allOf(XmlUtils.OutputType.class));
            }
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            List timeRequested = DataProviderParameterUtils.extractTimeRequested(params);
            if (timeRequested == null || timeRequested.isEmpty()) {
                params = new HashMap<String, Object>(params);
                timeRequested = ImmutableList.of((Object)experiment.getStartTime().toNanos(), (Object)experiment.getEndTime().toNanos());
                params.put("requested_times", timeRequested);
            }
            if ((model = (treeResponse = provider.fetchTree(params, null)).getModel()) instanceof TmfTreeModel) {
                tmfModelResponse = new TmfModelResponse((Object)new TreeModelWrapper((TmfTreeModel<ITmfTreeDataModel>)((TmfTreeModel)model)), treeResponse.getStatus(), treeResponse.getStatusMessage());
                return Response.ok((Object)tmfModelResponse).build();
            }
            tmfModelResponse = treeResponse;
            return Response.ok((Object)tmfModelResponse).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @POST
    @Path(value="/{outputId}/style")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getStyles(@PathParam(value="expUUID") UUID expUUID, @PathParam(value="outputId") String outputId, QueryParameters queryParameters) {
        Response errorResponse = DataProviderService.validateParameters(outputId, queryParameters);
        if (errorResponse != null) {
            return errorResponse;
        }
        Map<String, Object> params = queryParameters.getParameters();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "DataProviderService#getStyles", new Object[0]).setCategory(outputId).build();){
            TmfExperiment experiment = ExperimentManagerService.getExperimentByUUID(expUUID);
            if (experiment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No such trace").build();
            }
            @NonNull ITmfTreeDataProvider provider = this.manager.getDataProvider((ITmfTrace)experiment, outputId, ITmfTreeDataProvider.class);
            if (provider == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"Analysis cannot run").build();
            }
            if (provider instanceof IOutputStyleProvider) {
                @NonNull TmfModelResponse styleModelResponse = ((IOutputStyleProvider)provider).fetchStyle(params, null);
                return Response.ok((Object)styleModelResponse).build();
            }
            return Response.ok((Object)new TmfModelResponse((Object)new OutputStyleModel(Collections.emptyMap()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED)).build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Response validateParameters(String outputId, QueryParameters queryParameters) {
        if (outputId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing parameter outputId").build();
        }
        if (queryParameters == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing query parameters").build();
        }
        return null;
    }
}

