/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer;

import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;

public final class BaseParser
implements ICommonTreeParser {
    public static final BaseParser INSTANCE = new BaseParser();
    private static final String INVALID_VALUE_FOR_BASE = "Invalid value for base";
    private static final int INTEGER_BASE_16 = 16;
    private static final int INTEGER_BASE_10 = 10;
    private static final int INTEGER_BASE_8 = 8;
    private static final int INTEGER_BASE_2 = 2;

    private BaseParser() {
    }

    @Override
    public Integer parse(CommonTree tree, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        block41: {
            CommonTree firstChild = (CommonTree)tree.getChild(0);
            if (TsdlUtils.isUnaryInteger(firstChild)) {
                if (tree.getChildCount() > 1) {
                    throw new ParseException("invalid base value");
                }
                long intval = UnaryIntegerParser.INSTANCE.parse(firstChild, null);
                if (intval == 2L || intval == 8L || intval == 10L || intval == 16L) {
                    return (int)intval;
                }
                throw new ParseException(INVALID_VALUE_FOR_BASE);
            }
            if (!TsdlUtils.isUnaryString(firstChild)) break block41;
            switch (TsdlUtils.concatenateUnaryStrings(tree.getChildren())) {
                case "d": 
                case "i": 
                case "u": 
                case "dec": 
                case "decimal": {
                    return 10;
                }
                case "X": 
                case "p": 
                case "x": 
                case "hex": 
                case "hexadecimal": {
                    return 16;
                }
                case "o": 
                case "oct": 
                case "octal": {
                    return 8;
                }
                case "binary": 
                case "b": {
                    return 2;
                }
            }
            throw new ParseException(INVALID_VALUE_FOR_BASE);
        }
        throw new ParseException(INVALID_VALUE_FOR_BASE);
    }
}

