/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPMethod
extends PDOMCPPFunction
implements ICPPMethod {
    private static final int METHOD_ANNOTATION = 70;
    protected static final int RECORD_SIZE = 71;
    private byte methodAnnotation = (byte)-1;

    public PDOMCPPMethod(PDOMCPPLinkage linkage, PDOMNode parent, ICPPMethod method) throws CoreException, DOMException {
        super(linkage, parent, method, true);
        this.methodAnnotation = PDOMCPPAnnotations.encodeExtraMethodAnnotations(method);
        this.getDB().putByte(this.record + 70L, this.methodAnnotation);
    }

    public PDOMCPPMethod(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public final void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPMethod) {
            ICPPMethod method = (ICPPMethod)newBinding;
            super.update(linkage, newBinding);
            this.methodAnnotation = (byte)-1;
            byte annot = PDOMCPPAnnotations.encodeExtraMethodAnnotations(method);
            this.getDB().putByte(this.record + 70L, annot);
            this.methodAnnotation = annot;
        } else if (newBinding == null && this.isImplicit()) {
            byte annot = PDOMCPPAnnotations.clearImplicitMethodFlag(this.getMethodAnnotation());
            this.getDB().putByte(this.record + 70L, annot);
            this.methodAnnotation = annot;
        }
    }

    @Override
    protected int getRecordSize() {
        return 71;
    }

    @Override
    public int getNodeType() {
        return 10;
    }

    @Override
    public boolean isVirtual() {
        return PDOMCPPAnnotations.isVirtualMethod(this.getMethodAnnotation());
    }

    private byte getMethodAnnotation() {
        if (this.methodAnnotation == -1) {
            this.methodAnnotation = this.getByte(this.record + 70L);
        }
        return this.methodAnnotation;
    }

    @Override
    public boolean isPureVirtual() {
        return PDOMCPPAnnotations.isPureVirtualMethod(this.getMethodAnnotation());
    }

    @Override
    public boolean isDestructor() {
        return PDOMCPPAnnotations.isDestructor(this.getMethodAnnotation());
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return PDOMCPPAnnotations.isImplicitMethod(this.getMethodAnnotation());
    }

    @Override
    public boolean isExplicit() {
        return PDOMCPPAnnotations.isExplicitMethod(this.getMethodAnnotation());
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public int getVisibility() {
        return PDOMCPPAnnotations.getVisibility(this.getAnnotations());
    }

    @Override
    public ICPPClassType getClassOwner() {
        return (ICPPClassType)((Object)this.getOwner());
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTQualifiedName) {
                if ((parent = parent.getParent()) instanceof IASTIdExpression && (parent = parent.getParent()) instanceof IASTUnaryExpression && ((IASTUnaryExpression)parent).getOperator() == 5) {
                    return 16;
                }
            } else if (parent instanceof ICPPASTFieldReference) {
                ICPPASTFieldReference fr = (ICPPASTFieldReference)parent;
                if ((parent = parent.getParent()) instanceof IASTFunctionCallExpression) {
                    if (fr.isPointerDereference()) {
                        return 16;
                    }
                    IASTExpression fieldOwner = fr.getFieldOwner();
                    if (fieldOwner.getValueCategory().isGLValue()) {
                        IType t;
                        IBinding b;
                        while (fieldOwner instanceof IASTUnaryExpression && ((IASTUnaryExpression)fieldOwner).getOperator() == 11) {
                            fieldOwner = ((IASTUnaryExpression)fieldOwner).getOperand();
                        }
                        if (fieldOwner instanceof IASTIdExpression && (b = ((IASTIdExpression)fieldOwner).getName().resolveBinding()) instanceof IVariable && !((t = ((IVariable)b).getType()) instanceof ICPPReferenceType)) {
                            return 0;
                        }
                        return 16;
                    }
                }
            } else if (parent instanceof IASTIdExpression && parent.getParent() instanceof IASTFunctionCallExpression) {
                return 16;
            }
        }
        return 0;
    }

    @Override
    public IType[] getExceptionSpecification() {
        if (this.isImplicit()) {
            return ClassTypeHelper.getInheritedExceptionSpecification(this);
        }
        return super.getExceptionSpecification();
    }

    @Override
    public boolean isOverride() {
        return PDOMCPPAnnotations.isOverrideMethod(this.getMethodAnnotation());
    }

    @Override
    public boolean isFinal() {
        return PDOMCPPAnnotations.isFinalMethod(this.getMethodAnnotation());
    }
}

