/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;

public class InternalFileContent
extends FileContent {
    private final InclusionKind fKind;
    private final AbstractCharArray fSource;
    private final List<IIndexMacro> fMacroDefinitions;
    private final List<ICPPUsingDirective> fUsingDirectives;
    private final String fFileLocation;
    private final List<FileVersion> fNonPragmaOnceFiles;
    private boolean fHeuristic;
    private boolean fIsSource;
    private ITranslationUnit fTranslationUnit;
    private List<IIndexFile> fFiles;
    private IncludeSearchPathElement fFoundOnPath;
    private final long fTimestamp;
    private final long fFileSize;
    private final long fReadTime;

    public InternalFileContent(String fileLocation, InclusionKind kind) throws IllegalArgumentException {
        if (fileLocation == null || kind != InclusionKind.SKIP_FILE) {
            throw new IllegalArgumentException();
        }
        this.fKind = kind;
        this.fFileLocation = fileLocation;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        this.fSource = null;
        this.fNonPragmaOnceFiles = null;
        this.fTimestamp = -1L;
        this.fFileSize = -1L;
        this.fReadTime = 0L;
    }

    public InternalFileContent(String filePath, AbstractCharArray content, long timestamp, long fileSize, long fileReadTime) throws IllegalArgumentException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.fKind = InclusionKind.USE_SOURCE;
        this.fFileLocation = filePath;
        this.fSource = content;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        this.fNonPragmaOnceFiles = null;
        if (this.fFileLocation == null) {
            throw new IllegalArgumentException();
        }
        this.fTimestamp = timestamp;
        this.fFileSize = fileSize;
        this.fReadTime = fileReadTime;
    }

    public InternalFileContent(String filePath, CharArray content) throws IllegalArgumentException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.fKind = InclusionKind.USE_SOURCE;
        this.fFileLocation = filePath;
        this.fSource = content;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        this.fNonPragmaOnceFiles = null;
        if (this.fFileLocation == null) {
            throw new IllegalArgumentException();
        }
        this.fTimestamp = -1L;
        this.fFileSize = -1L;
        this.fReadTime = 0L;
    }

    public InternalFileContent(String fileLocation, List<IIndexMacro> macroDefinitions, List<ICPPUsingDirective> usingDirectives, List<IIndexFile> files, List<FileVersion> nonPragmaOnceVersions) {
        this.fKind = InclusionKind.FOUND_IN_INDEX;
        this.fFileLocation = fileLocation;
        this.fSource = null;
        this.fUsingDirectives = usingDirectives;
        this.fMacroDefinitions = macroDefinitions;
        this.fFiles = files;
        this.fNonPragmaOnceFiles = nonPragmaOnceVersions;
        this.fTimestamp = -1L;
        this.fFileSize = -1L;
        this.fReadTime = 0L;
    }

    public InclusionKind getKind() {
        return this.fKind;
    }

    @Override
    public String getFileLocation() {
        return this.fFileLocation;
    }

    @Override
    public long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public long getReadTime() {
        return this.fReadTime;
    }

    @Override
    public long getFileSize() {
        return this.fFileSize;
    }

    @Override
    public long getContentsHash() {
        return this.fSource != null ? this.fSource.getContentsHash() : 0L;
    }

    @Override
    public boolean hasError() {
        return this.fSource != null && this.fSource.hasError();
    }

    public AbstractCharArray getSource() {
        return this.fSource;
    }

    public List<IIndexMacro> getMacroDefinitions() {
        return this.fMacroDefinitions;
    }

    public List<ICPPUsingDirective> getUsingDirectives() {
        return this.fUsingDirectives;
    }

    public List<IIndexFile> getFilesIncluded() {
        return this.fFiles;
    }

    public List<FileVersion> getNonPragmaOnceVersions() {
        return this.fNonPragmaOnceFiles;
    }

    public boolean isFoundByHeuristics() {
        return this.fHeuristic;
    }

    public void setFoundByHeuristics(boolean val) {
        this.fHeuristic = val;
    }

    public boolean isSource() {
        return this.fIsSource;
    }

    public void setIsSource(boolean isSource) {
        this.fIsSource = isSource;
    }

    public ITranslationUnit getTranslationUnit() {
        return this.fTranslationUnit;
    }

    public void setTranslationUnit(ITranslationUnit tu) {
        this.fTranslationUnit = tu;
    }

    public IncludeSearchPathElement getFoundOnPath() {
        return this.fFoundOnPath;
    }

    public void setFoundOnPath(IncludeSearchPathElement isp) {
        this.fFoundOnPath = isp;
    }

    public String toString() {
        return this.getSource().toString();
    }

    public static class FileVersion {
        public final String fPath;
        public final ISignificantMacros fSigMacros;

        public FileVersion(String path, ISignificantMacros sig) {
            this.fPath = path;
            this.fSigMacros = sig;
        }
    }

    public static enum InclusionKind {
        SKIP_FILE,
        FOUND_IN_INDEX,
        USE_SOURCE;

    }
}

