/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

@Deprecated
public class PathUtil {
    public static boolean isWindowsFileSystem() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Win");
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            return workspace.getRoot();
        }
        return null;
    }

    public static IPath getCanonicalPath(IPath fullPath) {
        File file = fullPath.toFile();
        try {
            String canonPath = file.getCanonicalPath();
            return new Path(canonPath);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static IPath getWorkspaceRelativePath(IPath fullPath) {
        IPath workspaceLocation;
        IWorkspaceRoot workspaceRoot = PathUtil.getWorkspaceRoot();
        if (workspaceRoot != null && (workspaceLocation = workspaceRoot.getLocation()) != null && workspaceLocation.isPrefixOf(fullPath)) {
            int segments = fullPath.matchingFirstSegments(workspaceLocation);
            IPath relPath = fullPath.setDevice(null).removeFirstSegments(segments);
            return new Path("").addTrailingSeparator().append(relPath);
        }
        return fullPath;
    }

    public static IPath getProjectRelativePath(IPath fullPath, IProject project) {
        IPath projectPath = project.getFullPath();
        if (projectPath.isPrefixOf(fullPath)) {
            return fullPath.removeFirstSegments(projectPath.segmentCount());
        }
        projectPath = project.getLocation();
        if (projectPath.isPrefixOf(fullPath)) {
            return fullPath.removeFirstSegments(projectPath.segmentCount());
        }
        return PathUtil.getWorkspaceRelativePath(fullPath);
    }

    public static IPath getWorkspaceRelativePath(String fullPath) {
        return PathUtil.getWorkspaceRelativePath((IPath)new Path(fullPath));
    }

    public static IPath getRawLocation(IPath wsRelativePath) {
        IPath workspaceLocation;
        IWorkspaceRoot workspaceRoot = PathUtil.getWorkspaceRoot();
        if (workspaceRoot != null && wsRelativePath != null && (workspaceLocation = workspaceRoot.getLocation()) != null && !workspaceLocation.isPrefixOf(wsRelativePath)) {
            return workspaceLocation.append(wsRelativePath);
        }
        return wsRelativePath;
    }

    public static IPath makeRelativePath(IPath path, IPath relativeTo) {
        int segments = relativeTo.matchingFirstSegments(path);
        if (segments > 0) {
            IPath prefix = relativeTo.removeFirstSegments(segments);
            IPath suffix = path.removeFirstSegments(segments);
            Path relativePath = new Path("");
            int i = 0;
            while (i < prefix.segmentCount()) {
                relativePath = relativePath.append("../");
                ++i;
            }
            return relativePath.append(suffix);
        }
        return null;
    }

    public static IPath makeRelativePathToProjectIncludes(IPath fullPath, IProject project) {
        IScannerInfo info;
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider != null && (info = provider.getScannerInformation((IResource)project)) != null) {
            return PathUtil.makeRelativePathToIncludes(fullPath, info.getIncludePaths());
        }
        return null;
    }

    public static IPath makeRelativePathToIncludes(IPath fullPath, String[] includePaths) {
        IPath relativePath = null;
        int mostSegments = 0;
        int i = 0;
        while (i < includePaths.length) {
            int segments;
            Path includePath = new Path(includePaths[i]);
            if (includePath.isPrefixOf(fullPath) && (segments = includePath.matchingFirstSegments(fullPath)) > mostSegments) {
                relativePath = fullPath.removeFirstSegments(segments).setDevice(null);
                mostSegments = segments;
            }
            ++i;
        }
        return relativePath;
    }

    public static ICProject getEnclosingProject(IPath fullPath) {
        IWorkspaceRoot root = PathUtil.getWorkspaceRoot();
        if (root != null) {
            IPath path = PathUtil.getWorkspaceRelativePath(fullPath);
            while (path.segmentCount() > 0) {
                IResource res = root.findMember(path);
                if (res != null) {
                    return CoreModel.getDefault().create(res.getProject());
                }
                path = path.removeLastSegments(1);
            }
        }
        return null;
    }

    public static IPath getValidEnclosingFolder(IPath fullPath) {
        IWorkspaceRoot root = PathUtil.getWorkspaceRoot();
        if (root != null) {
            IPath path = PathUtil.getWorkspaceRelativePath(fullPath);
            while (path.segmentCount() > 0) {
                IResource res = root.findMember(path);
                if (res != null && res.exists() && (res.getType() == 4 || res.getType() == 2)) {
                    return path;
                }
                path = path.removeLastSegments(1);
            }
        }
        return null;
    }
}

