/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.SyscallLookup;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCallsiteAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public final class KernelCallsiteAspect
extends TmfCallsiteAspect {
    private static @Nullable KernelCallsiteAspect sInstance = null;

    public static KernelCallsiteAspect getInstance() {
        KernelCallsiteAspect instance = sInstance;
        if (instance == null) {
            sInstance = instance = new KernelCallsiteAspect();
        }
        return instance;
    }

    private KernelCallsiteAspect() {
    }

    public @Nullable List<ITmfCallsite> resolve(ITmfEvent event) {
        ITmfTrace trace = event.getTrace();
        if (trace instanceof IKernelTrace) {
            String file;
            IKernelAnalysisEventLayout layout = ((IKernelTrace)trace).getKernelEventLayout();
            String syscallName = KernelCallsiteAspect.truncateEntry(layout, event.getName());
            if (syscallName == null) {
                syscallName = KernelCallsiteAspect.truncateExit(layout, event.getName());
            }
            if (syscallName != null && !(file = SyscallLookup.getInstance().getFile(syscallName)).isEmpty()) {
                return Collections.singletonList(new TmfCallsite(file, Long.valueOf(0L)));
            }
        }
        return null;
    }

    private static @Nullable String truncateEntry(IKernelAnalysisEventLayout layout, String syscallName) {
        if (syscallName.startsWith(layout.eventCompatSyscallEntryPrefix())) {
            return syscallName.substring(layout.eventCompatSyscallEntryPrefix().length());
        }
        if (syscallName.startsWith(layout.eventSyscallEntryPrefix())) {
            return syscallName.substring(layout.eventSyscallEntryPrefix().length());
        }
        return null;
    }

    private static @Nullable String truncateExit(IKernelAnalysisEventLayout layout, String syscallName) {
        if (syscallName.startsWith(layout.eventCompatSyscallExitPrefix())) {
            return syscallName.substring(layout.eventCompatSyscallExitPrefix().length());
        }
        if (syscallName.startsWith(layout.eventSyscallExitPrefix())) {
            return syscallName.substring(layout.eventSyscallExitPrefix().length());
        }
        return null;
    }
}

