/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.base;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.IProfilingElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.IProfilingGroupDescriptor;

public class ProfilingElement
implements IProfilingElement {
    public static final int DEFAULT_SYMBOL_KEY = -1;
    private final String fName;
    private final IProfilingGroupDescriptor fDescriptor;
    private final @Nullable IProfilingGroupDescriptor fNextDescriptor;
    private final Collection<IProfilingElement> fChildren = new ArrayList<IProfilingElement>();
    private final @Nullable IProfilingElement fParent;
    private @Nullable IProfilingElement fSymbolKeyElement = null;

    public ProfilingElement(String name, IProfilingGroupDescriptor descriptor) {
        this(name, descriptor, null, null);
    }

    public ProfilingElement(String name, IProfilingGroupDescriptor descriptor, @Nullable IProfilingGroupDescriptor nextGroup, @Nullable IProfilingElement parent) {
        this.fName = name;
        this.fDescriptor = descriptor;
        this.fParent = parent;
        this.fNextDescriptor = nextGroup;
        if (parent instanceof ProfilingElement) {
            this.fSymbolKeyElement = ((ProfilingElement)parent).fSymbolKeyElement;
        }
    }

    @Override
    public Collection<IProfilingElement> getChildren() {
        return this.fChildren;
    }

    @Override
    public void addChild(IProfilingElement node) {
        this.fChildren.add(node);
    }

    @Override
    public IProfilingGroupDescriptor getGroup() {
        return this.fDescriptor;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isLeaf() {
        return this.fNextDescriptor == null;
    }

    @Override
    public @Nullable IProfilingGroupDescriptor getNextGroup() {
        return this.fNextDescriptor;
    }

    @Override
    public void setSymbolKeyElement(IProfilingElement element) {
        this.fSymbolKeyElement = element;
    }

    @Override
    public boolean isSymbolKeyElement() {
        return this.fSymbolKeyElement == this;
    }

    @Override
    public final int getSymbolKeyAt(long startTime) {
        int processId = -1;
        if (this.isSymbolKeyElement()) {
            return this.retrieveSymbolKeyAt(startTime);
        }
        IProfilingElement symbolKeyElement = this.fSymbolKeyElement;
        if (symbolKeyElement == null) {
            return processId;
        }
        return symbolKeyElement.getSymbolKeyAt(startTime);
    }

    protected int retrieveSymbolKeyAt(long time) {
        return -1;
    }

    @Override
    public @Nullable IProfilingElement getParentElement() {
        return this.fParent;
    }

    public String toString() {
        return "Element: " + this.getName() + '[' + this.fDescriptor + ']';
    }
}

