/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.SymbolAspect;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;

abstract class AbstractCalledFunction
implements ICalledFunction {
    static final Comparator<ISegment> COMPARATOR;
    private static final long serialVersionUID = 7992199223906717340L;
    protected final long fStart;
    protected final long fEnd;
    private final @Nullable ICalledFunction fParent;
    protected long fSelfTime = 0L;
    private final int fProcessId;
    private final int fThreadId;
    private final transient IHostModel fModel;
    private transient long fCpuTime = Long.MIN_VALUE;

    static {
        Ordering comp = Ordering.from((Comparator)SegmentComparators.INTERVAL_START_COMPARATOR).compound(SegmentComparators.INTERVAL_END_COMPARATOR);
        COMPARATOR = (Comparator)Objects.requireNonNull(comp);
    }

    public AbstractCalledFunction(long start, long end, int processId, int threadId, @Nullable ICalledFunction parent, IHostModel model) {
        if (start > end) {
            throw new IllegalArgumentException(String.valueOf(Messages.TimeError) + "[" + start + "," + end + "]");
        }
        this.fStart = start;
        this.fEnd = end;
        this.fParent = parent;
        this.fSelfTime = this.fEnd - this.fStart;
        this.fProcessId = processId;
        this.fThreadId = threadId;
        if (parent instanceof AbstractCalledFunction) {
            ((AbstractCalledFunction)parent).addChild(this);
        }
        this.fModel = model;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    @Override
    public @Nullable ICalledFunction getParent() {
        return this.fParent;
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)SymbolAspect.SYMBOL_ASPECT.resolve((ISegment)this));
    }

    protected void addChild(ICalledFunction child) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Child parent not the same as child being added to.");
        }
        this.substractChildDuration(child.getEnd() - child.getStart());
    }

    private void substractChildDuration(long childDuration) {
        this.fSelfTime -= childDuration;
    }

    @Override
    public long getSelfTime() {
        return this.fSelfTime;
    }

    @Override
    public long getCpuTime() {
        long cpuTime = this.fCpuTime;
        if (cpuTime == Long.MIN_VALUE) {
            this.fCpuTime = cpuTime = this.fModel.getCpuTime(this.fThreadId, this.fStart, this.fEnd);
        }
        return cpuTime;
    }

    @Override
    public int getProcessId() {
        return this.fProcessId;
    }

    @Override
    public int getThreadId() {
        return this.fThreadId;
    }

    public int compareTo(@Nullable ISegment o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return COMPARATOR.compare((ISegment)this, o);
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.fStart) + ", " + String.valueOf(this.fEnd) + ']' + " Duration: " + this.getLength() + ", Self Time: " + this.fSelfTime;
    }

    public int hashCode() {
        return Objects.hash(this.fEnd, this.fParent, this.fSelfTime, this.fStart, this.getSymbol());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCalledFunction other = (AbstractCalledFunction)obj;
        return this.fEnd == other.fEnd && this.fSelfTime == other.fSelfTime && this.fStart == other.fStart && Objects.equals(this.fParent, other.getParent()) && Objects.equals(this.getSymbol(), other.getSymbol());
    }
}

