/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.AttributeTree;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.backend.IPartialStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class PartialStateSystem
extends StateSystem {
    private static final String ERR_MSG = "Partial state system should not modify the attribute tree!";
    private final CountDownLatch fSSAssignedLatch = new CountDownLatch(1);
    private final Lock fQueryLock = new ReentrantLock();
    private StateSystem fRealStateSystem = null;

    public PartialStateSystem(@NonNull IPartialStateHistoryBackend backend) {
        super((IStateHistoryBackend)backend);
    }

    public void assignUpstream(ITmfStateSystemBuilder ss) {
        if (!(ss instanceof StateSystem)) {
            throw new IllegalArgumentException("Partial state system's upstream state system should be of class StateSystem. This one is " + ss.getClass());
        }
        this.fRealStateSystem = (StateSystem)ss;
        this.fSSAssignedLatch.countDown();
    }

    ITmfStateSystem getUpstreamSS() {
        return this.fRealStateSystem;
    }

    public void replaceOngoingState(List<@NonNull ITmfStateInterval> ongoingIntervals) {
        super.replaceOngoingState(ongoingIntervals);
    }

    public synchronized void dispose() {
        super.dispose();
    }

    public void takeQueryLock() {
        try {
            this.fQueryLock.lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void releaseQueryLock() {
        this.fQueryLock.unlock();
    }

    public AttributeTree getAttributeTree() {
        this.waitUntilReady();
        return this.fRealStateSystem.getAttributeTree();
    }

    public void addEmptyAttribute() {
        throw new RuntimeException(ERR_MSG);
    }

    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        this.waitUntilReady();
        try {
            return this.fRealStateSystem.getQuarkAbsolute(attribute);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(ERR_MSG);
        }
    }

    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        this.waitUntilReady();
        try {
            return this.fRealStateSystem.getQuarkRelative(startingNodeQuark, subPath);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(ERR_MSG);
        }
    }

    private void waitUntilReady() {
        try {
            this.fSSAssignedLatch.await();
        }
        catch (InterruptedException interruptedException) {}
    }
}

