/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.ease.debugging.model.EaseDebugTarget;
import org.eclipse.ease.debugging.model.EaseDebugThread;

public abstract class EaseDebugElement
extends DebugElement
implements ITerminate,
ISuspendResume,
IDisconnect,
IStep {
    private State fState = State.NOT_STARTED;

    public EaseDebugElement(EaseDebugTarget target) {
        super((IDebugTarget)target);
    }

    public EaseDebugTarget getDebugTarget() {
        return (EaseDebugTarget)super.getDebugTarget();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    protected State getState() {
        return this.fState;
    }

    protected void setState(State state) {
        this.fState = state;
    }

    public boolean canTerminate() {
        if (this.getDebugTarget().getProcess() != null) {
            return this.getDebugTarget().getProcess().canTerminate();
        }
        return false;
    }

    public synchronized void terminate() {
        if (this.getDebugTarget().getProcess() != null) {
            this.getDebugTarget().getProcess().terminate();
        }
    }

    public boolean isTerminated() {
        if (this.getDebugTarget().getProcess() != null) {
            return this.getDebugTarget().getProcess().isTerminated();
        }
        return false;
    }

    public boolean canDisconnect() {
        if (this.getDebugTarget().getProcess() != null) {
            return this.getDebugTarget().getProcess().canDisconnect();
        }
        return false;
    }

    public void disconnect() {
        if (this.getDebugTarget().getProcess() != null) {
            this.getDebugTarget().getProcess().disconnect();
        }
    }

    public boolean isDisconnected() {
        if (this.getDebugTarget().getProcess() != null) {
            return this.getDebugTarget().getProcess().isDisconnected();
        }
        return true;
    }

    public boolean canResume() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canResume();
        }
        return false;
    }

    public boolean canSuspend() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canSuspend();
        }
        return false;
    }

    public boolean isSuspended() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].isSuspended();
        }
        return State.SUSPENDED == this.getState();
    }

    public void resume() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].resume();
        }
    }

    public void suspend() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].suspend();
        }
    }

    public void setSuspended() {
        this.fState = State.SUSPENDED;
        this.fireSuspendEvent(32);
    }

    public void setResumed(int type) {
        this.fState = State.RESUMED;
        this.fireResumeEvent(type);
    }

    public boolean canStepInto() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canStepInto();
        }
        return false;
    }

    public boolean canStepOver() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canStepOver();
        }
        return false;
    }

    public boolean canStepReturn() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].canStepReturn();
        }
        return false;
    }

    public boolean isStepping() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            return threads[0].isStepping();
        }
        return false;
    }

    public synchronized void stepInto() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].stepInto();
        }
    }

    public synchronized void stepOver() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].stepOver();
        }
    }

    public synchronized void stepReturn() {
        EaseDebugThread[] threads = this.getDebugTarget().getThreads();
        if (threads.length == 1) {
            threads[0].stepReturn();
        }
    }

    public static enum State {
        NOT_STARTED,
        SUSPENDED,
        RESUMED,
        STEPPING,
        TERMINATED,
        DISCONNECTED;

    }
}

