/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.ui.help.hovers.IHoverContentProvider;
import org.eclipse.ease.ui.help.hovers.internal.AbstractHoverInformationControlManager;
import org.eclipse.ease.ui.help.hovers.internal.JavaDocLikeHover;
import org.eclipse.ease.ui.help.hovers.internal.StickyHoverManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ControlHoverManager
extends AbstractHoverInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final int WIDGET_PRIORITY = 0;
    private Thread fThread;
    private final Object fMutex = new Object();
    private boolean fProcessMouseHoverEvent = true;
    private MouseMoveListener fMouseMoveListener;
    private final Control fControl;
    private Control fHoverArea;
    private IWidgetTokenOwner fWidgetTokenOwner;
    private final IHoverContentProvider fHoverContent;

    public ControlHoverManager(Control hoverOrigin, Control hoverArea, IWidgetTokenOwner owner, IHoverContentProvider hoverContent) {
        super(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        this.fControl = hoverOrigin;
        this.fHoverArea = hoverArea;
        this.fHoverContent = hoverContent;
        this.fMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                ControlHoverManager.this.fProcessMouseHoverEvent = true;
            }
        };
        this.fControl.addMouseMoveListener(this.fMouseMoveListener);
        this.install(this.fControl, this.fHoverArea);
        JavaDocLikeHover javaDocLikeHover = new JavaDocLikeHover(this.fHoverContent);
        this.setHoverEnrichMode(ITextViewerExtension8.EnrichMode.IMMEDIATELY);
        this.setCustomInformationControlCreator(javaDocLikeHover.getHoverControlCreator());
        StickyHoverManager myStickyHoverManager = new StickyHoverManager(this.fControl, this.fHoverArea, owner);
        this.setInformationControlReplacer(myStickyHoverManager);
        this.fWidgetTokenOwner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void computeInformation() {
        if (!this.fProcessMouseHoverEvent) {
            this.setInformation(null, null);
            return;
        }
        if (this.fThread != null) {
            this.setInformation(null, null);
            return;
        }
        final Object origin = this.getHoverOrigin();
        if (origin == null) {
            this.setInformation(null, null);
            return;
        }
        final Object details = this.getHoverDetails();
        final Rectangle area = this.getHoverInterestArea();
        this.fThread = new Thread("Text Viewer Hover Presenter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block23: {
                    boolean hasFinished = false;
                    try {
                        try {
                            if (ControlHoverManager.this.fThread != null) {
                                Object content = ControlHoverManager.this.fHoverContent.getContent(origin, details);
                                if (content instanceof BrowserInformationControlInput) {
                                    ControlHoverManager.this.setInformation(content, area);
                                } else if (content != null) {
                                    ControlHoverManager.this.setInformation(JavaDocLikeHover.getHoverInfo(content.toString(), null), area);
                                } else {
                                    ControlHoverManager.this.setInformation(null, null);
                                }
                            } else {
                                ControlHoverManager.this.setInformation(null, null);
                            }
                            hasFinished = true;
                        }
                        catch (RuntimeException ex) {
                            String PLUGIN_ID = "org.eclipse.jface.text";
                            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.jface.text"));
                            log.log((IStatus)new Status(4, "org.eclipse.jface.text", 0, "Unexpected runtime error while computing a text hover", (Throwable)ex));
                            Object object = ControlHoverManager.this.fMutex;
                            synchronized (object) {
                                ControlHoverManager.this.fThread = null;
                                if (!hasFinished) {
                                    ControlHoverManager.this.setInformation(null, null);
                                }
                                break block23;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = ControlHoverManager.this.fMutex;
                        synchronized (object) {
                            ControlHoverManager.this.fThread = null;
                            if (!hasFinished) {
                                ControlHoverManager.this.setInformation(null, null);
                            }
                        }
                        throw throwable;
                    }
                    Object object = ControlHoverManager.this.fMutex;
                    synchronized (object) {
                        ControlHoverManager.this.fThread = null;
                        if (!hasFinished) {
                            ControlHoverManager.this.setInformation(null, null);
                        }
                    }
                }
            }
        };
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        Object object = this.fMutex;
        synchronized (object) {
            this.fThread.start();
        }
    }

    protected Object getHoverDetails() {
        return null;
    }

    protected Object getHoverOrigin() {
        return this.fControl;
    }

    protected Rectangle getHoverInterestArea() {
        return new Rectangle(0, 0, this.fControl.getBounds().width, this.fControl.getBounds().height);
    }

    @Override
    protected void presentInformation() {
        if (this.fControl != null && !this.fControl.isDisposed()) {
            Display display = this.fControl.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ControlHoverManager.super.presentInformation();
                }
            });
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        super.hideInformationControl();
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (priority > 0) {
            super.hideInformationControl();
            return true;
        }
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        if (!this.hasInformationControlReplacer()) {
            return false;
        }
        IInformationControl iControl = this.getCurrentInformationControl();
        if (this.canReplace(iControl)) {
            if (this.cancelReplacingDelay()) {
                this.replaceInformationControl(true);
            }
            return true;
        }
        return iControl instanceof IInformationControlExtension5;
    }

    @Override
    public void dispose() {
        if (this.fControl != null && !this.fControl.isDisposed()) {
            this.fControl.removeMouseMoveListener(this.fMouseMoveListener);
        }
        this.fMouseMoveListener = null;
        super.dispose();
    }

    @Override
    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fWidgetTokenOwner != null && this.fWidgetTokenOwner.requestWidgetToken((IWidgetTokenKeeper)this)) {
            super.showInformationControl(subjectArea);
        } else if (DEBUG) {
            System.out.println("TextViewerHoverManager#showInformationControl(..) did not get widget token");
        }
    }

    @Override
    protected void hideInformationControl() {
        try {
            super.hideInformationControl();
        }
        finally {
            if (this.fWidgetTokenOwner != null) {
                this.fWidgetTokenOwner.releaseWidgetToken((IWidgetTokenKeeper)this);
            }
        }
    }

    @Override
    void replaceInformationControl(boolean takeFocus) {
        if (this.fWidgetTokenOwner != null) {
            this.fWidgetTokenOwner.releaseWidgetToken((IWidgetTokenKeeper)this);
        }
        super.replaceInformationControl(takeFocus);
    }

    @Override
    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fWidgetTokenOwner != null) {
                this.fWidgetTokenOwner.releaseWidgetToken((IWidgetTokenKeeper)this);
            }
        }
    }
}

